/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.xar.ant;

import com.jpexs.xar.Xar;
import com.jpexs.xar.nodes.Node;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.TarFileSet;

public class XarTask {
    private Project project;
    private boolean verbose = false;
    private String compression;
    private String checksum;
    private String destFile = null;
    private List<TarFileSet> filesets = new ArrayList<TarFileSet>();

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void addTarFileset(TarFileSet fileset) {
        this.filesets.add(fileset);
    }

    protected void validate() {
        if (this.filesets.isEmpty()) {
            throw new BuildException("fileset not set");
        }
        if (this.destFile == null) {
            throw new BuildException("destFile not set");
        }
    }

    private String[] getFileNames(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        String[] filesPerSe = ds.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    public void execute() {
        this.validate();
        System.out.println("Xar: Creating XAR archive to \"" + this.destFile + "\" ...");
        HashSet<String> files = new HashSet<String>();
        Xar archive = new Xar(this.compression == null ? "gzip" : this.compression, this.checksum == null ? "sha1" : this.checksum);
        for (TarFileSet fs : this.filesets) {
            String fullPath = fs.getFullpath(this.project);
            String prefix = fs.getPrefix(this.project);
            String[] fileNames = this.getFileNames((FileSet)fs);
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                String targetName = !fullPath.isEmpty() ? fullPath : prefix + fileName;
                if ((targetName = targetName.replace('\\', '/')).equals(".")) {
                    targetName = "";
                }
                if (this.verbose) {
                    System.out.println("Xar: Adding \"" + targetName + "\" ...");
                }
                if (files.contains(targetName)) continue;
                files.add(targetName);
                File f = new File(fs.getDir(this.project).getAbsolutePath() + "/" + fileName);
                if (f.isDirectory()) continue;
                try {
                    String baseName = targetName.contains("/") ? targetName.substring(targetName.lastIndexOf("/") + 1) : targetName;
                    String baseDir = targetName.contains("/") ? targetName.substring(0, targetName.lastIndexOf("/")) : "";
                    Node n = archive.add(baseDir, baseName, f);
                    if (fs.hasGroupBeenSet()) {
                        n.group = fs.getGroup();
                    }
                    if (fs.hasGroupIdBeenSet()) {
                        n.gid = fs.getGid();
                    }
                    if (fs.hasUserIdBeenSet()) {
                        n.uid = fs.getUid();
                    }
                    if (fs.hasUserNameBeenSet()) {
                        n.userName = fs.getUserName();
                    }
                    if (!f.isDirectory() || !fs.hasDirModeBeenSet()) continue;
                    n.mode = fs.getDirMode(this.project);
                    continue;
                }
                catch (IOException ex) {
                    throw new BuildException("Xar: Cannot read \"" + f + "\"", (Throwable)ex);
                }
            }
        }
        try {
            archive.save(new File(this.destFile));
        }
        catch (IOException ex) {
            throw new BuildException("Xar: Cannot write to \"" + this.destFile + "\"", (Throwable)ex);
        }
    }
}

