/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.xar;

import com.jpexs.commandline.Commandline;
import com.jpexs.commandline.OptionActionListener;
import com.jpexs.xar.checksum.CheckSum;
import com.jpexs.xar.checksum.MD5CheckSum;
import com.jpexs.xar.checksum.NoCheckSum;
import com.jpexs.xar.checksum.Sha1CheckSum;
import com.jpexs.xar.checksum.errorhandlers.CheckSumErrorHandler;
import com.jpexs.xar.checksum.errorhandlers.WarningCheckSumErrorHandler;
import com.jpexs.xar.encoding.BZip2Encoding;
import com.jpexs.xar.encoding.Encoding;
import com.jpexs.xar.encoding.GZipEncoding;
import com.jpexs.xar.encoding.NoEncoding;
import com.jpexs.xar.nodes.DirectoryNode;
import com.jpexs.xar.nodes.FileNode;
import com.jpexs.xar.nodes.Node;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Xar {
    public static final byte[] MAGIC = new byte[]{120, 97, 114, 33};
    public static final int VERSION = 1;
    public static final int HEADER_SIZE = 28;
    public static final int CKSUM_ALG_NUM_NONE = 0;
    public static final int CKSUM_ALG_NUM_SHA1 = 1;
    public static final int CKSUM_ALG_NUM_MD5 = 2;
    public static final int CKSUM_ALG_NUM_OTHER = 3;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private long currentOffset = 0L;
    private Map<String, Node> allNodes = new TreeMap<String, Node>();
    private List<FileNode> files = new ArrayList<FileNode>();
    private int last_file_id = 0;
    private CheckSum checksum;
    private Encoding encoding;
    private String userName = "root";
    private String group = "root";
    private int defaultGid = 0;
    private int defauiltUid = 0;
    private int defaultMode = 420;
    private long creationTime;
    private CheckSumErrorHandler checkSumErrorHandler;
    private static final Map<String, CheckSum> supportedChecksums = new HashMap<String, CheckSum>();
    private static final Map<String, Encoding> supportedEncodings = new HashMap<String, Encoding>();

    public static void addEncodingType(Encoding e) {
        supportedEncodings.put(e.getSimpleName(), e);
    }

    public static void addCheckSumType(CheckSum c) {
        supportedChecksums.put(c.getName(), c);
    }

    public static Set<String> getSupportedEncodings() {
        return supportedEncodings.keySet();
    }

    public static Set<String> getSupportedCheckSums() {
        return supportedChecksums.keySet();
    }

    public void setDefaultGid(int gid) {
        this.defaultGid = gid;
    }

    public void setDefaultUid(int uid) {
        this.defauiltUid = uid;
    }

    public void setDefaultMode(int mode) {
        this.defaultMode = mode;
    }

    public void setDefaultUserName(String userName) {
        this.userName = userName;
    }

    public void setDefaultGroup(String group) {
        this.group = group;
    }

    public static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public Xar() {
        this("gzip");
    }

    public Xar(String enc_alg) {
        this(enc_alg, "sha1");
    }

    public Xar(String enc_alg, String cksum_alg) {
        if (cksum_alg == null || cksum_alg.equals("")) {
            cksum_alg = "none";
        }
        if (!supportedEncodings.containsKey(enc_alg)) {
            throw new IllegalArgumentException("Uknown encoding type: " + enc_alg);
        }
        if (!supportedChecksums.containsKey(cksum_alg)) {
            throw new IllegalArgumentException("Uknown checksum type: " + cksum_alg);
        }
        this.creationTime = new Date().getTime();
        this.encoding = supportedEncodings.get(enc_alg);
        this.checksum = supportedChecksums.get(cksum_alg);
        this.currentOffset = this.checksum.checkSumLength();
        this.putRoot();
    }

    private void putRoot() {
        DirectoryNode root = new DirectoryNode("");
        root.id = this.last_file_id;
        this.allNodes.put("", root);
    }

    public Xar(File file) throws IOException {
        this(file, new WarningCheckSumErrorHandler());
    }

    public Xar(File file, CheckSumErrorHandler checkSumErrorHandler) throws IOException {
        this.checkSumErrorHandler = checkSumErrorHandler;
        int header_size = 0;
        long toc_length_compressed = 0L;
        String toc = "";
        try (FileInputStream fis = new FileInputStream(file);){
            int cnt;
            DataInputStream dis = new DataInputStream(fis);
            byte[] magic = new byte[MAGIC.length];
            dis.readFully(magic);
            if (!new String(magic).equals(new String(MAGIC))) {
                throw new IOException("No XAR file");
            }
            header_size = dis.readUnsignedShort();
            int version = dis.readUnsignedShort();
            if (version != 1) {
                throw new IOException("Unknown XAR version: " + version);
            }
            toc_length_compressed = dis.readLong();
            dis.readLong();
            int cksum_alg_n = dis.readInt();
            int current_header_size = 28;
            if (cksum_alg_n == 3) {
                int c;
                ByteArrayOutputStream chksum_baos = new ByteArrayOutputStream();
                while ((c = dis.read()) > 0) {
                    chksum_baos.write(c);
                    ++current_header_size;
                }
                ++current_header_size;
            }
            while (current_header_size < header_size) {
                dis.read();
                ++current_header_size;
            }
            byte[] toc_compressed = new byte[(int)toc_length_compressed];
            dis.readFully(toc_compressed);
            InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(toc_compressed));
            ByteArrayOutputStream toc_baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((cnt = iis.read(buf)) > 0) {
                toc_baos.write(buf, 0, cnt);
            }
            byte[] toc_bytes = toc_baos.toByteArray();
            toc = new String(toc_bytes, "UTF-8");
        }
        this.putRoot();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(new TocHandler(file, this, (long)header_size + toc_length_compressed));
            xmlReader.parse(new InputSource(new StringReader(toc)));
        }
        catch (ParserConfigurationException | SAXException ex) {
            // empty catch block
        }
    }

    public void addDirectory(String path) {
        if (path.equals("")) {
            return;
        }
        if ((path = path.replace("\\", "/")).startsWith("/")) {
            path = path.substring(1);
        }
        String baseName = path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
        String baseDir = path.contains("/") ? path.substring(0, path.lastIndexOf("/")) : "";
        this.addDirectory(baseDir);
        if (!this.allNodes.get((Object)baseDir).subnodes.containsKey(baseName)) {
            ++this.last_file_id;
            DirectoryNode dnode = new DirectoryNode(baseName);
            dnode.id = this.last_file_id;
            this.allNodes.get((Object)baseDir).subnodes.put(baseName, dnode);
            this.allNodes.put(path, dnode);
        }
    }

    private static String normalizePath(String path) {
        if ((path = path.replace("\\", "/")).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public Node add(String baseDirPath, String name, File file) throws IOException {
        return this.add(baseDirPath, Node.getInstance(name, file, this.checksum, this.encoding));
    }

    public Node add(String baseDirPath, Node node) {
        if ((baseDirPath = Xar.normalizePath(baseDirPath)).isEmpty() && node.name.isEmpty()) {
            return node;
        }
        this.addDirectory(baseDirPath);
        if (!this.allNodes.get((Object)baseDirPath).subnodes.containsKey(node.name)) {
            ++this.last_file_id;
            node.id = this.last_file_id;
            if (node instanceof FileNode) {
                ((FileNode)node).offset = this.currentOffset;
                this.currentOffset += (long)((FileNode)node).length;
                this.files.add((FileNode)node);
            }
            String fullPath = baseDirPath.isEmpty() ? node.name : baseDirPath + "/" + node.name;
            this.allNodes.put(fullPath, node);
            this.allNodes.get((Object)baseDirPath).subnodes.put(node.name, node);
            if (node.gid == -1) {
                node.gid = this.defaultGid;
            }
            if (node.uid == -1) {
                node.uid = this.defauiltUid;
            }
            if (node.group == null) {
                node.group = this.group;
            }
            if (node.userName == null) {
                node.userName = this.userName;
            }
            if (node.mode == -1) {
                node.mode = this.defaultMode;
            }
            if (node.ctime == -1L) {
                node.ctime = this.creationTime;
            }
            if (node.mtime == -1L) {
                node.mtime = this.creationTime;
            }
            if (node.atime == -1L) {
                node.atime = this.creationTime;
            }
            return node;
        }
        return null;
    }

    public void save(File file) throws IOException {
        int cksum_alg_n = this.checksum.getNum();
        try (FileOutputStream fos = new FileOutputStream(file);){
            DataOutputStream daos = new DataOutputStream(fos);
            String toc = this.getToc();
            ByteArrayOutputStream toc_baos = new ByteArrayOutputStream();
            DeflaterOutputStream toc_deos = new DeflaterOutputStream(toc_baos);
            byte[] toc_bytes = toc.getBytes("UTF-8");
            toc_deos.write(toc_bytes);
            toc_deos.close();
            byte[] toc_compressed_bytes = toc_baos.toByteArray();
            int toc_length_compressed = toc_compressed_bytes.length;
            int toc_length_uncompressed = toc_bytes.length;
            daos.write(MAGIC);
            daos.writeShort(28);
            daos.writeShort(1);
            daos.writeLong(toc_length_compressed);
            daos.writeLong(toc_length_uncompressed);
            daos.writeInt(cksum_alg_n);
            daos.write(toc_compressed_bytes);
            byte[] cksum = this.checksum.checkSum(toc_compressed_bytes);
            daos.write(cksum);
            for (FileNode f : this.files) {
                daos.write(f.compressedData);
            }
            daos.close();
        }
    }

    public String getToc() {
        String toc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xar><toc><creation-time>" + DATE_FORMAT.format(this.creationTime) + "</creation-time>" + (this.checksum.getName().equals("none") ? "" : "<checksum style=\"" + this.checksum.getName() + "\">" + "<offset>0</offset>" + "<size>" + this.checksum.checkSumLength() + "</size>" + "</checksum>");
        for (String k : this.allNodes.get((Object)"").subnodes.keySet()) {
            toc = toc + this.allNodes.get((Object)"").subnodes.get(k);
        }
        toc = toc + "</toc>";
        toc = toc + "</xar>";
        return Xar.prettyFormat(toc, 2);
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException e) {
            return input;
        }
    }

    private static void dumpTextResource(String name) {
        try {
            String line;
            InputStream is = Xar.class.getClassLoader().getResourceAsStream("com/jpexs/xar/" + name + ".txt");
            if (is == null) {
                throw new IOException();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = br.readLine()) != null) {
                System.err.println(line);
            }
        }
        catch (IOException ex) {
            System.err.println("Error: Cannot read " + name);
        }
    }

    public static String getVersion() {
        Properties p = new Properties();
        try {
            p.load(Xar.class.getClassLoader().getResourceAsStream("app.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p.getProperty("version", "uknown");
    }

    public static void main(String[] args) throws IOException {
        final Commandline ap = new Commandline();
        ap.addOption("c", "Creates an archive", "", (option, values, valuesStr) -> {
            String archive = ap.getOptionStrValue("f");
            String[] files = ap.getArgumentStrValues();
            String compression = ap.getOptionStrValue("compression", "gzip");
            String tocCksum = ap.getOptionStrValue("toc-cksum", "sha1");
            if (!Arrays.asList("sha1", "md5", "none").contains(tocCksum)) {
                throw new IllegalArgumentException("Uknown checksum: " + tocCksum);
            }
            if (!Arrays.asList("gzip", "bzip2", "none").contains(compression)) {
                throw new IllegalArgumentException("Uknown compression: " + compression);
            }
            Xar x = new Xar(compression, tocCksum);
            for (String f : files) {
                try {
                    File file = new File(f);
                    if (!file.exists()) {
                        System.err.println("Cannot read \"" + f + "\"");
                        continue;
                    }
                    String path = Xar.normalizePath(file.getPath());
                    String parentDir = path.contains("/") ? path.substring(0, path.lastIndexOf("/")) : "";
                    x.add(parentDir, file.getName(), file);
                }
                catch (IOException ex) {
                    System.err.println("Cannot read \"" + f + "\": " + ex.getMessage());
                }
            }
            try {
                x.save(new File(archive));
            }
            catch (IOException ex) {
                System.err.println("Cannot write \"" + archive + "\": " + ex.getMessage());
                System.exit(1);
            }
            System.exit(0);
        }, 1);
        ap.addOption("x", "Extracts an archive", "", (option, values, valuesStr) -> {
            String archive = ap.getOptionStrValue("f");
            String[] targets = ap.getArgumentStrValues();
            if (targets.length == 0) {
                targets = new String[]{"."};
            }
            Xar x = null;
            try {
                x = new Xar(new File(archive));
            }
            catch (IOException ex) {
                System.err.println("Cannot read \"" + archive + "\": " + ex.getMessage());
                System.exit(1);
            }
            try {
                x.extract(new File(targets[0]));
            }
            catch (IOException ex) {
                System.err.println("Error extracting \"" + archive + "\": " + ex.getMessage());
                System.exit(1);
            }
        }, 1);
        ap.addOption("t", "Lists an archive", "", (option, values, valuesStr) -> {
            Xar x = null;
            String archive = ap.getOptionStrValue("f");
            try {
                x = new Xar(new File(archive));
            }
            catch (IOException ex) {
                System.err.println("Cannot read \"" + archive + "\": " + ex.getMessage());
                System.exit(1);
            }
            x.printTree(System.out);
        }, 1);
        ap.addOption("f", "Specifies an archive to operate on [REQUIRED!]", "s<archive>", null, 1);
        ap.addOption("toc-cksum", "Specifies the hashing algorithm to use for xml header verification.\nValid values: none, sha1, and md5\nDefault: sha1", "s<algorithm>");
        ap.addOption("dump-toc", "Has xar dump the xml header into the specified file.", "s<filename>", new OptionActionListener(){

            @Override
            public void handleOption(String option, Object[] values, String[] valuesStr) {
                Xar x = null;
                String archive = ap.getOptionStrValue("f");
                try {
                    x = new Xar(new File(archive));
                }
                catch (IOException ex) {
                    System.err.println("Cannot read \"" + archive + "\": " + ex.getMessage());
                    System.exit(1);
                }
                String dumTocFile = ap.getOptionStrValue("dump-toc");
                if (dumTocFile != null) {
                    try (FileWriter fw = new FileWriter(dumTocFile);){
                        fw.write(x.getToc());
                    }
                    catch (IOException ex) {
                        System.err.println("Cannot write TOC to \"" + dumTocFile + "\": " + ex.getMessage());
                        System.exit(1);
                    }
                }
            }
        }, 2);
        ap.addOption("compression", "Specifies the compression type to use.\nValid values: none, gzip, bzip2\nDefault: gzip", "s<type>");
        ap.addOption("version", "Print xar's version number", "", (option, values, valuesStr) -> System.out.println("jxar " + Xar.getVersion()), 2);
        ap.disableOptionsTogether("c", "x", "t");
        ap.disableOptionsTogether("c", "x", "t", "dump-toc");
        ap.setArgTypes("s<file>*");
        ap.setAppCommandline("java -jar jxar.jar");
        ap.parseArgs(args);
        System.exit(0);
    }

    public String[] listDirs() {
        String[] ret = new String[this.allNodes.size() - this.files.size()];
        int pos = 0;
        for (String path : this.allNodes.keySet()) {
            if (!(this.allNodes.get(path) instanceof DirectoryNode)) continue;
            ret[pos] = path;
            ++pos;
        }
        return ret;
    }

    public String[] listFiles() {
        String[] ret = new String[this.files.size()];
        int pos = 0;
        for (String path : this.allNodes.keySet()) {
            if (!(this.allNodes.get(path) instanceof FileNode)) continue;
            ret[pos] = path;
            ++pos;
        }
        return ret;
    }

    public void extract(File outdir) throws IOException {
        for (String path : this.allNodes.keySet()) {
            Node n = this.allNodes.get(path);
            File f = new File(outdir.getAbsolutePath() + "/" + path);
            if (n instanceof FileNode) {
                FileOutputStream fos = new FileOutputStream(f);
                Throwable throwable = null;
                try {
                    fos.write(((FileNode)n).data);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                    continue;
                }
            }
            f.mkdirs();
        }
    }

    public byte[] getFileData(String name) {
        if (!this.allNodes.containsKey(name)) {
            return null;
        }
        Node n = this.allNodes.get(name);
        if (n instanceof FileNode) {
            FileNode fn = (FileNode)n;
            return fn.data;
        }
        return null;
    }

    protected void printNode(PrintStream out, Node d, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("--");
        }
        System.out.print("" + d.name);
        if (d instanceof DirectoryNode) {
            System.out.println("/");
        } else {
            System.out.println();
        }
        for (String k : d.subnodes.keySet()) {
            this.printNode(out, d.subnodes.get(k), level + 1);
        }
    }

    public void printTree(PrintStream out) {
        this.printNode(out, this.allNodes.get(""), 0);
    }

    public void printTree() {
        this.printTree(System.out);
    }

    static {
        CheckSum c = new NoCheckSum();
        supportedChecksums.put(c.getName(), c);
        c = new MD5CheckSum();
        supportedChecksums.put(c.getName(), c);
        c = new Sha1CheckSum();
        supportedChecksums.put(c.getName(), c);
        Encoding e = new GZipEncoding();
        supportedEncodings.put(e.getSimpleName(), e);
        try {
            Class.forName("org.itadaki.bzip2.BZip2InputStream");
            e = new BZip2Encoding();
            supportedEncodings.put(e.getSimpleName(), e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        e = new NoEncoding();
        supportedEncodings.put(e.getSimpleName(), e);
    }

    private static class TocHandler
    extends DefaultHandler {
        protected Xar xar;
        private String textData = "";
        long ctime = -1L;
        long mtime = -1L;
        long atime = -1L;
        int gid = -1;
        int uid = -1;
        String group = "";
        String user = "";
        int mode = -1;
        String lastType = "";
        String lastName = "";
        int id = 0;
        String encodingStyle = "";
        int length;
        int size;
        boolean inData;
        boolean inCheckSum = false;
        long offset;
        String archivedCheckSum = "";
        String extractedCheckSum = "";
        String archivedCheckSumStyle = "";
        String extractedCheckSumStyle = "";
        String checkSumStyle = "";
        CheckSum checksum = (CheckSum)Xar.access$000().get("none");
        long heap_offset;
        protected File file;
        Stack<String> path = new Stack();
        Stack<String> typeStack = new Stack();
        Stack<String> nameStack = new Stack();
        protected RandomAccessFile raf;

        protected String getPathString() {
            String ret = "";
            for (String d : this.path) {
                if (!ret.equals("")) {
                    ret = ret + "/";
                }
                ret = ret + d;
            }
            return ret;
        }

        public TocHandler(File file, Xar xar, long heap_offset) throws IOException {
            this.xar = xar;
            this.heap_offset = heap_offset;
            this.raf = new RandomAccessFile(file, "r");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (localName) {
                case "checksum": {
                    this.inCheckSum = true;
                    this.checkSumStyle = attributes.getValue("style");
                    if (this.checkSumStyle.equals("")) {
                        this.checksum = (CheckSum)supportedChecksums.get("none");
                    } else {
                        for (CheckSum c : supportedChecksums.values()) {
                            if (!c.getName().toLowerCase().equals(this.checkSumStyle.toLowerCase())) continue;
                            this.checksum = c;
                            break;
                        }
                    }
                    this.xar.checksum = this.checksum;
                    break;
                }
                case "archived-checksum": {
                    this.archivedCheckSumStyle = attributes.getValue("style");
                    if (this.archivedCheckSumStyle != null) break;
                    this.archivedCheckSumStyle = "SHA1";
                    break;
                }
                case "extracted-checksum": {
                    this.extractedCheckSumStyle = attributes.getValue("style");
                    if (this.extractedCheckSumStyle != null) break;
                    this.extractedCheckSumStyle = "SHA1";
                    break;
                }
                case "data": {
                    this.inData = true;
                    break;
                }
                case "file": {
                    this.ctime = -1L;
                    this.mtime = -1L;
                    this.atime = -1L;
                    this.lastType = "";
                    this.lastName = "";
                    this.encodingStyle = "";
                    this.group = null;
                    this.user = null;
                    this.uid = -1;
                    this.gid = -1;
                    this.length = 0;
                    this.size = 0;
                    this.offset = 0L;
                    this.mode = -1;
                    this.archivedCheckSum = "";
                    this.extractedCheckSum = "";
                    this.id = Integer.parseInt(attributes.getValue("id"));
                    if (this.id <= this.xar.last_file_id) break;
                    this.xar.last_file_id = this.id;
                    break;
                }
                case "encoding": {
                    this.encodingStyle = attributes.getValue("style");
                }
            }
            this.textData = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textData = this.textData + new String(ch, start, length);
        }

        private void addDir() {
            String baseDir = this.getPathString();
            this.path.push(this.nameStack.peek());
            DirectoryNode dnode = new DirectoryNode(this.nameStack.peek());
            dnode.id = this.id;
            ((Node)((Xar)this.xar).allNodes.get((Object)baseDir)).subnodes.put(this.nameStack.peek(), dnode);
            this.xar.allNodes.put(this.getPathString(), dnode);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inCheckSum) {
                // empty if block
            }
            switch (localName) {
                case "creation-time": {
                    try {
                        this.xar.creationTime = DATE_FORMAT.parse(this.textData).getTime();
                    }
                    catch (ParseException ex) {
                        this.xar.creationTime = 0L;
                    }
                    break;
                }
                case "checksum": {
                    this.inCheckSum = false;
                    break;
                }
                case "data": {
                    this.inData = false;
                    break;
                }
                case "file": {
                    Object node = null;
                    String type = this.typeStack.peek();
                    String name = this.nameStack.peek();
                    if (type.equals("directory")) {
                        this.path.pop();
                    } else if (type.equals("file")) {
                        Encoding encoding = null;
                        if (this.encodingStyle.equals("")) {
                            encoding = (Encoding)supportedEncodings.get("none");
                        } else {
                            for (Encoding e : supportedEncodings.values()) {
                                if (!e.getName().equals(this.encodingStyle)) continue;
                                encoding = e;
                                break;
                            }
                        }
                        if (encoding == null) {
                            throw new RuntimeException("Unknown encoding: " + this.encodingStyle);
                        }
                        if (this.extractedCheckSumStyle.equals("")) {
                            this.checksum = (CheckSum)supportedChecksums.get("none");
                        } else {
                            for (CheckSum c : supportedChecksums.values()) {
                                if (!c.getName().toLowerCase().equals(this.extractedCheckSumStyle.toLowerCase())) continue;
                                this.checksum = c;
                                break;
                            }
                        }
                        if (this.checksum == null) {
                            throw new RuntimeException("Unknown checksum: " + this.checkSumStyle);
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] compressedData = new byte[this.length];
                        try {
                            this.raf.seek(this.heap_offset + this.offset);
                            this.raf.readFully(compressedData);
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        FileNode fnode = new FileNode(name, null, compressedData, encoding, this.checksum, this.offset, this.ctime, this.mtime, this.atime, this.mode, this.group, this.gid, this.user, this.uid);
                        fnode.id = this.id;
                        if (!fnode.archivedChecksum.equals(this.archivedCheckSum) || !fnode.extractedChecksum.equals(this.extractedCheckSum)) {
                            this.path.push(name);
                            if (this.xar.checkSumErrorHandler != null) {
                                this.xar.checkSumErrorHandler.handleCheckSumError(this.getPathString());
                            }
                            this.path.pop();
                        } else {
                            String baseDir = this.getPathString();
                            this.path.push(name);
                            this.xar.allNodes.put(this.getPathString(), fnode);
                            this.path.pop();
                            ((Node)((Xar)this.xar).allNodes.get((Object)baseDir)).subnodes.put(name, fnode);
                            this.xar.files.add(fnode);
                            if (this.xar.currentOffset < this.offset + (long)this.length) {
                                this.xar.currentOffset = this.offset + (long)this.length;
                            }
                        }
                    }
                    this.typeStack.pop();
                    this.nameStack.pop();
                    break;
                }
                case "mode": {
                    this.mode = Integer.parseInt(this.textData, 8);
                    break;
                }
                case "name": {
                    this.lastName = this.textData;
                    this.nameStack.push(this.lastName);
                    if (!this.lastType.equals("directory")) break;
                    this.addDir();
                    break;
                }
                case "type": {
                    this.lastType = this.textData;
                    this.typeStack.push(this.lastType);
                    if (!this.lastType.equals("directory") || this.lastName.equals("")) break;
                    this.addDir();
                    break;
                }
                case "user": {
                    this.user = this.textData;
                    break;
                }
                case "group": {
                    this.group = this.textData;
                    break;
                }
                case "uid": {
                    this.uid = Integer.parseInt(this.textData);
                    break;
                }
                case "gid": {
                    this.gid = Integer.parseInt(this.textData);
                    break;
                }
                case "ctime": {
                    try {
                        this.ctime = DATE_FORMAT.parse(this.textData).getTime();
                    }
                    catch (ParseException ex) {}
                    break;
                }
                case "mtime": {
                    try {
                        this.mtime = DATE_FORMAT.parse(this.textData).getTime();
                    }
                    catch (ParseException ex) {}
                    break;
                }
                case "atime": {
                    try {
                        this.atime = DATE_FORMAT.parse(this.textData).getTime();
                        break;
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                }
            }
            if (this.inData) {
                switch (localName) {
                    case "length": {
                        this.length = Integer.parseInt(this.textData);
                        break;
                    }
                    case "size": {
                        this.size = Integer.parseInt(this.textData);
                        break;
                    }
                    case "offset": {
                        this.offset = Integer.parseInt(this.textData);
                        break;
                    }
                    case "archived-checksum": {
                        this.archivedCheckSum = this.textData;
                        break;
                    }
                    case "extracted-checksum": {
                        this.extractedCheckSum = this.textData;
                    }
                }
            }
            this.textData = "";
        }
    }
}

