/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.commandline;

import com.jpexs.commandline.InvalidArgumentsListener;
import com.jpexs.commandline.OptionActionListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Commandline {
    private final Map<String, String> options = new HashMap<String, String>();
    private final Map<String, List<Object>> optionValues = new HashMap<String, List<Object>>();
    private final Map<String, String> optionDescriptions = new HashMap<String, String>();
    private String finalArgType = "";
    private final List<Object> finalValues = new ArrayList<Object>();
    private final Map<String, OptionActionListener> actions = new HashMap<String, OptionActionListener>();
    private final List<String[]> groups = new ArrayList<String[]>();
    private final List<String> optionsOrder = new ArrayList<String>();
    private final List<String> requiredOptions = new ArrayList<String>();
    public static final int REQUIRED_NONE = 0;
    public static final int REQUIRED_YES = 1;
    public static final int REQUIRED_ALONE = 2;
    private final List<String> standaloneOptions = new ArrayList<String>();
    private String appCommandline = "java -jar app.jar";

    public Commandline() {
        this.initHelp();
    }

    private void initHelp() {
        this.addOption("help", "Prints usage", "", (option, values, valuesStr) -> this.printUsage(System.err), 2);
    }

    public void setAppCommandline(String appCommandline) {
        this.appCommandline = appCommandline;
    }

    private String[] objArrToStrArr(Object[] values) {
        if (values == null) {
            return null;
        }
        String[] ret = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = "" + values[i];
        }
        return ret;
    }

    public String[] getOptionStrValues(String option) {
        return this.objArrToStrArr(this.getOptionValues(option));
    }

    public String getOptionStrValue(String option) {
        return this.getOptionStrValue(option, null);
    }

    public String getOptionStrValue(String option, String defaultValue) {
        return "" + this.getOptionValue(option, defaultValue);
    }

    public boolean isOptionOn(String option) {
        return this.optionValues.containsKey(option);
    }

    public Object getOptionValue(String option) {
        return this.getOptionValue(option, null);
    }

    public Object getOptionValue(String option, Object defaultValue) {
        if (!this.optionValues.containsKey(option)) {
            return defaultValue;
        }
        if (this.optionValues.get(option).isEmpty()) {
            return defaultValue;
        }
        return this.optionValues.get(option).get(0);
    }

    protected static String formatOptionName(String option) {
        if (option.length() == 1) {
            return "-" + option;
        }
        return "--" + option;
    }

    public Object[] getOptionValues(String option) {
        if (!this.options.containsKey(option)) {
            throw new IllegalArgumentException("No option " + Commandline.formatOptionName(option) + " defined");
        }
        List<Object> ret = this.optionValues.get(option);
        return ret == null ? null : ret.toArray(new Object[ret.size()]);
    }

    public String[] getArgumentStrValues() {
        return this.objArrToStrArr(this.getArgumentValues());
    }

    public Object[] getArgumentValues() {
        return this.finalValues.toArray(new Object[this.finalValues.size()]);
    }

    public void disableOptionsTogether(String ... grouped) {
        this.groups.add(grouped);
    }

    protected void checkArgType(String argTypes) {
        int prevType = 45;
        block6: for (int i = 0; i < argTypes.length(); ++i) {
            char c = argTypes.charAt(i);
            switch (c) {
                case ' ': {
                    continue block6;
                }
                case 'i': 
                case 's': {
                    prevType = c;
                    continue block6;
                }
                case '<': {
                    i = argTypes.indexOf(62, i + 1);
                    if (i != -1) continue block6;
                    throw new IllegalArgumentException("Invalid arg type, unclosed parent");
                }
                case '*': 
                case '+': {
                    if (prevType != 45) continue block6;
                    throw new IllegalArgumentException("Invalid arg type, '" + c + "' modifier before type");
                }
            }
        }
    }

    public void addOption(String name) {
        this.addOption(name, "", "", null, 0);
    }

    public void addOption(String name, String description) {
        this.addOption(name, description, "", null, 0);
    }

    public void addOption(String name, String description, String argTypes) {
        this.addOption(name, description, argTypes, null, 0);
    }

    public void addOption(String name, String description, String argTypes, OptionActionListener action) {
        this.addOption(name, description, argTypes, action, 0);
    }

    public void addOption(String name, String description, String argTypes, OptionActionListener action, int required) {
        if (argTypes == null) {
            argTypes = "";
        }
        this.checkArgType(argTypes);
        this.options.put(name, argTypes);
        this.actions.put(name, action);
        this.optionDescriptions.put(name, description);
        this.optionsOrder.add(name);
        if (required == 1) {
            this.requiredOptions.add(name);
        }
        if (required == 2) {
            this.standaloneOptions.add(name);
        }
    }

    public void setArgTypes(String type) {
        if (type == null) {
            type = "";
        }
        this.checkArgType(type);
        this.finalArgType = type;
    }

    protected int parseArg(String option, String[] args, int i) {
        String optionFullName;
        String arg_types;
        ++i;
        if (option == null) {
            arg_types = this.finalArgType;
            optionFullName = "Application ";
        } else {
            arg_types = this.options.get(option);
            optionFullName = "Option " + Commandline.formatOptionName(option);
        }
        arg_types = arg_types + "-";
        ArrayList<Object> values = new ArrayList<Object>();
        int lastType = 45;
        int lastModifier = 45;
        block10: for (int j = 0; j < arg_types.length(); ++j) {
            char c = arg_types.charAt(j);
            switch (c) {
                case ' ': {
                    continue block10;
                }
                case '<': {
                    j = arg_types.indexOf(62, j + 1);
                    continue block10;
                }
                case '-': 
                case 'i': 
                case 's': {
                    if (lastType != 45 && i >= args.length) {
                        throw new IllegalArgumentException(optionFullName + " requires arguments:" + this.formatArgTypes(arg_types));
                    }
                    if ((lastModifier == 45 || lastModifier == 43) && lastType != 45) {
                        if (args[i].startsWith("-")) {
                            throw new IllegalArgumentException(optionFullName + " requires arguments:" + this.formatArgTypes(arg_types));
                        }
                        if (lastType == 115) {
                            values.add(args[i]);
                        }
                        if (lastType == 105) {
                            try {
                                values.add(Integer.parseInt(args[i]));
                            }
                            catch (NumberFormatException nfe) {
                                throw new IllegalArgumentException(optionFullName + " requires arguments:" + this.formatArgTypes(arg_types));
                            }
                        }
                        ++i;
                        if (lastModifier == 43) {
                            lastModifier = 42;
                        }
                    }
                    if (lastModifier == 42) {
                        while (i < args.length) {
                            if (args[i].startsWith("-")) {
                                lastModifier = 45;
                                lastType = 45;
                                --i;
                            }
                            if (lastType == 105) {
                                try {
                                    values.add(Integer.parseInt(args[i]));
                                }
                                catch (NumberFormatException nfe) {
                                    lastModifier = 45;
                                    lastType = 45;
                                    --i;
                                }
                            } else if (lastType == 115) {
                                values.add(args[i]);
                            }
                            ++i;
                        }
                    }
                    lastType = c;
                    continue block10;
                }
                case '*': 
                case '+': {
                    lastModifier = c;
                }
            }
        }
        if (option == null) {
            this.finalValues.addAll(values);
        } else {
            this.optionValues.put(option, values);
        }
        return i;
    }

    public void parseArgs(String[] args) {
        this.parseArgs(args, message -> {
            System.err.println(message);
            this.printUsage(System.err);
        });
    }

    protected String formatArgTypes(String argTypes) {
        String ret = "";
        argTypes = argTypes + "-";
        String prevType = null;
        block9: for (int i = 0; i < argTypes.length(); ++i) {
            char c = argTypes.charAt(i);
            switch (c) {
                case ' ': {
                    continue block9;
                }
                case '-': {
                    if (prevType != null) {
                        ret = ret + " " + prevType;
                    }
                    prevType = null;
                    continue block9;
                }
                case 's': {
                    if (prevType != null) {
                        ret = ret + " " + prevType;
                    }
                    prevType = "<string>";
                    continue block9;
                }
                case 'i': {
                    if (prevType != null) {
                        ret = ret + " " + prevType;
                    }
                    prevType = "<integer>";
                    continue block9;
                }
                case '<': {
                    int i2 = argTypes.indexOf(62, i + 1);
                    if (i2 == -1) {
                        throw new IllegalArgumentException("Invalid arg type, unclosed parent");
                    }
                    prevType = "<" + argTypes.substring(i + 1, i2) + ">";
                    i = i2;
                    continue block9;
                }
                case '+': {
                    if (prevType == null) continue block9;
                    ret = ret + " " + prevType + " [" + prevType + "] ...";
                    prevType = null;
                    continue block9;
                }
                case '*': {
                    if (prevType == null) continue block9;
                    ret = ret + " [" + prevType + "] ...";
                    prevType = null;
                }
            }
        }
        return ret;
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public void printUsage(PrintStream out) {
        out.print("Usage: " + this.appCommandline);
        ArrayList<String> allOptions = new ArrayList<String>(this.optionsOrder);
        ArrayList<String> required = new ArrayList<String>();
        ArrayList<String> requiredGrouped = new ArrayList<String>();
        for (String[] group : this.groups) {
            String reqGroup = "";
            boolean allsingle = true;
            for (String goption : group) {
                if (goption.length() > 1) {
                    allsingle = false;
                    break;
                }
                if (this.options.get(goption).isEmpty()) continue;
                allsingle = false;
                break;
            }
            for (String goption : group) {
                if (!allOptions.contains(goption)) continue;
                if (!reqGroup.isEmpty() && !allsingle) {
                    reqGroup = reqGroup + "|";
                }
                reqGroup = allsingle ? reqGroup + goption : reqGroup + Commandline.formatOptionName(goption) + this.formatArgTypes(this.options.get(goption));
                requiredGrouped.add(goption);
            }
            if (reqGroup.isEmpty()) continue;
            if (allsingle) {
                reqGroup = "-[" + reqGroup + "]";
            }
            required.add(reqGroup);
        }
        for (String option : this.requiredOptions) {
            if (requiredGrouped.contains(option)) continue;
            required.add(Commandline.formatOptionName(option) + this.formatArgTypes(this.options.get(option)));
        }
        for (String req : required) {
            out.print(" " + req);
        }
        out.println(this.formatArgTypes(this.finalArgType));
        for (String option : this.optionsOrder) {
            String name = Commandline.formatOptionName(option);
            out.println("\t" + name + this.formatArgTypes(this.options.get(option)) + "\t" + this.optionDescriptions.get(option).replaceAll("\r?\n", "\n\t\t\t"));
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void parseArgs(String[] args, InvalidArgumentsListener listener) {
        try {
            this.optionValues.clear();
            this.finalValues.clear();
            boolean finishPart = false;
            for (int i = 0; i < args.length; ++i) {
                String cur = args[i];
                if (!finishPart) {
                    if (cur.startsWith("--")) {
                        String name = cur.substring(2);
                        if (!this.options.containsKey(name)) {
                            throw new IllegalArgumentException("Unsupported option: " + cur);
                        }
                        i = this.parseArg(name, args, i) - 1;
                    } else if (cur.startsWith("-")) {
                        String combined = cur.substring(1);
                        for (Object name : (Object)combined.toCharArray()) {
                            if (!this.options.containsKey("" + (char)name)) {
                                throw new IllegalArgumentException("Unsupported option: -" + (char)name);
                            }
                            String argTypes = this.options.get("" + (char)name);
                            if (combined.length() > 1 && !argTypes.isEmpty()) {
                                throw new IllegalArgumentException("Option -" + (char)name + " cannot be combined with others as it requires argument(s)");
                            }
                            i = this.parseArg("" + (char)name, args, i) - 1;
                        }
                    } else if (!this.finalArgType.isEmpty()) {
                        finishPart = true;
                    } else {
                        throw new IllegalArgumentException("No additional arguments required");
                    }
                }
                if (!finishPart) continue;
                if (cur.startsWith("-")) {
                    throw new IllegalArgumentException("No option allowed in final part");
                }
                if ((i = this.parseArg(null, args, i - 1)) >= args.length) break;
                throw new IllegalArgumentException("No additional arguments required");
            }
            for (Object group : this.groups) {
                HashSet<Object> used = new HashSet<Object>();
                for (Object opt : group) {
                    if (!this.optionValues.containsKey(opt)) continue;
                    used.add(opt);
                }
                if (used.size() <= 1) continue;
                String pr = "";
                for (String opt : used) {
                    if (!pr.isEmpty()) {
                        pr = pr + ", ";
                    }
                    pr = pr + Commandline.formatOptionName(opt);
                }
                throw new IllegalArgumentException("Options " + pr + " cannot be used together");
            }
            boolean hasStandalone = false;
            for (Object option : this.optionValues.keySet()) {
                if (!this.standaloneOptions.contains(option)) continue;
                hasStandalone = true;
                break;
            }
            if (!hasStandalone) {
                String missingRequired = "";
                block8: for (String re : this.requiredOptions) {
                    if (this.optionValues.containsKey(re)) continue;
                    ArrayList<Integer> inGroups = new ArrayList<Integer>();
                    block9: for (int g = 0; g < this.groups.size(); ++g) {
                        String[] group = this.groups.get(g);
                        for (String goption : group) {
                            if (!goption.equals(re)) continue;
                            inGroups.add(g);
                            break block9;
                        }
                    }
                    if (!inGroups.isEmpty()) {
                        Iterator iterator = inGroups.iterator();
                        while (iterator.hasNext()) {
                            String[] group;
                            int g = (Integer)iterator.next();
                            for (String goption : group = this.groups.get(g)) {
                                if (this.optionValues.containsKey(goption)) continue block8;
                            }
                        }
                    }
                    if (!missingRequired.isEmpty()) {
                        missingRequired = missingRequired + ", ";
                    }
                    missingRequired = missingRequired + Commandline.formatOptionName(re);
                }
                if (!missingRequired.isEmpty()) {
                    throw new IllegalArgumentException("Missing required options: " + missingRequired);
                }
            }
            for (String s : this.optionValues.keySet()) {
                OptionActionListener li = this.actions.get(s);
                if (li == null) continue;
                li.handleOption(s, this.getOptionValues(s), this.getOptionStrValues(s));
            }
        }
        catch (IllegalArgumentException iex) {
            if (listener != null) {
                listener.handleInvalidArguments(iex.getMessage());
            }
            throw iex;
        }
    }
}

