﻿/**
 *  Grasscutter Tools
 *  Copyright (C) 2022 jie65535
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 **/

using System;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

using Newtonsoft.Json;

namespace GrasscutterTools.Utils
{
    internal static class HttpHelper
    {
        public static readonly HttpClient HttpClient = new HttpClient
        {
            Timeout = TimeSpan.FromSeconds(10),
        };

        static HttpHelper()
        {
            ServicePointManager.ServerCertificateValidationCallback = (_, _1, _2, _3) => true;
        }

        public static async Task<T> GetAsync<T>(string url)
        {
            try
            {
                var responseMessage = await HttpClient.GetAsync(url);
                if (!responseMessage.IsSuccessStatusCode)
                    throw new HttpRequestException(responseMessage.ReasonPhrase);
                var responseString = await responseMessage.Content.ReadAsStringAsync();
                return JsonConvert.DeserializeObject<T>(responseString);
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                    throw ex.InnerException;
                throw;
            }
        }

        public static async Task<byte[]> GetDataAsync(string url)
        {
            try
            {
                var responseMessage = await HttpClient.GetAsync(url);
                if (!responseMessage.IsSuccessStatusCode)
                    throw new HttpRequestException(responseMessage.ReasonPhrase);
                return await responseMessage.Content.ReadAsByteArrayAsync();
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                    throw ex.InnerException;
                throw;
            }
        }

        public static async Task<T> PostAsync<T>(string url, object obj)
        {
            try
            {
                var content = new StringContent(JsonConvert.SerializeObject(obj), Encoding.UTF8, "application/json");
                var responseMessage = await HttpClient.PostAsync(url, content);
                if (!responseMessage.IsSuccessStatusCode)
                    throw new HttpRequestException(responseMessage.ReasonPhrase);
                var responseString = await responseMessage.Content.ReadAsStringAsync();
                return JsonConvert.DeserializeObject<T>(responseString);
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                    throw ex.InnerException;
                throw;
            }
        }
    }
}