<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:strip-space elements="*"/>
  <xsl:output omit-xml-declaration="yes" indent="no"/>
  <xsl:template match="ParentData">@model <xsl:value-of select="AppName"/>.Models.<xsl:value-of select="EntityClassName"/>
    <xsl:text disable-output-escaping="yes">
    <xsl:for-each select="ChildData">
      <xsl:sort select="OrdinalPosition" data-type="number"/>
      <xsl:choose>
        <xsl:when test="IsKey = 0">
          <xsl:text disable-output-escaping="yes"><![CDATA[            <div class="form-group">
                <label asp-for="]]></xsl:text>
          <xsl:value-of select="EntityPropertyName"/>
          <xsl:text disable-output-escaping="yes"><![CDATA[" class="control-label"></label>
                <input asp-for="]]></xsl:text>
          <xsl:value-of select="EntityPropertyName"/>
          <xsl:text disable-output-escaping="yes"><![CDATA[" class="form-control" />
                <span asp-validation-for="]]></xsl:text>
          <xsl:value-of select="EntityPropertyName"/>
          <xsl:text disable-output-escaping="yes"><![CDATA[" class="text-danger"></span>
            </div>
]]></xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
    <xsl:text disable-output-escaping="yes"><![CDATA[
          @*@{//UnRemark add line enties here
                await Html.RenderPartialAsync("..\\LineTable\\Lines", new List<LinesType>());
            }*@	            <div class="form-group">
]]></xsl:text>
  </xsl:template>
</xsl:stylesheet>