# Mitwirkung bei ESPHome Ferraris Meter
Willkommen beim Leitfaden zur Mitarbeit an ESPHome Ferraris Meter. Es gibt viele Möglichkeiten, einen Beitrag zu leisten: Fehler melden, neue Funktionen vorschlagen oder Feedback geben.

## 🐞 Probleme melden
Wenn du auf einen Fehler oder ein anderes Problem gestoßen bist, kannst du gerne einen **Problem Report** im [Ticket-System](https://github.com/jensrossbach/esphome-ferraris-meter/issues) erstellen. Bevor du einen Problembericht erstellst, prüfe bitte, ob das Problem bereits von jemand anderem gemeldet wurde. Wenn dies der Fall ist, füge bitte einen Kommentar zu dem bestehenden Problem hinzu, in dem du die Details deines Problems beschreibst (je genauer die Problemberichte sind, desto besser können sie voneinander unterschieden werden, um Duplikate zu identifizieren).

Bitte fasse nicht mehrere Probleme in einem Ticket zusammen, sondern erstelle ein Ticket pro Problem. Versuche, deine Problembeschreibung so genau wie möglich zu formulieren. Es ist immer hilfreich, wenn du Protokolle (mindestens im Detailgrad "debug") zur Verfügung stellst. Schlage in der ESPHome-Dokumentation der [Logger-Komponente](https://www.esphome.io/components/logger.html) nach, wenn du nicht weißt, wie du Protokolle erstellen und den Protokoll-Detailgrad konfigurieren kannst. Du kannst Protokolle über die Befehlszeile mit dem folgenden Befehl aufzeichnen:

```
esphome logs <your_config.yaml>
```

Es könnte auch hilfreich sein, die YAML-Konfiguration deiner ESPHome-Firmware bereitzustellen. Vergiss aber nicht, alle datenschutz- und sicherheitsrelevanten Informationen (z.B. Passwörter) zu entfernen oder verwende `secrets.yaml`, bevor du die Datei hochlädst.

Bitte verwende immer die Vorlage für Problemberichte im Ticket-System, da diese einige vorausgefüllte Hinweise darauf enthält, welche Informationen du in deinem Ticket angeben solltest.

## 💡 Neue Funktionalität anfragen
Falls du eine neue Funktion benötigst oder der Meinung sind, dass eine bestehende Funktion geändert werden muss, diskutiere bitte zuerst deine Idee im [Diskussionsforum](https://github.com/jensrossbach/esphome-ferraris-meter/discussions/categories/ideas) in der Kategorie **Ideas**. Wenn der Konsens ist, dass diese Idee es wert ist, umgesetzt zu werden, dann erstelle einen **Feature Request** oder einen **Change Request** im [Ticket-System](https://github.com/jensrossbach/esphome-ferraris-meter/issues).

Bitte verwende immer die Vorlage für Funktionsanfragen im Ticket-System, da diese einige vorausgefüllte Hinweise darüber enthält, welche Informationen du in deiner Anfrage angeben solltest.

## 👍 Feedback geben
Deine Kommentare und dein Feedback sind willkommen. Bitte teile deine Meinung im [Diskussionsforum](https://github.com/jensrossbach/esphome-ferraris-meter/discussions/categories/feedback) in der Kategorie **Feedback** mit.

-----

# Contributing to ESPHome Ferraris Meter
Welcome to the contribution guide of ESPHome Ferraris Meter. There are many ways to contribute like reporting bugs, proposing new features or providing feedback.

## 🐞 Reporting Problems
If you encountered a bug or other problem, you are welcome to create a **Problem Report** in the [issue tracker](https://github.com/jensrossbach/esphome-ferraris-meter/issues). Before creating the issue, please check if the problem has already been reported by someone else. If so, instead of entering a duplicate issue, please add a comment to the existing issue telling about the details of your problem (the more precise the problem reports are, the better they can be distinguished from each other in order to identify duplicates).

Please do not collect multiple problems in one issue, but instead enter one issue per problem. Try to be as precise as possible with your problem description. It is always helpful if you provide logs on debug level or higher. Refer to the ESPHome documentation of the [logger component](https://www.esphome.io/components/logger.html) if you do not know how to create logs and how to configure the log level. You can record logs from the command line using the following command:

```
esphome logs <your_config.yaml>
```

It could also be helpful to provide the YAML configuration of your ESPHome firmware. But don't forget to remove any privacy and security related data (e.g., passwords) or make use of `secrets.yaml` before uploading the file.

Please always use the Problem Report template in the issue tracker as it provides some prefilled hints about which information you should provide in your report.

## 💡 Requesting Features
In case you need a new feature or think that some existing functionality requires modifications, please first discuss your idea on the [discussion forum](https://github.com/jensrossbach/esphome-ferraris-meter/discussions/categories/ideas) in the **Ideas** category. If the consensus is that this idea is worth being implemented, then and only then create a **Feature Request** or a **Change Request** in the [issue tracker](https://github.com/jensrossbach/esphome-ferraris-meter/issues).

Please always use the Feature Request template in the issue tracker as it provides some prefilled hints about which information you should provide in your request.

## 👍 Providing Feedback
Your comments and feedback are welcome, please share your opinion on the [discussion forum](https://github.com/jensrossbach/esphome-ferraris-meter/discussions/categories/feedback) in the **Feedback** category.
