/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.rcsb;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReadUtils {
    private static final Logger logger = Logger.getLogger(ReadUtils.class.getPackage().getName());
    private static boolean documentBuilderFactorySet = false;

    static String toStr(String s) {
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    static NodeList getNodes(InputStream stream) throws IOException {
        if (!documentBuilderFactorySet) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            documentBuilderFactorySet = true;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.WARNING, "Couldn't configure parser", e);
            stream.close();
            throw new IOException(e);
        }
        try {
            document = builder.parse(stream);
        }
        catch (SAXException e) {
            stream.close();
            throw new IOException(e);
        }
        Element root = document.getDocumentElement();
        return root.getChildNodes();
    }

    static Double toDouble(String s) {
        if (s.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, s + " is not a floating-point number", e);
            return null;
        }
    }

    static Integer toInt(String s) {
        if (s.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, s + " is not an integer", e);
            return null;
        }
    }
}

