/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBBioAssemblyParser {
    private static final Logger logger = LoggerFactory.getLogger(PDBBioAssemblyParser.class);
    private Integer currentBioMolecule = null;
    private List<String> currentChainIDs = new ArrayList<String>();
    private Matrix currentMatrix = null;
    private double[] shift = null;
    private Map<Integer, BioAssemblyInfo> transformationMap = new HashMap<Integer, BioAssemblyInfo>();
    private int modelNumber = 1;
    private int currentMmSize;
    private List<BiologicalAssemblyTransformation> transformations;

    public void pdb_REMARK_350_Handler(String line) {
        if (line.startsWith("REMARK 350 BIOMOLECULE:")) {
            this.initialize();
            this.currentBioMolecule = Integer.parseInt(line.substring(24).trim());
        } else if (line.matches("REMARK 350 \\w+ DETERMINED BIOLOGICAL UNIT:.*") || line.matches("REMARK 350 \\w+ DETERMINED QUATERNARY STRUCTURE:.*")) {
            this.currentMmSize = this.getMmSize(line);
        } else if (line.startsWith("REMARK 350 APPLY THE FOLLOWING TO CHAINS:")) {
            this.currentChainIDs.clear();
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350 IN ADDITION APPLY THE FOLLOWING TO CHAINS:")) {
            this.currentChainIDs.clear();
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350") && line.contains("AND CHAINS:")) {
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350   BIOMT") && this.readMatrix(line)) {
            this.saveMatrix();
            ++this.modelNumber;
        }
    }

    public Map<Integer, BioAssemblyInfo> getTransformationMap() {
        return this.transformationMap;
    }

    private boolean readMatrix(String line) {
        String[] items = line.split("[ ]+");
        String pos = items[2].substring(5);
        int row = Integer.parseInt(pos);
        if (row == 1) {
            this.currentMatrix = Matrix.identity(3, 3);
            this.shift = new double[3];
        }
        this.currentMatrix.set(row - 1, 0, Float.parseFloat(items[4]));
        this.currentMatrix.set(row - 1, 1, Float.parseFloat(items[5]));
        this.currentMatrix.set(row - 1, 2, Float.parseFloat(items[6]));
        this.shift[row - 1] = Float.parseFloat(items[7]);
        return row == 3;
    }

    private void saveMatrix() {
        for (String chainId : this.currentChainIDs) {
            BiologicalAssemblyTransformation transformation = new BiologicalAssemblyTransformation();
            transformation.setRotationMatrix(this.currentMatrix.getArray());
            transformation.setTranslation(this.shift);
            transformation.setId(String.valueOf(this.modelNumber));
            transformation.setChainId(chainId);
            this.transformations.add(transformation);
        }
        if (!this.transformationMap.containsKey(this.currentBioMolecule)) {
            BioAssemblyInfo bioAssembly = new BioAssemblyInfo();
            bioAssembly.setId(this.currentBioMolecule);
            if (this.currentMmSize == 0) {
                logger.warn("No macromolecular size could be parsed for biological assembly {}", (Object)this.currentBioMolecule);
            }
            bioAssembly.setMacromolecularSize(this.currentMmSize);
            bioAssembly.setTransforms(this.transformations);
            this.transformationMap.put(this.currentBioMolecule, bioAssembly);
        }
    }

    private int getMmSize(String line) {
        int index = line.indexOf(58);
        String mmString = line.substring(index + 1, line.length() - 1).trim().toLowerCase();
        return PDBBioAssemblyParser.getSizefromString(mmString);
    }

    private static int getSizefromString(String oligomer) {
        int size = 0;
        if ((oligomer = oligomer.toLowerCase()).equals("monomeric")) {
            size = 1;
        } else if (oligomer.equals("dimeric")) {
            size = 2;
        } else if (oligomer.equals("trimeric")) {
            size = 3;
        } else if (oligomer.equals("tetrameric")) {
            size = 4;
        } else if (oligomer.equals("pentameric")) {
            size = 5;
        } else if (oligomer.equals("hexameric")) {
            size = 6;
        } else if (oligomer.equals("heptameric")) {
            size = 7;
        } else if (oligomer.equals("octameric")) {
            size = 8;
        } else if (oligomer.equals("nonameric")) {
            size = 9;
        } else if (oligomer.equals("decameric")) {
            size = 10;
        } else if (oligomer.equals("undecameric")) {
            size = 11;
        } else if (oligomer.equals("dodecameric")) {
            size = 12;
        } else if (oligomer.equals("tridecameric")) {
            size = 13;
        } else if (oligomer.equals("tetradecameric")) {
            size = 14;
        } else if (oligomer.equals("pentadecameric")) {
            size = 15;
        } else if (oligomer.equals("hexadecameric")) {
            size = 16;
        } else if (oligomer.equals("heptadecameric")) {
            size = 17;
        } else if (oligomer.equals("octadecameric")) {
            size = 18;
        } else if (oligomer.equals("nonadecameric")) {
            size = 19;
        } else if (oligomer.equals("eicosameric")) {
            size = 20;
        } else if (oligomer.matches("(\\d+).*")) {
            size = Integer.parseInt(oligomer.replaceAll("(\\d+).*", "$1"));
        }
        return size;
    }

    private void addToCurrentChainList(String line) {
        int index = line.indexOf(":");
        String chainList = line.substring(index + 1).trim();
        String[] chainIds = chainList.split("[ ,]+");
        this.currentChainIDs.addAll(Arrays.asList(chainIds));
    }

    private void initialize() {
        this.transformations = new ArrayList<BiologicalAssemblyTransformation>();
        this.currentMatrix = Matrix.identity(3, 3);
        this.currentBioMolecule = null;
        this.shift = new double[3];
        this.modelNumber = 1;
        this.currentMmSize = 0;
    }
}

