/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest2;

import cz.siret.prank.fforest2.FasterForest2Tree;
import java.util.concurrent.Callable;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.Utils;

public class VotesCollector
implements Callable<Double> {
    protected final Classifier[] m_Classifiers;
    protected final int instanceIdx;
    protected final Instances data;
    protected final boolean[][] inBag;

    public VotesCollector(Classifier[] m_Classifiers, int instanceIdx, Instances data, boolean[][] inBag) {
        this.m_Classifiers = m_Classifiers;
        this.instanceIdx = instanceIdx;
        this.data = data;
        this.inBag = inBag;
    }

    @Override
    public Double call() throws Exception {
        boolean regression = this.data.classAttribute().isNumeric();
        double[] classProbs = null;
        double regrValue = 0.0;
        if (!regression) {
            classProbs = new double[this.data.numClasses()];
        }
        int numVotes = 0;
        for (int treeIdx = 0; treeIdx < this.m_Classifiers.length; ++treeIdx) {
            if (this.inBag[treeIdx][this.instanceIdx]) continue;
            ++numVotes;
            if (!(this.m_Classifiers[treeIdx] instanceof FasterForest2Tree)) {
                throw new IllegalArgumentException("Only FastRandomTrees accepted in the VotesCollector.");
            }
            FasterForest2Tree aTree = (FasterForest2Tree)this.m_Classifiers[treeIdx];
            if (regression) {
                double curVote = aTree.classifyInstance(this.data.instance(this.instanceIdx));
                regrValue += curVote;
                continue;
            }
            double[] curDist = aTree.distributionForInstance(this.data.instance(this.instanceIdx));
            for (int classIdx = 0; classIdx < curDist.length; ++classIdx) {
                int n = classIdx;
                classProbs[n] = classProbs[n] + curDist[classIdx];
            }
        }
        double vote = regression ? regrValue / (double)numVotes : (double)Utils.maxIndex((double[])classProbs);
        return vote;
    }
}

