/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest2;

public class SplitCriteria {
    public static double entropyConditionedOnRows(double[][] matrix) {
        double returnValue = 0.0;
        for (int branchNum = 0; branchNum < matrix.length; ++branchNum) {
            double sumForBranch = 0.0;
            for (int classNum = 0; classNum < matrix[0].length; ++classNum) {
                returnValue += SplitCriteria.lnFunc(matrix[branchNum][classNum]);
                sumForBranch += matrix[branchNum][classNum];
            }
            returnValue -= SplitCriteria.lnFunc(sumForBranch);
        }
        return -returnValue;
    }

    public static double giniConditionedOnRows(double[][] matrix) {
        double returnValue = 0.0;
        for (int branchNum = 0; branchNum < matrix.length; ++branchNum) {
            double auxSum = matrix[branchNum][0] * matrix[branchNum][0];
            double sumForBranch = matrix[branchNum][0];
            for (int classNum = 1; classNum < matrix[0].length; ++classNum) {
                auxSum += matrix[branchNum][classNum] * matrix[branchNum][classNum];
                sumForBranch += matrix[branchNum][classNum];
            }
            returnValue += sumForBranch - auxSum / sumForBranch;
        }
        return returnValue;
    }

    public static double entropyOverColumns(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int j = 0; j < matrix[0].length; ++j) {
            double sumForColumn = 0.0;
            for (int i = 0; i < matrix.length; ++i) {
                sumForColumn += matrix[i][j];
            }
            returnValue -= SplitCriteria.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        return returnValue + SplitCriteria.lnFunc(total);
    }

    public static double giniOverColumns(double[][] matrix) {
        double auxSum = 0.0;
        double total = 0.0;
        for (int j = 0; j < matrix[0].length; ++j) {
            double sumForColumn = matrix[0][j];
            for (int i = 1; i < matrix.length; ++i) {
                sumForColumn += matrix[i][j];
            }
            auxSum += sumForColumn * sumForColumn;
            total += sumForColumn;
        }
        return total - auxSum / total;
    }

    public static float fastLog2(float val) {
        int bits = Float.floatToIntBits(val);
        int log_2 = (bits >> 23 & 0xFF) - 128;
        bits &= 0x807FFFFF;
        val = Float.intBitsToFloat(bits += 1065353216);
        val = (-0.33333334f * val + 2.0f) * val - 0.6666667f;
        return val + (float)log_2;
    }

    public static double lnFunc(double num) {
        if (num <= 1.0E-6) {
            return 0.0;
        }
        return num * (double)SplitCriteria.fastLog2((float)num);
    }
}

