/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest2;

import cz.siret.prank.fforest.FasterTree;
import cz.siret.prank.fforest2.DataCache;
import cz.siret.prank.fforest2.FastRfUtils;
import cz.siret.prank.fforest2.FasterForest2;
import cz.siret.prank.fforest2.SplitCriteria;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

class FasterForest2Tree
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Runnable {
    static final long serialVersionUID = 8934314652175299375L;
    public boolean[] myInBag;
    public int m_seed;
    public HashSet<Integer> subsetSelectedAttr;
    protected FasterForest2Tree[] m_Successors;
    protected FasterForest2 m_MotherForest;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected double[] m_Prop = null;
    protected double[] m_ClassProbs = null;
    protected transient DataCache data = null;
    protected transient double[] tempProps;
    protected transient double[][] tempDists;
    protected transient double[][] tempDistsOther;
    protected static final int m_MinNum = 1;

    @Deprecated
    public FasterForest2Tree() {
    }

    public FasterForest2Tree(FasterForest2 motherForest, DataCache data, int seed) {
        int numClasses = data.numClasses;
        this.m_seed = seed;
        this.data = data;
        this.m_MotherForest = motherForest;
        this.tempProps = new double[2];
        this.tempDists = new double[2][];
        this.tempDists[0] = new double[numClasses];
        this.tempDists[1] = new double[numClasses];
        this.tempDistsOther = new double[2][];
        this.tempDistsOther[0] = new double[numClasses];
        this.tempDistsOther[1] = new double[numClasses];
    }

    public FasterForest2Tree(FasterForest2 motherForest, DataCache data, double[][] tempDists, double[][] tempDistsOther, double[] tempProps) {
        this.m_MotherForest = motherForest;
        this.data = data;
        this.tempDists = tempDists;
        this.tempDistsOther = tempDistsOther;
        this.tempProps = tempProps;
    }

    public final int getMinNum() {
        return 1;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes.";
    }

    public final int getKValue() {
        return this.m_MotherForest.m_KValue;
    }

    public final int getMaxDepth() {
        return this.m_MotherForest.m_MaxDepth;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        throw new Exception("FasterForest2Tree can be used only by FasterForest2 and FastRfBagger classes, not directly.");
    }

    @Override
    public void run() {
        this.data = this.data.resample(this.data.getRandomNumberGenerator(this.m_seed), this.m_MotherForest.m_numFeatTree);
        this.myInBag = this.data.inBag;
        double[] classProbs = new double[this.data.numClasses];
        for (int i = 0; i < this.data.numInstances; ++i) {
            int n = this.data.instClassValues[i];
            classProbs[n] = classProbs[n] + this.data.instWeights[i];
        }
        this.subsetSelectedAttr = new HashSet(this.data.selectedAttributes.length);
        for (int attr : this.data.selectedAttributes) {
            this.subsetSelectedAttr.add(attr);
        }
        int[] attIndicesWindow = this.data.selectedAttributes;
        this.data.createInBagSortedIndicesNew();
        this.buildTree(this.data.sortedIndices, 0, this.data.numInBag - 1, classProbs, this.m_Debug, attIndicesWindow, 0);
        this.data = null;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] returnedDist = null;
        if (this.m_Attribute != -1) {
            returnedDist = instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance);
            return returnedDist;
        }
        return this.m_ClassProbs;
    }

    public double[] distributionForInstanceInDataCache(DataCache data, int instIdx) {
        if (this.m_Attribute != -1) {
            double[] returnedDist = null;
            returnedDist = (double)data.vals[this.m_Attribute][instIdx] < this.m_SplitPoint ? this.m_Successors[0].distributionForInstanceInDataCache(data, instIdx) : this.m_Successors[1].distributionForInstanceInDataCache(data, instIdx);
            return returnedDist;
        }
        return this.m_ClassProbs;
    }

    private int countNodes() {
        if (this.m_Attribute != -1) {
            int result = 1;
            if (this.m_Successors[0] instanceof FasterForest2Tree) {
                result += this.m_Successors[0].countNodes();
            }
            if (this.m_Successors[1] instanceof FasterForest2Tree) {
                result += this.m_Successors[1].countNodes();
            }
            return result;
        }
        return 1;
    }

    protected void buildTree(int[][] sortedIndices, int startAt, int endAt, double[] classProbs, boolean debug, int[] attIndicesWindow, int depth) {
        this.m_Debug = debug;
        int sortedIndicesLength = endAt - startAt + 1;
        if (sortedIndicesLength < Math.max(2, this.getMinNum()) || Utils.eq((double)classProbs[Utils.maxIndex((double[])classProbs)], (double)Utils.sum((double[])classProbs)) || this.getMaxDepth() > 0 && depth >= this.getMaxDepth()) {
            this.m_Attribute = -1;
            if (sortedIndicesLength != 0) {
                int c = 0;
                while (c < classProbs.length) {
                    int n = c++;
                    classProbs[n] = classProbs[n] / (double)sortedIndicesLength;
                }
            }
            this.m_ClassProbs = classProbs;
            this.data = null;
            return;
        }
        double val = Double.NaN;
        double[][] dist = new double[2][this.data.numClasses];
        double[] prop = new double[2];
        double split = Double.NaN;
        int attIndex = 0;
        int windowSize = attIndicesWindow.length;
        int k = this.getKValue();
        boolean sensibleSplitFound = false;
        double prior = Double.NaN;
        double bestNegPosterior = -1.7976931348623157E308;
        int bestAttIdx = -1;
        while (!(windowSize <= 0 || k-- <= 0 && sensibleSplitFound)) {
            double negPosterior;
            int chosenIndex = this.data.reusableRandomGenerator.nextInt(windowSize);
            attIndex = attIndicesWindow[chosenIndex];
            attIndicesWindow[chosenIndex] = attIndicesWindow[windowSize - 1];
            attIndicesWindow[windowSize - 1] = attIndex;
            --windowSize;
            double candidateSplit = this.distributionSequentialAtt(prop, dist, bestNegPosterior, attIndex, sortedIndices[attIndex], startAt, endAt, classProbs);
            if (Double.isNaN(candidateSplit)) continue;
            split = candidateSplit;
            bestAttIdx = attIndex;
            if (Double.isNaN(prior)) {
                prior = SplitCriteria.giniOverColumns(dist);
            }
            if (!((negPosterior = -SplitCriteria.giniConditionedOnRows(dist)) > bestNegPosterior)) {
                throw new IllegalArgumentException("Very strange!");
            }
            bestNegPosterior = negPosterior;
            val = prior - -negPosterior;
            if (!(val > 0.01)) continue;
            sensibleSplitFound = true;
        }
        if (sensibleSplitFound) {
            this.m_Attribute = bestAttIdx;
            this.m_SplitPoint = split;
            this.m_Prop = prop;
            prop = null;
            int belowTheSplitStartsAt = this.splitDataNew(this.m_Attribute, this.m_SplitPoint, sortedIndices, startAt, endAt, dist);
            this.m_Successors = new FasterForest2Tree[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                FasterForest2Tree auxTree = new FasterForest2Tree(this.m_MotherForest, this.data, this.tempDists, this.tempDistsOther, this.tempProps);
                if (belowTheSplitStartsAt - startAt == 0) {
                    for (int j = 0; j < dist[i].length; ++j) {
                        dist[i][j] = classProbs[j] / (double)sortedIndicesLength;
                    }
                }
                if (i == 0) {
                    auxTree.buildTree(sortedIndices, startAt, belowTheSplitStartsAt - 1, dist[i], this.m_Debug, attIndicesWindow, depth + 1);
                } else {
                    auxTree.buildTree(sortedIndices, belowTheSplitStartsAt, endAt, dist[i], this.m_Debug, attIndicesWindow, depth + 1);
                }
                dist[i] = null;
                this.m_Successors[i] = auxTree;
            }
            sortedIndices = null;
        } else {
            this.m_Attribute = -1;
            if (sortedIndicesLength != 0) {
                int c = 0;
                while (c < classProbs.length) {
                    int n = c++;
                    classProbs[n] = classProbs[n] / (double)sortedIndicesLength;
                }
            }
            this.m_ClassProbs = classProbs;
        }
        this.data = null;
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int size = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            size += this.m_Successors[i].numNodes();
        }
        return size;
    }

    protected int splitDataNew(int att, double splitPoint, int[][] sortedIndices, int startAt, int endAt, double[][] dist) {
        int j;
        Random random = this.data.reusableRandomGenerator;
        int[] num = new int[2];
        int[] tempArr = new int[endAt - startAt + 1];
        Arrays.fill(dist[0], 0.0);
        Arrays.fill(dist[1], 0.0);
        for (j = startAt; j <= endAt; ++j) {
            double rn;
            int inst = sortedIndices[att][j];
            int branch = this.data.isValueMissing(att, inst) ? ((rn = random.nextDouble()) > this.m_Prop[0] ? 1 : 0) : ((double)this.data.vals[att][inst] < splitPoint ? 0 : 1);
            this.data.whatGoesWhere[inst] = branch;
            double[] dArray = dist[branch];
            int n = this.data.instClassValues[inst];
            dArray[n] = dArray[n] + this.data.instWeights[inst];
            int n2 = branch;
            num[n2] = num[n2] + 1;
        }
        for (int a : this.data.attInSortedIndices) {
            int startAbove = startAt;
            int startBelow = 0;
            for (j = startAt; j <= endAt; ++j) {
                int inst = sortedIndices[a][j];
                int branch = this.data.whatGoesWhere[inst];
                if (branch == 0) {
                    sortedIndices[a][startAbove] = sortedIndices[a][j];
                    ++startAbove;
                    continue;
                }
                tempArr[startBelow] = sortedIndices[a][j];
                ++startBelow;
            }
            System.arraycopy(tempArr, 0, sortedIndices[a], startAt + num[0], num[1]);
        }
        return startAt + num[0];
    }

    protected double distributionSequentialAtt(double[] propsBestAtt, double[][] distsBestAtt, double scoreBestAtt, int attToExamine, int[] sortedIndicesOfAtt, int startAt, int endAt, double[] classProbs) {
        int inst;
        int i;
        double splitPoint = -1.7976931348623157E308;
        double[][] dist = this.tempDists;
        double[][] currDist = this.tempDistsOther;
        for (int i2 = 0; i2 < classProbs.length; ++i2) {
            currDist[1][i2] = classProbs[i2];
        }
        double[] props = this.tempProps;
        int sortedIndicesOfAttLength = endAt - startAt + 1;
        Arrays.fill(currDist[0], 0.0);
        int lastNonmissingValIdx = endAt;
        for (int j = endAt; j >= startAt; --j) {
            int inst2 = sortedIndicesOfAtt[j];
            if (!this.data.isValueMissing(attToExamine, sortedIndicesOfAtt[j])) break;
            double[] dArray = currDist[1];
            int n = this.data.instClassValues[inst2];
            dArray[n] = dArray[n] - this.data.instWeights[inst2];
            lastNonmissingValIdx = j - 1;
        }
        if (lastNonmissingValIdx < startAt) {
            return Double.NaN;
        }
        FasterForest2Tree.copyDists(currDist, dist);
        double currVal = -1.7976931348623157E308;
        double bestVal = -1.7976931348623157E308;
        int bestI = 0;
        for (i = startAt + 1; i <= lastNonmissingValIdx; ++i) {
            inst = sortedIndicesOfAtt[i];
            int prevInst = sortedIndicesOfAtt[i - 1];
            double[] dArray = currDist[0];
            int n = this.data.instClassValues[prevInst];
            dArray[n] = dArray[n] + this.data.instWeights[prevInst];
            double[] dArray2 = currDist[1];
            int n2 = this.data.instClassValues[prevInst];
            dArray2[n2] = dArray2[n2] - this.data.instWeights[prevInst];
            if (this.data.instClassValues[prevInst] == this.data.instClassValues[inst] || !(this.data.vals[attToExamine][inst] > this.data.vals[attToExamine][prevInst]) || !((currVal = -SplitCriteria.giniConditionedOnRows(currDist)) > bestVal)) continue;
            bestVal = currVal;
            bestI = i;
        }
        if (bestI > startAt) {
            int instJustBeforeSplit = sortedIndicesOfAtt[bestI - 1];
            int instJustAfterSplit = sortedIndicesOfAtt[bestI];
            splitPoint = (double)(this.data.vals[attToExamine][instJustAfterSplit] + this.data.vals[attToExamine][instJustBeforeSplit]) / 2.0;
            for (int ii = startAt; ii < bestI; ++ii) {
                int inst3 = sortedIndicesOfAtt[ii];
                double[] dArray = dist[0];
                int n = this.data.instClassValues[inst3];
                dArray[n] = dArray[n] + this.data.instWeights[inst3];
                double[] dArray3 = dist[1];
                int n3 = this.data.instClassValues[inst3];
                dArray3[n3] = dArray3[n3] - this.data.instWeights[inst3];
            }
        }
        FasterForest2Tree.countsToFreqs(dist, props);
        for (i = lastNonmissingValIdx + 1; i <= endAt; ++i) {
            inst = sortedIndicesOfAtt[i];
            double[] dArray = dist[0];
            int n = this.data.instClassValues[inst];
            dArray[n] = dArray[n] + props[0] * this.data.instWeights[inst];
            double[] dArray4 = dist[1];
            int n4 = this.data.instClassValues[inst];
            dArray4[n4] = dArray4[n4] + props[1] * this.data.instWeights[inst];
        }
        double curScore = -SplitCriteria.giniConditionedOnRows(dist);
        if (curScore > scoreBestAtt && splitPoint > -1.7976931348623157E308) {
            FasterForest2Tree.copyDists(dist, distsBestAtt);
            System.arraycopy(props, 0, propsBestAtt, 0, props.length);
            return splitPoint;
        }
        return Double.NaN;
    }

    protected static double[] countsToFreqs(double[][] dist) {
        int k;
        double[] props = new double[dist.length];
        for (k = 0; k < props.length; ++k) {
            props[k] = Utils.sum((double[])dist[k]);
        }
        if (Utils.eq((double)Utils.sum((double[])props), (double)0.0)) {
            for (k = 0; k < props.length; ++k) {
                props[k] = 1.0 / (double)props.length;
            }
        } else {
            FastRfUtils.normalize(props);
        }
        return props;
    }

    protected static void countsToFreqs(double[][] dist, double[] props) {
        int k;
        for (k = 0; k < props.length; ++k) {
            props[k] = Utils.sum((double[])dist[k]);
        }
        if (Utils.eq((double)Utils.sum((double[])props), (double)0.0)) {
            for (k = 0; k < props.length; ++k) {
                props[k] = 1.0 / (double)props.length;
            }
        } else {
            FastRfUtils.normalize(props);
        }
    }

    protected static void copyDists(double[][] distFrom, double[][] distTo) {
        int i;
        for (i = 0; i < distFrom[0].length; ++i) {
            distTo[0][i] = distFrom[0][i];
        }
        for (i = 0; i < distFrom[1].length; ++i) {
            distTo[1][i] = distFrom[1][i];
        }
    }

    public static void main(String[] argv) {
        FasterForest2Tree.runClassifier((Classifier)new FasterForest2Tree(), (String[])argv);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 2.0$");
    }

    public FasterTree toLightVersion() {
        int attribute = this.m_Attribute;
        if (attribute < 0) {
            attribute = -1;
        }
        boolean isLeaf = attribute == -1;
        FasterTree leftChild = null;
        FasterTree rightChild = null;
        if (!isLeaf) {
            leftChild = this.m_Successors[0].toLightVersion();
            this.m_Successors[0] = null;
            rightChild = this.m_Successors[1].toLightVersion();
            this.m_Successors = null;
        }
        double[] classProbs = isLeaf ? this.m_ClassProbs : null;
        FasterTree res = new FasterTree(leftChild, rightChild, attribute, this.m_SplitPoint, classProbs);
        return res;
    }
}

