/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest2;

import cz.siret.prank.fforest2.FastRfUtils;
import java.util.Arrays;
import java.util.Random;
import jdk.nashorn.internal.runtime.regexp.joni.exception.ValueException;
import weka.core.Instances;

public class DataCache {
    protected int[] selectedAttributes;
    protected int[] attInSortedIndices;
    protected double[][] levelsClasses;
    protected final float[][] vals;
    protected final int[] attNumVals;
    protected int bagSize;
    protected final int classIndex;
    protected int numAttributes;
    protected final int numClasses;
    protected final int numInstances;
    protected final int[] instClassValues;
    protected int[][] sortedIndices;
    protected double[] instWeights;
    protected boolean[] inBag = null;
    protected int numInBag = 0;
    protected int[] whatGoesWhere = null;
    protected int[] instancesMissVal;
    protected boolean isClassNominal;
    protected Random reusableRandomGenerator = null;

    public float[] scrambleOneAttribute(int attIndex, Random random) {
        float[] toReturn = Arrays.copyOf(this.vals[attIndex], this.vals[attIndex].length);
        for (int i = 0; i < this.vals[attIndex].length; ++i) {
            int swapWith = random.nextInt(this.vals[attIndex].length);
            float temp = this.vals[attIndex][i];
            this.vals[attIndex][i] = this.vals[attIndex][swapWith];
            this.vals[attIndex][swapWith] = temp;
        }
        return toReturn;
    }

    public DataCache(Instances origData) throws Exception {
        int a;
        int i;
        this.classIndex = origData.classIndex();
        this.numAttributes = origData.numAttributes();
        this.numClasses = origData.numClasses();
        this.numInstances = origData.numInstances();
        this.isClassNominal = origData.classAttribute().isNominal();
        this.attNumVals = new int[origData.numAttributes()];
        for (i = 0; i < this.attNumVals.length; ++i) {
            if (origData.attribute(i).isNumeric()) {
                this.attNumVals[i] = 0;
                continue;
            }
            if (origData.attribute(i).isNominal()) {
                this.attNumVals[i] = origData.attribute(i).numValues();
                continue;
            }
            throw new Exception("Only numeric and nominal attributes are supported.");
        }
        this.vals = new float[this.numAttributes][this.numInstances];
        for (a = 0; a < this.numAttributes; ++a) {
            for (int i2 = 0; i2 < this.numInstances; ++i2) {
                this.vals[a][i2] = origData.instance(i2).isMissing(a) ? Float.MAX_VALUE : (float)origData.instance(i2).value(a);
            }
        }
        this.instWeights = new double[this.numInstances];
        this.instClassValues = new int[this.numInstances];
        for (i = 0; i < this.numInstances; ++i) {
            this.instWeights[i] = origData.instance(i).weight();
            this.instClassValues[i] = (int)origData.instance(i).classValue();
        }
        this.sortedIndices = new int[this.numAttributes][];
        for (a = 0; a < this.numAttributes; ++a) {
            if (a == this.classIndex) continue;
            this.sortedIndices[a] = this.attNumVals[a] > 0 ? FastRfUtils.sort(this.vals[a]) : FastRfUtils.sort(this.vals[a]);
        }
    }

    public DataCache(DataCache origData) {
        this.classIndex = origData.classIndex;
        this.numAttributes = origData.numAttributes;
        this.numClasses = origData.numClasses;
        this.numInstances = origData.numInstances;
        this.attNumVals = origData.attNumVals;
        this.instClassValues = origData.instClassValues;
        this.vals = origData.vals;
        this.sortedIndices = origData.sortedIndices;
        this.instWeights = origData.instWeights;
        this.inBag = new boolean[this.numInstances];
        this.numInBag = 0;
        this.whatGoesWhere = null;
        this.isClassNominal = origData.isClassNominal;
    }

    public DataCache resample(Random random, int nAttrVirtual) {
        if (nAttrVirtual >= this.numAttributes) {
            throw new ValueException("nAttr must be less than numAttributes");
        }
        DataCache result = new DataCache(this);
        result.reusableRandomGenerator = random;
        double[] newWeights = new double[this.numInstances];
        for (int r = 0; r < this.bagSize; ++r) {
            int curIdx;
            int n = curIdx = random.nextInt(this.numInstances);
            newWeights[n] = newWeights[n] + this.instWeights[curIdx];
            if (result.inBag[curIdx]) continue;
            ++result.numInBag;
            result.inBag[curIdx] = true;
        }
        result.instWeights = newWeights;
        result.selectedAttributes = new int[nAttrVirtual];
        int[] permIndices = FastRfUtils.randomPermutation(this.numAttributes, random);
        int nAttInSortedIndices = 0;
        for (int i = 0; i < nAttrVirtual; ++i) {
            int a = permIndices[i];
            if (a == this.classIndex) {
                a = permIndices[nAttrVirtual];
            }
            result.selectedAttributes[i] = a;
            nAttInSortedIndices += this.isAttrNominal(a) ? 0 : 1;
        }
        result.attInSortedIndices = new int[nAttInSortedIndices];
        result.whatGoesWhere = new int[result.inBag.length];
        return result;
    }

    protected void createInBagSortedIndicesNew() {
        boolean allCategorical;
        int[][] newSortedIndices = new int[this.numAttributes][];
        this.instancesMissVal = new int[this.numInBag];
        int idx = 0;
        int maxLvl = 0;
        boolean bl = allCategorical = this.attInSortedIndices.length == 0;
        if (allCategorical) {
            this.attInSortedIndices = new int[1];
        }
        for (int a : this.selectedAttributes) {
            if (this.isAttrNominal(a)) {
                maxLvl = Math.max(maxLvl, this.attNumVals[a]);
                if (!allCategorical || a != this.selectedAttributes[0]) continue;
            }
            this.attInSortedIndices[idx] = a;
            ++idx;
            newSortedIndices[a] = new int[this.numInBag];
            int inBagIdx = 0;
            for (int j = 0; j < this.sortedIndices[a].length; ++j) {
                int origIdx = this.sortedIndices[a][j];
                if (!this.inBag[origIdx]) continue;
                newSortedIndices[a][inBagIdx] = this.sortedIndices[a][j];
                ++inBagIdx;
            }
        }
        this.sortedIndices = newSortedIndices;
        this.levelsClasses = new double[maxLvl][this.numClasses];
    }

    public final boolean isValueMissing(int attIndex, int instIndex) {
        return this.vals[attIndex][instIndex] == Float.MAX_VALUE;
    }

    public final boolean isAttrNominal(int attIndex) {
        return this.attNumVals[attIndex] > 0;
    }

    public Random getRandomNumberGenerator(long seed) {
        Random r = new Random(seed);
        long dataSignature = Arrays.toString(this.sortedIndices[r.nextInt(this.numAttributes)]).hashCode();
        r.setSeed(dataSignature + seed);
        return r;
    }
}

