/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class FasterTree
implements Classifier,
Serializable,
Cloneable,
CapabilitiesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 8934314652175299376L;
    protected static final int m_MinNum = 1;
    protected FasterTree sucessorLeft;
    protected FasterTree sucessorRight;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected double[] m_ClassProbs = null;

    public FasterTree(FasterTree sucessorLeft, FasterTree sucessorRight, int m_Attribute, double m_SplitPoint, double[] m_ClassProbs) {
        this.sucessorLeft = sucessorLeft;
        this.sucessorRight = sucessorRight;
        this.m_Attribute = m_Attribute;
        this.m_SplitPoint = m_SplitPoint;
        this.m_ClassProbs = m_ClassProbs;
    }

    public FasterTree() {
    }

    public final int getMinNum() {
        return 1;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        throw new Exception("FasterTree can be used only by FasterForest and FastRfBagger classes, not directly.");
    }

    public final double[] distributionForInstance(Instance instance) {
        if (this.m_Attribute != -1) {
            double[] returnedDist = instance.value(this.m_Attribute) < this.m_SplitPoint ? this.sucessorLeft.distributionForInstance(instance) : this.sucessorRight.distributionForInstance(instance);
            return returnedDist;
        }
        return this.m_ClassProbs;
    }

    public final double[] distributionForAttributes(double[] instanceAttributes) {
        if (this.m_Attribute != -1) {
            if (instanceAttributes[this.m_Attribute] < this.m_SplitPoint) {
                return this.sucessorLeft.distributionForAttributes(instanceAttributes);
            }
            return this.sucessorRight.distributionForAttributes(instanceAttributes);
        }
        return this.m_ClassProbs;
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int size = 1;
        size += this.sucessorLeft.numNodes();
        return size += this.sucessorRight.numNodes();
    }

    public FasterTree toSlimVersion() {
        FasterTree left = this.sucessorLeft == null ? null : this.sucessorLeft.toSlimVersion();
        this.sucessorLeft = null;
        FasterTree right = this.sucessorRight == null ? null : this.sucessorRight.toSlimVersion();
        this.sucessorRight = null;
        FasterTree res = new FasterTree(left, right, this.m_Attribute, this.m_SplitPoint, this.m_ClassProbs);
        return res;
    }

    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        switch (instance.classAttribute().type()) {
            case 1: {
                double max = 0.0;
                int maxIndex = 0;
                for (int i = 0; i < dist.length; ++i) {
                    if (!(dist[i] > max)) continue;
                    maxIndex = i;
                    max = dist[i];
                }
                if (max > 0.0) {
                    return maxIndex;
                }
                return Utils.missingValue();
            }
            case 0: 
            case 3: {
                return dist[0];
            }
        }
        return Utils.missingValue();
    }
}

