/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.fforest;

import cz.siret.prank.fforest.FasterForest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.experiment.PairedStatsCorrected;

public class Benchmark {
    public static final int numRuns = 10;
    public static final int numFolds = 10;

    public static void main(String[] args) throws Exception {
        List<File> trainFiles = Benchmark.getMatchingFiles(args[0], ".arff");
        ArrayList<Integer> threadNums = new ArrayList<Integer>();
        if (args.length < 3) {
            threadNums.add(0);
        } else {
            String[] arr;
            for (String curNum : arr = args[2].split(",")) {
                threadNums.add(Integer.parseInt(curNum));
            }
        }
        AbstractClassifier[] classifiers = new AbstractClassifier[threadNums.size() * 2];
        for (int i = 0; i < threadNums.size() * 2; i += 2) {
            classifiers[i] = new RandomForest();
            classifiers[i].setOptions(new String[]{"-I", args[1], "-num-slots", Integer.toString((Integer)threadNums.get(i))});
            classifiers[i + 1] = new FasterForest();
            classifiers[i + 1].setOptions(new String[]{"-I", args[1], "-threads", Integer.toString((Integer)threadNums.get(i))});
        }
        StringBuilder s = new StringBuilder("dataset\tnumInstances\tnumNumericAtt\tnumNominalAtt\tnumClasses");
        for (int i = 0; i < classifiers.length * 10; ++i) {
            s.append("\tcfr|run\tAUC\tAccy\tmillis");
        }
        s.append("\tsummary");
        System.err.println(s.toString());
        for (File curArff : trainFiles) {
            Instances data = new ConverterUtils.DataSource(curArff.toString()).getDataSet();
            if (data.classIndex() == -1) {
                data.setClassIndex(data.numAttributes() - 1);
            }
            data.deleteWithMissingClass();
            int numNumeric = 0;
            int numNominal = 0;
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i) continue;
                if (data.attribute(i).isNominal()) {
                    ++numNominal;
                }
                if (!data.attribute(i).isNumeric()) continue;
                ++numNumeric;
            }
            System.err.printf("%s\t%d\t%d\t%d\t%d\t", curArff.getName(), data.numInstances(), numNumeric, numNominal, data.numClasses());
            double[] classProps = new double[data.numClasses()];
            for (int i = 0; i < data.numInstances(); ++i) {
                int n = (int)data.instance(i).classValue();
                classProps[n] = classProps[n] + data.instance(i).weight();
            }
            Utils.normalize((double[])classProps);
            double[][] aucScore = new double[classifiers.length][10];
            double[][] accyScore = new double[classifiers.length][10];
            double[][] timeScore = new double[classifiers.length][10];
            for (int curRun = 1; curRun <= 10; ++curRun) {
                s = new StringBuilder();
                for (int curCfr = 0; curCfr < classifiers.length; ++curCfr) {
                    AbstractClassifier aClassifier = classifiers[curCfr];
                    Evaluation eval = new Evaluation(data);
                    Long millis = System.currentTimeMillis();
                    eval.crossValidateModel((Classifier)aClassifier, data, 10, new Random(curRun), new Object[0]);
                    long elapsedTime = System.currentTimeMillis() - millis;
                    double aucSum = 0.0;
                    double sumClassProps = 0.0;
                    for (int c = 0; c < data.numClasses(); ++c) {
                        if (Double.isNaN(eval.areaUnderROC(c))) continue;
                        aucSum += eval.areaUnderROC(c) * classProps[c];
                        sumClassProps += classProps[c];
                    }
                    aucScore[curCfr][curRun - 1] = aucSum / sumClassProps;
                    accyScore[curCfr][curRun - 1] = eval.pctCorrect();
                    timeScore[curCfr][curRun - 1] = elapsedTime;
                    s.append(String.format(Locale.US, "%02d|%02d\t%.5f\t%.2f\t%6d\t", curCfr, curRun, aucSum / sumClassProps, eval.pctCorrect(), elapsedTime));
                    System.gc();
                }
                System.err.print(s.toString());
            }
            double testTrainRatio = 0.1111111111111111;
            PairedStatsCorrected pscAuc = new PairedStatsCorrected(0.05, testTrainRatio);
            pscAuc.add(aucScore[0], aucScore[1]);
            pscAuc.calculateDerived();
            PairedStatsCorrected pscAccy = new PairedStatsCorrected(0.05, testTrainRatio);
            pscAccy.add(accyScore[0], accyScore[1]);
            pscAccy.calculateDerived();
            PairedStatsCorrected pscTime = new PairedStatsCorrected(0.05, testTrainRatio);
            pscTime.add(timeScore[0], timeScore[1]);
            pscTime.calculateDerived();
            System.err.printf(Locale.US, "| Statistical significance of difference in mean of AUC scores is p=%6.4f (%s wins), in accuracy is p=%6.4f (%s wins).  Average speedup is: %4.2f times.\n", pscAuc.differencesProbability, Benchmark.getTextForSignificance(pscAuc.differencesSignificance, "WekaRF", "FastRF"), pscAccy.differencesProbability, Benchmark.getTextForSignificance(pscAccy.differencesSignificance, "WekaRF", "FastRF"), pscTime.xStats.mean / pscTime.yStats.mean);
        }
    }

    public static List<File> getMatchingFiles(String fileOrDir, String extension) throws FileNotFoundException, IOException {
        ArrayList<File> result = new ArrayList<File>();
        File myFile = new File(fileOrDir);
        String myExt = extension.length() > 0 && extension.charAt(0) != '.' ? "." + extension : extension;
        if (!myFile.exists()) {
            throw new FileNotFoundException("Specified File or directory doesn't exist!");
        }
        if (myFile.isDirectory()) {
            File[] trainFiles = new File(fileOrDir).listFiles();
            for (int i = 0; i < trainFiles.length; ++i) {
                if (!trainFiles[i].getName().endsWith(myExt)) continue;
                result.add(trainFiles[i]);
            }
        } else if (myFile.getName().endsWith(myExt)) {
            result.add(myFile);
        } else {
            BufferedReader bufRdr = new BufferedReader(new FileReader(fileOrDir));
            String line = null;
            while ((line = bufRdr.readLine()) != null) {
                if (line.endsWith(myExt)) {
                    result.add(new File(line));
                    continue;
                }
                result.add(new File(line + myExt));
            }
        }
        return result;
    }

    private static String getTextForSignificance(int significanceFlag, String party1, String party2) {
        if (significanceFlag == 0) {
            return "noone";
        }
        if (significanceFlag > 0) {
            return party1;
        }
        return party2;
    }
}

