/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

public class SplitCriteria {
    public static double entropyConditionedOnRows(double[][] matrix) {
        double returnValue = 0.0;
        for (int branchNum = 0; branchNum < matrix.length; ++branchNum) {
            double sumForBranch = 0.0;
            for (int classNum = 0; classNum < matrix[0].length; ++classNum) {
                returnValue += SplitCriteria.lnFunc(matrix[branchNum][classNum]);
                sumForBranch += matrix[branchNum][classNum];
            }
            returnValue -= SplitCriteria.lnFunc(sumForBranch);
        }
        return -returnValue;
    }

    public static double entropyOverColumns(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int j = 0; j < matrix[0].length; ++j) {
            double sumForColumn = 0.0;
            for (int i = 0; i < matrix.length; ++i) {
                sumForColumn += matrix[i][j];
            }
            returnValue -= SplitCriteria.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        return returnValue + SplitCriteria.lnFunc(total);
    }

    public static float fastLog2(float val) {
        int bits = Float.floatToIntBits(val);
        int log_2 = (bits >> 23 & 0xFF) - 128;
        bits &= 0x807FFFFF;
        val = Float.intBitsToFloat(bits += 1065353216);
        val = (-0.33333334f * val + 2.0f) * val - 0.6666667f;
        return val + (float)log_2;
    }

    private static double lnFunc(double num) {
        if (num <= 1.0E-6) {
            return 0.0;
        }
        return num * (double)SplitCriteria.fastLog2((float)num);
    }
}

