/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

import java.util.Random;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class FastRfUtils {
    public static int[] sort(float[] array) {
        int[] index = new int[array.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        array = (float[])array.clone();
        FastRfUtils.quickSort(array, index, 0, array.length - 1);
        return index;
    }

    private static int partition(float[] array, int[] index, int l, int r) {
        double pivot = array[index[(l + r) / 2]];
        while (l < r) {
            while ((double)array[index[l]] < pivot && l < r) {
                ++l;
            }
            while ((double)array[index[r]] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && (double)array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    private static void quickSort(float[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = FastRfUtils.partition(array, index, left, right);
            FastRfUtils.quickSort(array, index, left, middle);
            FastRfUtils.quickSort(array, index, middle + 1, right);
        }
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        FastRfUtils.normalize(doubles, sum);
    }

    private static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            return;
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static int[] randomPermutation(int numElems, Random rng) {
        int i;
        int[] permutation = new int[numElems];
        for (i = 0; i < numElems; ++i) {
            permutation[i] = i;
        }
        for (i = 0; i < numElems - 1; ++i) {
            int next = rng.nextInt(numElems);
            int tmp = permutation[i];
            permutation[i] = permutation[next];
            permutation[next] = tmp;
        }
        return permutation;
    }

    public static Instances scramble(Instances src, Instances dst, int attIndex, int[] perm) {
        for (int i = 0; i < src.numInstances(); ++i) {
            Instance scrambled = dst.instance(i);
            if (attIndex > 0) {
                scrambled.setValue(attIndex - 1, src.instance(i).value(attIndex - 1));
            }
            scrambled.setValue(attIndex, src.instance(perm[i]).value(attIndex));
        }
        return dst;
    }

    public static Instances readInstances(String location) throws Exception {
        Instances data = new ConverterUtils.DataSource(location).getDataSet();
        if (data.classIndex() == -1) {
            data.setClassIndex(data.numAttributes() - 1);
        }
        return data;
    }
}

