/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

import hr.irb.fastRandomForest.DataCache;
import hr.irb.fastRandomForest.FastRandomForest;
import hr.irb.fastRandomForest.FastRfUtils;
import hr.irb.fastRandomForest.SplitCriteria;
import java.util.Arrays;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

class FastRandomTree
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Runnable {
    static final long serialVersionUID = 8934314652175299375L;
    protected FastRandomTree[] m_Successors;
    protected FastRandomForest m_MotherForest;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected double[] m_Prop = null;
    protected double[] m_ClassProbs = null;
    protected transient DataCache data = null;
    protected transient double[] tempProps;
    protected transient double[][] tempDists;
    protected transient double[][] tempDistsOther;
    protected static final int m_MinNum = 1;

    FastRandomTree() {
    }

    public final int getMinNum() {
        return 1;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes.";
    }

    public final int getKValue() {
        return this.m_MotherForest.m_KValue;
    }

    public final int getMaxDepth() {
        return this.m_MotherForest.m_MaxDepth;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        throw new Exception("FastRandomTree can be used only by FastRandomForest and FastRfBagger classes, not directly.");
    }

    @Override
    public void run() {
        double[] classProbs = new double[this.data.numClasses];
        for (int i = 0; i < this.data.numInstances; ++i) {
            int n = this.data.instClassValues[i];
            classProbs[n] = classProbs[n] + this.data.instWeights[i];
        }
        int[] attIndicesWindow = new int[this.data.numAttributes - 1];
        int j = 0;
        for (int i = 0; i < attIndicesWindow.length; ++i) {
            if (j == this.data.classIndex) {
                // empty if block
            }
            int n = ++j;
            ++j;
            attIndicesWindow[i] = n;
        }
        this.data.whatGoesWhere = new int[this.data.inBag.length];
        this.data.createInBagSortedIndices();
        this.buildTree(this.data.sortedIndices, 0, this.data.sortedIndices[0].length - 1, classProbs, this.m_Debug, attIndicesWindow, 0);
        this.data = null;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] returnedDist = null;
        if (this.m_Attribute > -1) {
            if (instance.isMissing(this.m_Attribute)) {
                returnedDist = new double[this.m_MotherForest.m_Info.numClasses()];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] help = this.m_Successors[i].distributionForInstance(instance);
                    if (help == null) continue;
                    for (int j = 0; j < help.length; ++j) {
                        int n = j;
                        returnedDist[n] = returnedDist[n] + this.m_Prop[i] * help[j];
                    }
                }
            } else {
                returnedDist = this.m_MotherForest.m_Info.attribute(this.m_Attribute).isNominal() ? (instance.value(this.m_Attribute) == this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance)) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
            }
            return returnedDist;
        }
        return this.m_ClassProbs;
    }

    public double[] distributionForInstanceInDataCache(DataCache data, int instIdx) {
        double[] returnedDist = null;
        if (this.m_Attribute > -1) {
            if (data.isValueMissing(this.m_Attribute, instIdx)) {
                returnedDist = new double[this.m_MotherForest.m_Info.numClasses()];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] help = this.m_Successors[i].distributionForInstanceInDataCache(data, instIdx);
                    if (help == null) continue;
                    for (int j = 0; j < help.length; ++j) {
                        int n = j;
                        returnedDist[n] = returnedDist[n] + this.m_Prop[i] * help[j];
                    }
                }
            } else {
                returnedDist = data.isAttrNominal(this.m_Attribute) ? ((double)data.vals[this.m_Attribute][instIdx] == this.m_SplitPoint ? this.m_Successors[0].distributionForInstanceInDataCache(data, instIdx) : this.m_Successors[1].distributionForInstanceInDataCache(data, instIdx)) : ((double)data.vals[this.m_Attribute][instIdx] < this.m_SplitPoint ? this.m_Successors[0].distributionForInstanceInDataCache(data, instIdx) : this.m_Successors[1].distributionForInstanceInDataCache(data, instIdx));
            }
            return returnedDist;
        }
        return this.m_ClassProbs;
    }

    protected void buildTree(int[][] sortedIndices, int startAt, int endAt, double[] classProbs, boolean debug, int[] attIndicesWindow, int depth) {
        this.m_Debug = debug;
        int sortedIndicesLength = endAt - startAt + 1;
        if (sortedIndicesLength < Math.max(2, this.getMinNum()) || Utils.eq((double)classProbs[Utils.maxIndex((double[])classProbs)], (double)Utils.sum((double[])classProbs)) || this.getMaxDepth() > 0 && depth >= this.getMaxDepth()) {
            this.m_Attribute = -1;
            if (sortedIndicesLength != 0) {
                int c = 0;
                while (c < classProbs.length) {
                    int n = c++;
                    classProbs[n] = classProbs[n] / (double)sortedIndicesLength;
                }
            }
            this.m_ClassProbs = classProbs;
            this.data = null;
            return;
        }
        double val = Double.NaN;
        double[][] dist = new double[2][this.data.numClasses];
        double[] prop = new double[2];
        double split = Double.NaN;
        int attIndex = 0;
        int windowSize = attIndicesWindow.length;
        int k = this.getKValue();
        boolean sensibleSplitFound = false;
        double prior = Double.NaN;
        double bestNegPosterior = -1.7976931348623157E308;
        int bestAttIdx = -1;
        while (!(windowSize <= 0 || k-- <= 0 && sensibleSplitFound)) {
            double negPosterior;
            int chosenIndex = this.data.reusableRandomGenerator.nextInt(windowSize);
            attIndex = attIndicesWindow[chosenIndex];
            attIndicesWindow[chosenIndex] = attIndicesWindow[windowSize - 1];
            attIndicesWindow[windowSize - 1] = attIndex;
            --windowSize;
            double candidateSplit = this.distributionSequentialAtt(prop, dist, bestNegPosterior, attIndex, sortedIndices[attIndex], startAt, endAt);
            if (Double.isNaN(candidateSplit)) continue;
            split = candidateSplit;
            bestAttIdx = attIndex;
            if (Double.isNaN(prior)) {
                prior = SplitCriteria.entropyOverColumns(dist);
            }
            if (!((negPosterior = -SplitCriteria.entropyConditionedOnRows(dist)) > bestNegPosterior)) {
                throw new IllegalArgumentException("Very strange!");
            }
            bestNegPosterior = negPosterior;
            val = prior - -negPosterior;
            if (!(val > 0.01)) continue;
            sensibleSplitFound = true;
        }
        if (sensibleSplitFound) {
            this.m_Attribute = bestAttIdx;
            this.m_SplitPoint = split;
            this.m_Prop = prop;
            prop = null;
            int belowTheSplitStartsAt = this.splitDataNew(this.m_Attribute, this.m_SplitPoint, sortedIndices, startAt, endAt);
            this.m_Successors = new FastRandomTree[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                this.m_Successors[i] = new FastRandomTree();
                this.m_Successors[i].m_MotherForest = this.m_MotherForest;
                this.m_Successors[i].data = this.data;
                this.m_Successors[i].tempDists = this.tempDists;
                this.m_Successors[i].tempDistsOther = this.tempDistsOther;
                this.m_Successors[i].tempProps = this.tempProps;
                if (belowTheSplitStartsAt - startAt == 0) {
                    for (int j = 0; j < dist[i].length; ++j) {
                        dist[i][j] = classProbs[j] / (double)sortedIndicesLength;
                    }
                }
                if (i == 0) {
                    this.m_Successors[i].buildTree(sortedIndices, startAt, belowTheSplitStartsAt - 1, dist[i], this.m_Debug, attIndicesWindow, depth + 1);
                } else {
                    this.m_Successors[i].buildTree(sortedIndices, belowTheSplitStartsAt, endAt, dist[i], this.m_Debug, attIndicesWindow, depth + 1);
                }
                dist[i] = null;
            }
            sortedIndices = null;
        } else {
            this.m_Attribute = -1;
            if (sortedIndicesLength != 0) {
                int c = 0;
                while (c < classProbs.length) {
                    int n = c++;
                    classProbs[n] = classProbs[n] / (double)sortedIndicesLength;
                }
            }
            this.m_ClassProbs = classProbs;
        }
        this.data = null;
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int size = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            size += this.m_Successors[i].numNodes();
        }
        return size;
    }

    protected void splitData(int[][][] subsetIndices, int att, double splitPoint, int[][] sortedIndices) {
        int a;
        int inst;
        int j;
        Random random = this.data.reusableRandomGenerator;
        int[] num = new int[2];
        if (this.data.isAttrNominal(att)) {
            for (j = 0; j < sortedIndices[att].length; ++j) {
                int subset;
                inst = sortedIndices[att][j];
                if (this.data.isValueMissing(att, inst)) {
                    double rn = random.nextDouble();
                    int myBranch = -1;
                    for (int k = 0; k < this.m_Prop.length; ++k) {
                        if (!((rn -= this.m_Prop[k]) <= 0.0) && k != this.m_Prop.length - 1) continue;
                        myBranch = k;
                        break;
                    }
                    this.data.whatGoesWhere[inst] = myBranch;
                    int n = myBranch;
                    num[n] = num[n] + 1;
                    continue;
                }
                this.data.whatGoesWhere[inst] = subset = (double)this.data.vals[att][inst] == splitPoint ? 0 : 1;
                int n = subset;
                num[n] = num[n] + 1;
            }
        } else {
            num = new int[2];
            for (j = 0; j < sortedIndices[att].length; ++j) {
                int branch;
                inst = sortedIndices[att][j];
                if (this.data.isValueMissing(att, inst)) {
                    int branch2;
                    double rn = random.nextDouble();
                    this.data.whatGoesWhere[inst] = branch2 = rn > this.m_Prop[0] ? 1 : 0;
                    int n = branch2;
                    num[n] = num[n] + 1;
                    continue;
                }
                this.data.whatGoesWhere[inst] = branch = (double)this.data.vals[att][inst] < splitPoint ? 0 : 1;
                int n = branch;
                num[n] = num[n] + 1;
            }
        }
        for (a = 0; a < this.data.numAttributes; ++a) {
            if (a == this.data.classIndex) continue;
            for (int branch = 0; branch < num.length; ++branch) {
                subsetIndices[branch][a] = new int[num[branch]];
            }
        }
        for (a = 0; a < this.data.numAttributes; ++a) {
            if (a == this.data.classIndex) continue;
            for (int branch = 0; branch < num.length; ++branch) {
                num[branch] = 0;
            }
            for (j = 0; j < sortedIndices[a].length; ++j) {
                int inst2 = sortedIndices[a][j];
                int branch = this.data.whatGoesWhere[inst2];
                subsetIndices[branch][a][num[branch]] = sortedIndices[a][j];
                int n = branch;
                num[n] = num[n] + 1;
            }
        }
    }

    protected int splitDataNew(int att, double splitPoint, int[][] sortedIndices, int startAt, int endAt) {
        int inst;
        int j;
        Random random = this.data.reusableRandomGenerator;
        int[] num = new int[2];
        int[] tempArr = new int[endAt - startAt + 1];
        if (this.data.isAttrNominal(att)) {
            for (j = startAt; j <= endAt; ++j) {
                int subset;
                inst = sortedIndices[att][j];
                if (this.data.isValueMissing(att, inst)) {
                    double rn = random.nextDouble();
                    int myBranch = -1;
                    for (int k = 0; k < this.m_Prop.length; ++k) {
                        if (!((rn -= this.m_Prop[k]) <= 0.0) && k != this.m_Prop.length - 1) continue;
                        myBranch = k;
                        break;
                    }
                    this.data.whatGoesWhere[inst] = myBranch;
                    int n = myBranch;
                    num[n] = num[n] + 1;
                    continue;
                }
                this.data.whatGoesWhere[inst] = subset = (double)this.data.vals[att][inst] == splitPoint ? 0 : 1;
                int n = subset;
                num[n] = num[n] + 1;
            }
        } else {
            num = new int[2];
            for (j = startAt; j <= endAt; ++j) {
                int branch;
                inst = sortedIndices[att][j];
                if (this.data.isValueMissing(att, inst)) {
                    int branch2;
                    double rn = random.nextDouble();
                    this.data.whatGoesWhere[inst] = branch2 = rn > this.m_Prop[0] ? 1 : 0;
                    int n = branch2;
                    num[n] = num[n] + 1;
                    continue;
                }
                this.data.whatGoesWhere[inst] = branch = (double)this.data.vals[att][inst] < splitPoint ? 0 : 1;
                int n = branch;
                num[n] = num[n] + 1;
            }
        }
        for (int a = 0; a < this.data.numAttributes; ++a) {
            if (a == this.data.classIndex) continue;
            int startAbove = 0;
            int startBelow = num[0];
            Arrays.fill(tempArr, 0);
            for (j = startAt; j <= endAt; ++j) {
                int inst2 = sortedIndices[a][j];
                int branch = this.data.whatGoesWhere[inst2];
                if (branch == 0) {
                    tempArr[startAbove] = sortedIndices[a][j];
                    ++startAbove;
                    continue;
                }
                tempArr[startBelow] = sortedIndices[a][j];
                ++startBelow;
            }
            System.arraycopy(tempArr, 0, sortedIndices[a], startAt, endAt - startAt + 1);
        }
        return startAt + num[0];
    }

    protected double distribution(double[][] props, double[][][] dists, int att, int[] sortedIndices) {
        int inst;
        int i;
        double splitPoint = -1.7976931348623157E308;
        double[][] dist = null;
        if (this.data.isAttrNominal(att)) {
            dist = new double[this.data.attNumVals[att]][this.data.numClasses];
            for (i = 0; i < sortedIndices.length && !this.data.isValueMissing(att, inst = sortedIndices[i]); ++i) {
                double[] dArray = dist[(int)this.data.vals[att][inst]];
                int n = this.data.instClassValues[inst];
                dArray[n] = dArray[n] + this.data.instWeights[inst];
            }
            splitPoint = 0.0;
        } else {
            int inst2;
            int inst3;
            double[][] currDist = new double[2][this.data.numClasses];
            dist = new double[2][this.data.numClasses];
            for (int j = 0; j < sortedIndices.length && !this.data.isValueMissing(att, inst3 = sortedIndices[j]); ++j) {
                double[] dArray = currDist[1];
                int n = this.data.instClassValues[inst3];
                dArray[n] = dArray[n] + this.data.instWeights[inst3];
            }
            FastRandomTree.copyDists(currDist, dist);
            double currVal = -1.7976931348623157E308;
            double bestVal = -1.7976931348623157E308;
            int bestI = 0;
            for (i = 1; i < sortedIndices.length && !this.data.isValueMissing(att, inst2 = sortedIndices[i]); ++i) {
                int prevInst = sortedIndices[i - 1];
                double[] dArray = currDist[0];
                int n = this.data.instClassValues[prevInst];
                dArray[n] = dArray[n] + this.data.instWeights[prevInst];
                double[] dArray2 = currDist[1];
                int n2 = this.data.instClassValues[prevInst];
                dArray2[n2] = dArray2[n2] - this.data.instWeights[prevInst];
                if (!(this.data.vals[att][inst2] > this.data.vals[att][prevInst]) || !((currVal = -SplitCriteria.entropyConditionedOnRows(currDist)) > bestVal)) continue;
                bestVal = currVal;
                bestI = i;
            }
            if (bestI > 0) {
                int instJustBeforeSplit = sortedIndices[bestI - 1];
                int instJustAfterSplit = sortedIndices[bestI];
                splitPoint = (double)(this.data.vals[att][instJustAfterSplit] + this.data.vals[att][instJustBeforeSplit]) / 2.0;
                for (int ii = 0; ii < bestI; ++ii) {
                    int inst4 = sortedIndices[ii];
                    double[] dArray = dist[0];
                    int n = this.data.instClassValues[inst4];
                    dArray[n] = dArray[n] + this.data.instWeights[inst4];
                    double[] dArray3 = dist[1];
                    int n3 = this.data.instClassValues[inst4];
                    dArray3[n3] = dArray3[n3] - this.data.instWeights[inst4];
                }
            }
        }
        props[att] = FastRandomTree.countsToFreqs(dist);
        if (this.data.isValueMissing(att, sortedIndices[0])) {
            i = 0;
        }
        while (i < sortedIndices.length) {
            inst = sortedIndices[i];
            for (int branch = 0; branch < dist.length; ++branch) {
                double[] dArray = dist[branch];
                int n = this.data.instClassValues[inst];
                dArray[n] = dArray[n] + props[att][branch] * this.data.instWeights[inst];
            }
            ++i;
        }
        dists[att] = dist;
        return splitPoint;
    }

    protected double distributionSequentialAtt(double[] propsBestAtt, double[][] distsBestAtt, double scoreBestAtt, int attToExamine, int[] sortedIndicesOfAtt, int startAt, int endAt) {
        int inst;
        int inst2;
        int i;
        int j;
        double splitPoint = -1.7976931348623157E308;
        double[][] dist = this.tempDists;
        Arrays.fill(dist[0], 0.0);
        Arrays.fill(dist[1], 0.0);
        double[][] currDist = this.tempDistsOther;
        Arrays.fill(currDist[0], 0.0);
        Arrays.fill(currDist[1], 0.0);
        int sortedIndicesOfAttLength = endAt - startAt + 1;
        int lastNonmissingValIdx = endAt;
        for (j = endAt; j >= startAt && this.data.isValueMissing(attToExamine, sortedIndicesOfAtt[j]); --j) {
            lastNonmissingValIdx = j - 1;
        }
        if (lastNonmissingValIdx < startAt) {
            return Double.NaN;
        }
        if (this.data.isAttrNominal(attToExamine)) {
            int numLvls = this.data.attNumVals[attToExamine];
            int bestLvl = 0;
            if (numLvls <= 2) {
                bestLvl = 0;
                for (i = startAt; i <= lastNonmissingValIdx; ++i) {
                    int inst3 = sortedIndicesOfAtt[i];
                    double[] dArray = dist[(int)this.data.vals[attToExamine][inst3]];
                    int n = this.data.instClassValues[inst3];
                    dArray[n] = dArray[n] + this.data.instWeights[inst3];
                }
            } else {
                int inst4;
                for (int j2 = startAt; j2 <= lastNonmissingValIdx; ++j2) {
                    int inst5 = sortedIndicesOfAtt[j2];
                    double[] dArray = currDist[1];
                    int n = this.data.instClassValues[inst5];
                    dArray[n] = dArray[n] + this.data.instWeights[inst5];
                }
                FastRandomTree.copyDists(currDist, dist);
                double currVal = -1.7976931348623157E308;
                double bestVal = -1.7976931348623157E308;
                int lastSeen = startAt;
                for (int lvl = 0; lvl < numLvls; ++lvl) {
                    FastRandomTree.copyDists(dist, currDist);
                    for (i = lastSeen; i <= lastNonmissingValIdx; ++i) {
                        lastSeen = i;
                        inst2 = sortedIndicesOfAtt[i];
                        if ((int)this.data.vals[attToExamine][inst2] < lvl) continue;
                        if ((int)this.data.vals[attToExamine][inst2] != lvl) break;
                        double[] dArray = currDist[0];
                        int n = this.data.instClassValues[inst2];
                        dArray[n] = dArray[n] + this.data.instWeights[inst2];
                        double[] dArray2 = currDist[1];
                        int n2 = this.data.instClassValues[inst2];
                        dArray2[n2] = dArray2[n2] - this.data.instWeights[inst2];
                    }
                    if (!((currVal = -SplitCriteria.entropyConditionedOnRows(currDist)) > bestVal)) continue;
                    bestVal = currVal;
                    bestLvl = lvl;
                }
                for (i = startAt; i <= lastNonmissingValIdx && (int)this.data.vals[attToExamine][inst4 = sortedIndicesOfAtt[i]] == bestLvl; ++i) {
                    double[] dArray = dist[0];
                    int n = this.data.instClassValues[inst4];
                    dArray[n] = dArray[n] + this.data.instWeights[inst4];
                    double[] dArray3 = dist[1];
                    int n3 = this.data.instClassValues[inst4];
                    dArray3[n3] = dArray3[n3] - this.data.instWeights[inst4];
                }
            }
            splitPoint = bestLvl;
        } else {
            for (j = startAt; j <= lastNonmissingValIdx; ++j) {
                inst = sortedIndicesOfAtt[j];
                double[] dArray = currDist[1];
                int n = this.data.instClassValues[inst];
                dArray[n] = dArray[n] + this.data.instWeights[inst];
            }
            FastRandomTree.copyDists(currDist, dist);
            double currVal = -1.7976931348623157E308;
            double bestVal = -1.7976931348623157E308;
            int bestI = 0;
            for (i = startAt + 1; i <= lastNonmissingValIdx; ++i) {
                int inst6 = sortedIndicesOfAtt[i];
                int prevInst = sortedIndicesOfAtt[i - 1];
                double[] dArray = currDist[0];
                int n = this.data.instClassValues[prevInst];
                dArray[n] = dArray[n] + this.data.instWeights[prevInst];
                double[] dArray4 = currDist[1];
                int n4 = this.data.instClassValues[prevInst];
                dArray4[n4] = dArray4[n4] - this.data.instWeights[prevInst];
                if (!(this.data.vals[attToExamine][inst6] > this.data.vals[attToExamine][prevInst]) || !((currVal = -SplitCriteria.entropyConditionedOnRows(currDist)) > bestVal)) continue;
                bestVal = currVal;
                bestI = i;
            }
            if (bestI > startAt) {
                int instJustBeforeSplit = sortedIndicesOfAtt[bestI - 1];
                int instJustAfterSplit = sortedIndicesOfAtt[bestI];
                splitPoint = (double)(this.data.vals[attToExamine][instJustAfterSplit] + this.data.vals[attToExamine][instJustBeforeSplit]) / 2.0;
                for (int ii = startAt; ii < bestI; ++ii) {
                    inst2 = sortedIndicesOfAtt[ii];
                    double[] dArray = dist[0];
                    int n = this.data.instClassValues[inst2];
                    dArray[n] = dArray[n] + this.data.instWeights[inst2];
                    double[] dArray5 = dist[1];
                    int n5 = this.data.instClassValues[inst2];
                    dArray5[n5] = dArray5[n5] - this.data.instWeights[inst2];
                }
            }
        }
        double[] props = this.tempProps;
        FastRandomTree.countsToFreqs(dist, props);
        for (i = lastNonmissingValIdx + 1; i <= endAt; ++i) {
            inst = sortedIndicesOfAtt[i];
            double[] dArray = dist[0];
            int n = this.data.instClassValues[inst];
            dArray[n] = dArray[n] + props[0] * this.data.instWeights[inst];
            double[] dArray6 = dist[1];
            int n6 = this.data.instClassValues[inst];
            dArray6[n6] = dArray6[n6] + props[1] * this.data.instWeights[inst];
        }
        double curScore = -SplitCriteria.entropyConditionedOnRows(dist);
        if (curScore > scoreBestAtt && splitPoint > -1.7976931348623157E308) {
            FastRandomTree.copyDists(dist, distsBestAtt);
            System.arraycopy(props, 0, propsBestAtt, 0, props.length);
            return splitPoint;
        }
        return Double.NaN;
    }

    protected static double[] countsToFreqs(double[][] dist) {
        int k;
        double[] props = new double[dist.length];
        for (k = 0; k < props.length; ++k) {
            props[k] = Utils.sum((double[])dist[k]);
        }
        if (Utils.eq((double)Utils.sum((double[])props), (double)0.0)) {
            for (k = 0; k < props.length; ++k) {
                props[k] = 1.0 / (double)props.length;
            }
        } else {
            FastRfUtils.normalize(props);
        }
        return props;
    }

    protected static void countsToFreqs(double[][] dist, double[] props) {
        int k;
        for (k = 0; k < props.length; ++k) {
            props[k] = Utils.sum((double[])dist[k]);
        }
        if (Utils.eq((double)Utils.sum((double[])props), (double)0.0)) {
            for (k = 0; k < props.length; ++k) {
                props[k] = 1.0 / (double)props.length;
            }
        } else {
            FastRfUtils.normalize(props);
        }
    }

    protected static void copyDists(double[][] distFrom, double[][] distTo) {
        int i;
        for (i = 0; i < distFrom[0].length; ++i) {
            distTo[0][i] = distFrom[0][i];
        }
        for (i = 0; i < distFrom[1].length; ++i) {
            distTo[1][i] = distFrom[1][i];
        }
    }

    public static void main(String[] argv) {
        FastRandomTree.runClassifier((Classifier)new FastRandomTree(), (String[])argv);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 0.99$");
    }
}

