/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

import hr.irb.fastRandomForest.FastRandomTree;
import hr.irb.fastRandomForest.FastRfBagging;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class FastRandomForest
extends AbstractClassifier
implements OptionHandler,
Randomizable,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 4216839470751428700L;
    protected int m_numTrees = 100;
    protected int m_numFeatures = 0;
    protected int m_randomSeed = 1;
    protected int m_KValue = 0;
    protected int m_NumThreads = 0;
    protected FastRfBagging m_bagger = null;
    protected int m_MaxDepth = 0;
    protected Instances m_Info = null;
    protected AbstractClassifier m_ZeroR;
    private double[] m_FeatureImportances;
    private boolean m_computeImportances = false;

    public String globalInfo() {
        return "Class for constructing a forest of random trees.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Random Forests");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "45");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "5-32");
        return result;
    }

    public String numTreesTipText() {
        return "The number of trees to be generated.";
    }

    public int getNumTrees() {
        return this.m_numTrees;
    }

    public void setNumTrees(int newNumTrees) {
        this.m_numTrees = newNumTrees;
    }

    public String numFeaturesTipText() {
        return "The number of attributes to be used in random selection (see RandomTree2).";
    }

    public int getNumFeatures() {
        return this.m_numFeatures;
    }

    public void setNumFeatures(int newNumFeatures) {
        this.m_numFeatures = newNumFeatures;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_randomSeed = seed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the trees, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int value) {
        this.m_MaxDepth = value;
    }

    public String numThreadsTipText() {
        return "Number of simultaneous threads to use in computation (0 = autodetect).";
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public void setNumThreads(int value) {
        this.m_NumThreads = value;
    }

    public boolean getComputeImportances() {
        return this.m_computeImportances;
    }

    public void setComputeImportances(boolean computeImportances) {
        this.m_computeImportances = computeImportances;
    }

    public double measureOutOfBagError() {
        if (this.m_bagger != null) {
            return this.m_bagger.measureOutOfBagError();
        }
        return Double.NaN;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureOutOfBagError");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (FastRandomForest)");
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tNumber of trees to build.", "I", 1, "-I <number of trees>"));
        newVector.addElement(new Option("\tNumber of features to consider (<1=int(logM+1)).", "K", 1, "-K <number of features>"));
        newVector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        newVector.addElement(new Option("\tThe maximum depth of the trees, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        newVector.addElement(new Option("\tThe number of simultaneous threads to use for computation, 0 for autodetect.\n\t(default 0)", "threads", 1, "-threads <num>"));
        newVector.addElement(new Option("\tWhether to compute feature importances.\n", "import", 0, "-import"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-I");
        result.add("" + this.getNumTrees());
        result.add("-K");
        result.add("" + this.getNumFeatures());
        result.add("-S");
        result.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            result.add("-depth");
            result.add("" + this.getMaxDepth());
        }
        if (this.getNumThreads() > 0) {
            result.add("-threads");
            result.add("" + this.getNumThreads());
        }
        if (this.getComputeImportances()) {
            result.add("-import");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'I', (String[])options);
        this.m_numTrees = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
        tmpStr = Utils.getOption((char)'K', (String[])options);
        this.m_numFeatures = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 0;
        tmpStr = Utils.getOption((char)'S', (String[])options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption((String)"depth", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxDepth(Integer.parseInt(tmpStr));
        } else {
            this.setMaxDepth(0);
        }
        tmpStr = Utils.getOption((String)"threads", (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumThreads(Integer.parseInt(tmpStr));
        } else {
            this.setNumThreads(0);
        }
        this.setComputeImportances(Utils.getFlag((String)"import", (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public Capabilities getCapabilities() {
        return new FastRandomTree().getCapabilities();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(data);
            return;
        }
        this.m_ZeroR = null;
        this.m_Info = new Instances(data, 0);
        this.m_bagger = new FastRfBagging();
        this.m_KValue = this.m_numFeatures;
        if (this.m_KValue > data.numAttributes() - 1) {
            this.m_KValue = data.numAttributes() - 1;
        }
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2((double)data.numAttributes()) + 1;
        }
        FastRandomTree rTree = new FastRandomTree();
        rTree.m_MotherForest = this;
        this.m_bagger.setClassifier((Classifier)rTree);
        this.m_bagger.setSeed(this.m_randomSeed);
        this.m_bagger.setNumIterations(this.m_numTrees);
        this.m_bagger.setCalcOutOfBag(true);
        this.m_bagger.setComputeImportances(this.getComputeImportances());
        this.m_bagger.buildClassifier(data, this.m_NumThreads, this);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        return this.m_bagger.distributionForInstance(instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_bagger == null) {
            sb.append("FastRandomForest not built yet");
        } else {
            sb.append("FastRandomForest of " + this.m_numTrees + " trees, each constructed while considering " + this.m_KValue + " random feature" + (this.m_KValue == 1 ? "" : "s") + ".\n" + "Out of bag error: " + Utils.doubleToString((double)(this.m_bagger.measureOutOfBagError() * 100.0), (int)3) + "%\n" + (this.getMaxDepth() > 0 ? "Max. depth of trees: " + this.getMaxDepth() + "\n" : "") + "\n");
            if (this.getComputeImportances()) {
                sb.append("Feature importances - increase in out-of-bag error (as % misclassified instances) after feature permuted:\n");
                double[] importances = this.m_bagger.getFeatureImportances();
                for (int i = 0; i < importances.length; ++i) {
                    sb.append(String.format("%d\t%s\t%6.4f%%\n", i + 1, this.m_Info.attribute(i).name(), i == this.m_Info.classIndex() ? Double.NaN : importances[i] * 100.0));
                }
            }
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        FastRandomForest.runClassifier((Classifier)new FastRandomForest(), (String[])argv);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 0.99$");
    }

    public double[] getFeatureImportances() {
        return this.m_bagger.getFeatureImportances();
    }
}

