/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.utils;

import cz.siret.prank.geom.Atoms;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;

public class PerfUtils {
    public static double[] toPrimitiveArray(List<Double> list, double[] to) {
        int n = list.size();
        for (int i = 0; i != n; ++i) {
            to[i] = list.get(i);
        }
        return to;
    }

    public static void arrayCopy(double[] from, double[] to) {
        System.arraycopy(from, 0, to, 0, from.length);
    }

    public static double[] extendArray(double[] aa, double x) {
        double[] res = new double[aa.length + 1];
        PerfUtils.arrayCopy(aa, res);
        res[aa.length] = x;
        return res;
    }

    public static double[] toPrimitiveArray(List<Double> list) {
        return PerfUtils.toPrimitiveArray(list, new double[list.size()]);
    }

    public static double sqrDist(double[] a, double[] b) {
        double x = a[0] - b[0];
        double y = a[1] - b[1];
        double z = a[2] - b[2];
        return x * x + y * y + z * z;
    }

    public static double sqrDistL(Atom a, List<Atom> list) {
        if (list == null || list.isEmpty()) {
            return Double.MAX_VALUE;
        }
        double[] acoords = a.getCoords();
        double minDist = Double.MAX_VALUE;
        for (Atom b : list) {
            double next = PerfUtils.sqrDist(acoords, b.getCoords());
            if (!(next < minDist)) continue;
            minDist = next;
        }
        return minDist;
    }

    public static double dist(double[] a, double[] b) {
        double d = PerfUtils.sqrDist(a, b);
        return Math.sqrt(d);
    }

    public static String formatDouble(Double d) {
        return Double.toString(PerfUtils.fastRound(d));
    }

    public static double fastRound(double x) {
        return (double)Math.round(x * 10000.0) / 10000.0;
    }

    public static double round(double x, int deg) {
        double p = Math.pow(10.0, deg);
        return (double)Math.round(x * p) / p;
    }

    public static Atoms cutoffAtomsAround(Atoms atoms, Atom distanceTo, double dist) {
        ArrayList<Atom> res = new ArrayList<Atom>();
        double sqrDist = dist * dist;
        double[] toCoords = distanceTo.getCoords();
        for (Atom a : atoms.list) {
            if (!(PerfUtils.sqrDist(a.getCoords(), toCoords) <= sqrDist)) continue;
            res.add(a);
        }
        return new Atoms((List<? extends Atom>)res);
    }
}

