/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.utils;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ReducedChemCompProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdbUtils
implements GroovyObject {
    private static final int BUFFER_SIZE = 0x500000;
    private static final FileParsingParameters PARSING_PARAMS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PdbUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Logger logger;
        FileParsingParameters fileParsingParameters;
        PARSING_PARAMS = fileParsingParameters = new FileParsingParameters();
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.utils.PdbUtils");
        ChemCompGroupFactory.setChemCompProvider((ChemCompProvider)new ReducedChemCompProvider());
        PARSING_PARAMS.setAlignSeqRes(false);
        PARSING_PARAMS.setParseSecStruc(false);
        PARSING_PARAMS.setCreateAtomBonds(false);
        PARSING_PARAMS.setCreateAtomCharges(false);
        PARSING_PARAMS.setParseBioAssembly(false);
    }

    public static Structure loadFromFile(String file) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"loading file [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (file == null) {
            throw (Throwable)new IllegalArgumentException("file name not provided");
        }
        Structure struct = null;
        if (file.endsWith(".pdb")) {
            Structure structure;
            PDBFileParser pdbpars = new PDBFileParser();
            pdbpars.setFileParsingParameters(PARSING_PARAMS);
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file), BUFFER_SIZE);
            struct = structure = pdbpars.parsePDBFile((InputStream)inStream);
        } else {
            Structure structure;
            PDBFileReader pdbReader = new PDBFileReader();
            pdbReader.setFileParsingParameters(PARSING_PARAMS);
            struct = structure = pdbReader.getStructure(file);
        }
        return struct;
    }

    public static Structure loadFromString(String pdbText) {
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(PARSING_PARAMS);
        BufferedReader br = new BufferedReader(new StringReader(pdbText));
        Structure struc = pdbpars.parsePDBFile(br);
        return struc;
    }

    public static String correctResidueCode(String residueCode) {
        if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"MSE")) {
            String string;
            residueCode = string = "MET";
        } else if (ScriptBytecodeAdapter.compareEqual((Object)residueCode, (Object)"MEN")) {
            String string;
            residueCode = string = "ASP";
        }
        return residueCode;
    }

    public static String getAtomResidueCode(Atom a) {
        return a.getGroup().getPDBName();
    }

    public static String getCorrectedAtomResidueCode(Atom a) {
        return PdbUtils.correctResidueCode(PdbUtils.getAtomResidueCode(a));
    }

    public static String getResidueCode(Group group) {
        if (group == null || group.size() == 0) {
            return ShortTypeHandling.castToString(null);
        }
        return PdbUtils.getAtomResidueCode(group.getAtom(0));
    }

    public static String getCorrectedResidueCode(Group group) {
        return PdbUtils.correctResidueCode(PdbUtils.getResidueCode(group));
    }

    public static String normAAcode(String aa) {
        if (aa.isEmpty()) {
            return aa;
        }
        if (aa.length() != 3) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(StringGroovyMethods.plus((String)" Suspicious AA code: ", (CharSequence)aa));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        String a = aa.substring(0, 1).toUpperCase();
        String b = aa.substring(1, aa.length()).toLowerCase();
        return StringGroovyMethods.plus((String)a, (CharSequence)b);
    }

    public static boolean trySetElement(Atom a, String code) {
        Element ele = null;
        try {
            Element element;
            ele = element = Element.valueOf((String)code);
        }
        catch (IllegalArgumentException e) {
        }
        if (ele != null) {
            a.setElement(ele);
            return DefaultTypeTransformation.booleanUnbox(null);
        }
        return DefaultTypeTransformation.booleanUnbox(null);
    }

    public static void correctBioJavaElement(Atom a) {
        if (a.getElement().equals((Object)Element.R)) {
            if (a.getName().length() > 1 && PdbUtils.trySetElement(a, a.getName().substring(0, 2))) {
                return;
            }
            if (a.getName().length() > 0) {
                PdbUtils.trySetElement(a, a.getName().substring(0, 1));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PdbUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public static FileParsingParameters getPARSING_PARAMS() {
        return PARSING_PARAMS;
    }
}

