/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.utils;

import com.google.common.io.Files;
import cz.siret.prank.utils.Formatter;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class Futils
implements GroovyObject {
    public static final int ZIP_BEST_COMPRESSION = 9;
    private static final int OUTPUT_BUFFER_SIZE = 10000;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Futils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String normalize(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)new File(path).toPath().normalize());
    }

    public static String absPath(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        return Futils.normalize(new File(path).getAbsolutePath());
    }

    public static String absSafePath(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        return Futils.safe(Futils.absPath(path));
    }

    public static String safe(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        return path.replace("\\", "/");
    }

    public static String dir(String path) {
        return new File(path).getParent();
    }

    public static String relativize(String what, String relativeToDir) {
        String string;
        String string2;
        what = string2 = Futils.absPath(what).replace("\\", "/");
        relativeToDir = string = Futils.absPath(relativeToDir).replace("\\", "/");
        return ResourceGroovyMethods.toURI((String)relativeToDir).relativize(ResourceGroovyMethods.toURI((String)what)).toString();
    }

    public static long size(String fname) {
        return new File(fname).length();
    }

    public static String sizeMBFormatted(String fname) {
        double size = (double)Futils.size(fname) / (double)(1024 * 1024);
        return Formatter.format(size, 1);
    }

    public static String shortName(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        return new File(path).getName();
    }

    public static String removeExtension(String path) {
        String string = path;
        return string != null ? StringGroovyMethods.replaceFirst((CharSequence)string, (Pattern)((Pattern)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.bitwiseNegate((Object)"\\.[^\\.]+$"), Pattern.class)), (CharSequence)"") : null;
    }

    public static String readResource(String path) {
        return IOGroovyMethods.getText((BufferedReader)IOGroovyMethods.newReader((InputStream)Futils.class.getResourceAsStream(path)));
    }

    public static InputStream inputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new GZIPInputStream(new FileInputStream(file));
        }
        return new FileInputStream(file);
    }

    public static String readFile(String fname) {
        return ResourceGroovyMethods.getText((File)new File(fname));
    }

    public static Properties loadProperties(String path) {
        Properties res = new Properties();
        res.load(Futils.class.getResourceAsStream(path));
        return res;
    }

    public static PrintWriter getWriter(String fname) {
        File file = new File(fname);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        return new PrintWriter(new BufferedWriter(new FileWriter(file), OUTPUT_BUFFER_SIZE));
    }

    public static PrintWriter getGzipWriter(String fname) {
        File file = new File(fname);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        GZIPOutputStream gos = new GZIPOutputStream((OutputStream)new FileOutputStream(file), OUTPUT_BUFFER_SIZE);
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(gos), OUTPUT_BUFFER_SIZE));
    }

    public static void writeGzip(String fname, Object text) {
        PrintWriter writer = Futils.getGzipWriter(fname);
        DefaultGroovyMethods.print((PrintWriter)writer, (Object)text);
        writer.close();
    }

    public static void writeFile(String fname, Object text) {
        block7: {
            try {
                String dir = Futils.dir(fname);
                if (dir != null && !Futils.exists(dir)) {
                    Futils.mkdirs(dir);
                }
                File file = new File(fname);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                ResourceGroovyMethods.write((File)file, (String)DefaultGroovyMethods.toString((Object)text));
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fname}, new String[]{"Error writing to file [", "]:"}).plus(e.getMessage())), (Throwable)e);
                    v0 = null;
                    break block7;
                }
                v0 = null;
            }
        }
    }

    public static void append(String fname, Object text) {
        block5: {
            try {
                ResourceGroovyMethods.leftShift((File)new File(fname), (Object)text);
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fname}, new String[]{"Error writing to file [", "]:"}).plus(e.getMessage())), (Throwable)e);
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public static void appendl(String fname, Object text) {
        Object object = text;
        Futils.append(fname, StringGroovyMethods.plus((String)(object != null ? DefaultGroovyMethods.toString((Object)object) : null), (CharSequence)"\n"));
    }

    public static List<File> listFiles(String dir, String ext) {
        Reference ext2 = new Reference((Object)ext);
        public final class _listFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listFiles_closure1(Object _outerInstance, Object _thisObject, Reference ext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.ext = reference = ext;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.matchRegex((Object)((File)it).getName(), (Object)new GStringImpl(new Object[]{this.ext.get()}, new String[]{".*\\.", ""}));
            }

            public String getExt() {
                return ShortTypeHandling.castToString((Object)this.ext.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new File(dir).listFiles(), Object[].class)), (Closure)new _listFiles_closure1(Futils.class, Futils.class, ext2)));
    }

    public static List<File> listFiles(String dir) {
        return DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new File(dir).listFiles(), Object[].class)));
    }

    public static boolean isDirEmpty(String dir) {
        return Futils.listFiles(dir).isEmpty();
    }

    public static boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return new File(name).exists();
    }

    public static void delete(String fname) {
        Object v0;
        if (fname == null) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info(StringGroovyMethods.plus((String)"deleting ", (CharSequence)fname));
            v0 = null;
        } else {
            v0 = null;
        }
        File f = new File(fname);
        if (f.exists()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                f.delete();
            }
        }
    }

    public static String mkdirs(String s) {
        if (s == null) {
            return ShortTypeHandling.castToString(null);
        }
        new File(s).mkdirs();
        return s;
    }

    public static void copy(String from, String to) {
        log.debug("copying [{}] to [{}]", (Object)from, (Object)to);
        Files.copy((File)new File(from), (File)new File(to));
    }

    public static String getSystemTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void zip(String fileOrDirectory) {
        Futils.zip(fileOrDirectory, ZipUtil.DEFAULT_COMPRESSION_LEVEL);
    }

    public static void zip(String fileOrDirectory, int compressionLevel) {
        File fileOrDir = new File(fileOrDirectory);
        File zipFile = new File(StringGroovyMethods.plus((String)fileOrDirectory, (CharSequence)".zip"));
        if (fileOrDir.isDirectory()) {
            ZipUtil.pack((File)fileOrDir, (File)zipFile, (int)compressionLevel);
        } else {
            ZipUtil.packEntries((File[])new File[]{fileOrDir}, (File)zipFile, (int)compressionLevel);
        }
    }

    public static void zipAndDelete(String fileOrDirectory) {
        Futils.zipAndDelete(fileOrDirectory, ZipUtil.DEFAULT_COMPRESSION_LEVEL);
    }

    public static void zipAndDelete(String fileOrDirectory, int compressionLevel) {
        Futils.zip(fileOrDirectory, compressionLevel);
        Futils.delete(fileOrDirectory);
    }

    public static List<String> readLines(String fname) {
        File file = new File(fname);
        return ResourceGroovyMethods.readLines((File)file);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Futils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.utils.Futils");
    }
}

