/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.utils;

import com.google.common.base.Joiner;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.PerfUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CutoffAtomsCallLog {
    public static CutoffAtomsCallLog INST = new CutoffAtomsCallLog();
    static final int MAX = 5000;
    List<int[]> calls = new ArrayList<int[]>(100000);
    long[] ncalls = new long[5001];
    long[] times = new long[5001];
    long[] returned = new long[5001];

    public void addCall(int atomsSize, int resultSize, long time) {
        this.calls.add(new int[]{atomsSize, resultSize});
        if (atomsSize > 5000) {
            atomsSize = 5000;
        }
        int n = atomsSize;
        this.ncalls[n] = this.ncalls[n] + 1L;
        int n2 = atomsSize;
        this.times[n2] = this.times[n2] + time;
        int n3 = atomsSize;
        this.returned[n3] = this.returned[n3] + (long)resultSize;
    }

    public void printOut(String fnamePrefix) {
        String csv = Joiner.on((char)'\n').join((Iterable)this.calls.stream().map(a -> "" + a[0] + "," + a[1]).collect(Collectors.toList()));
        Futils.writeFile(fnamePrefix + "_calls.csv", csv);
        StringBuilder ss = new StringBuilder();
        ss.append("atoms,calls,sum_time,avg_returned\n");
        for (int i = 0; i <= 5000; ++i) {
            double avgret = this.ncalls[i] == 0L ? 0.0 : (double)(this.returned[i] / this.ncalls[i]);
            ss.append("" + i + "," + this.ncalls[i] + "," + this.times[i] + "," + PerfUtils.formatDouble(avgret) + "\n");
        }
        Futils.writeFile(fnamePrefix + "_stats.csv", ss.toString());
    }
}

