/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.utils;

public class ATimer {
    private long start;

    public ATimer() {
        this.restart();
    }

    public static ATimer startTimer() {
        return new ATimer();
    }

    public void restart() {
        this.start = System.nanoTime();
    }

    public long getTime() {
        return (System.nanoTime() - this.start) / 1000000L;
    }

    public Duration getDuration() {
        return new Duration(this.getTime());
    }

    public long getTimeSec() {
        return this.getTime() / 1000L;
    }

    public double getMinutes() {
        return this.getTimeSec() / 60L;
    }

    public String getFormatted() {
        return this.getDuration().toString();
    }

    public String toString() {
        return this.getFormatted();
    }

    public static class Duration {
        private long millis;
        private long seconds;
        private long minutes;
        private long hours;

        public Duration(long ms) {
            this.millis = ms;
            this.seconds = this.millis / 1000L;
            this.minutes = this.seconds / 60L;
            this.hours = this.minutes / 60L;
            this.minutes %= 60L;
            this.seconds %= 60L;
            this.millis %= 60L;
        }

        public long getMillis() {
            return this.millis;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public long getMinutes() {
            return this.minutes;
        }

        public long getHours() {
            return this.hours;
        }

        public String toString() {
            return String.format("%d hours %d minutes %d.%d seconds", this.hours, this.minutes, this.seconds, this.millis);
        }
    }
}

