/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines.results;

import cz.siret.prank.prediction.metrics.ClassifierStats;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.program.routines.results.Evaluation;
import cz.siret.prank.utils.CSV;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictResults
implements Parametrized,
Writable,
GroovyObject {
    private Evaluation evaluation;
    private ClassifierStats classStats;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PredictResults() {
        ClassifierStats classifierStats;
        Evaluation evaluation;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        Parametrized.Trait.Helper.$init$(this);
        this.evaluation = evaluation = new Evaluation();
        this.classStats = classifierStats = new ClassifierStats();
    }

    public Map getStats() {
        Map m = this.evaluation.getStats();
        m.putAll(this.classStats.getMetricsMap());
        return m;
    }

    public String getMiscStatsCSV() {
        public final class _getMiscStatsCSV_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMiscStatsCSV_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{((Map.Entry)it).getKey(), Formatter.fmt(((Map.Entry)it).getValue())}, new String[]{"", ", ", ""});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMiscStatsCSV_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Map)this.getStats(), (Closure)new _getMiscStatsCSV_closure1(this, this)), (String)"\n");
    }

    public void logAndStore(String outdir, String classifierName, Boolean logIndividualCases) {
        Object v1;
        if (logIndividualCases == null) {
            boolean bl = this.getParams().isLog_cases();
            logIndividualCases = bl;
        }
        Futils.mkdirs(outdir);
        List<Integer> tolerances = this.getParams().getEval_tolerances();
        String succ_rates = this.evaluation.toSuccRatesCSV(tolerances);
        String classifier_stats = this.classStats.toCSV(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{classifierName}, new String[]{" ", " "})));
        String stats = this.getMiscStatsCSV();
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/success_rates.csv"})), succ_rates);
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/classifier.csv"})), classifier_stats);
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/stats.csv"})), stats);
        Boolean bl = logIndividualCases;
        if (bl == null ? false : bl) {
            this.evaluation.sort();
            String casedir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/cases"}));
            Futils.mkdirs(casedir);
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/proteins.csv"})), this.evaluation.toProteinsCSV());
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/ligands.csv"})), this.evaluation.toLigandsCSV());
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/pockets.csv"})), this.evaluation.toPocketsCSV());
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/ranks.csv"})), this.evaluation.toRanksCSV());
        }
        if (log.isInfoEnabled()) {
            log.info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\n", (CharSequence)CSV.tabulate(classifier_stats)), (CharSequence)"\n\n"));
            v1 = null;
        } else {
            v1 = null;
        }
        PredictResults.write(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\nSuccess Rates:\n", (CharSequence)CSV.tabulate(succ_rates)), (CharSequence)"\n"));
    }

    public String toMainResultsCsv(String outdir, String label) {
        LinkedHashMap m = new LinkedHashMap();
        String string = new File(outdir).getName();
        ScriptBytecodeAdapter.setProperty((Object)string, null, m, (String)"dir");
        String string2 = label;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, m, (String)"label");
        int n = this.evaluation.getProteinCount();
        ScriptBytecodeAdapter.setProperty((Object)n, null, m, (String)"proteins");
        int n2 = this.evaluation.getLigandCount();
        ScriptBytecodeAdapter.setProperty((Object)n2, null, m, (String)"ligands");
        int n3 = this.evaluation.getPocketCount();
        ScriptBytecodeAdapter.setProperty((Object)n3, null, m, (String)"pockets");
        String string3 = Formatter.formatPercent(this.evaluation.calcDefaultCriteriumSuccessRate(0));
        ScriptBytecodeAdapter.setProperty((Object)string3, null, m, (String)"DCA_4_0");
        String string4 = Formatter.formatPercent(this.evaluation.calcDefaultCriteriumSuccessRate(2));
        ScriptBytecodeAdapter.setProperty((Object)string4, null, m, (String)"DCA_4_2");
        String string5 = Formatter.fmt(this.classStats.getMetrics().getP());
        ScriptBytecodeAdapter.setProperty((Object)string5, null, m, (String)"P");
        String string6 = Formatter.fmt(this.classStats.getMetrics().getR());
        ScriptBytecodeAdapter.setProperty((Object)string6, null, m, (String)"R");
        String string7 = Formatter.fmt(this.classStats.getMetrics().getF1());
        ScriptBytecodeAdapter.setProperty((Object)string7, null, m, (String)"F1");
        String string8 = Formatter.fmt(this.classStats.getMetrics().getMCC());
        ScriptBytecodeAdapter.setProperty((Object)string8, null, m, (String)"MCC");
        String string9 = Formatter.fmt(this.evaluation.getAvgLigandAtoms());
        ScriptBytecodeAdapter.setProperty((Object)string9, null, m, (String)"ligSize");
        String string10 = Formatter.fmt(this.evaluation.getAvgPocketVolume());
        ScriptBytecodeAdapter.setProperty((Object)string10, null, m, (String)"pocketVol");
        String string11 = Formatter.fmt(this.evaluation.getAvgPocketSurfAtoms());
        ScriptBytecodeAdapter.setProperty((Object)string11, null, m, (String)"pocketSurf");
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.join(m.keySet(), (String)","), (CharSequence)"\n"), (CharSequence)DefaultGroovyMethods.join(m.values(), (String)","));
    }

    public void logMainResults(String outdir, String label) {
        String mainRes = this.toMainResultsCsv(outdir, label);
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/summary.csv"})), mainRes);
        File collectedf = new File(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/../runs_pred.csv"})));
        if (!collectedf.exists()) {
            ResourceGroovyMethods.leftShift((File)collectedf, (Object)StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.readLines((CharSequence)mainRes), (int)0)), (CharSequence)"\n"));
        }
        ResourceGroovyMethods.leftShift((File)collectedf, (Object)StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.readLines((CharSequence)mainRes), (int)1)), (CharSequence)"\n"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PredictResults.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(PredictResults.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{PredictResults.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(PredictResults.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{PredictResults.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(PredictResults.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{PredictResults.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(PredictResults.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{PredictResults.class, arg1});
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.results.PredictResults");
        Writable.Trait.Helper.$static$init$(PredictResults.class);
        Parametrized.Trait.Helper.$static$init$(PredictResults.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    @Generated
    public void logAndStore(String outdir, String classifierName) {
        this.logAndStore(outdir, classifierName, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    @Generated
    public void setEvaluation(Evaluation evaluation) {
        this.evaluation = evaluation;
    }

    @Generated
    public ClassifierStats getClassStats() {
        return this.classStats;
    }

    @Generated
    public void setClassStats(ClassifierStats classifierStats) {
        this.classStats = classifierStats;
    }
}

