/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines.results;

import cz.siret.prank.domain.Dataset;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.prediction.metrics.ClassifierStats;
import cz.siret.prank.prediction.metrics.Curves;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.program.routines.results.Evaluation;
import cz.siret.prank.program.routines.results.MultiRunStats;
import cz.siret.prank.utils.CSV;
import cz.siret.prank.utils.Cutils;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.MathUtils;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalResults
implements Parametrized,
Writable,
GroovyObject {
    private int runs;
    private Evaluation eval;
    private Evaluation origEval;
    private ClassifierStats classifierStats;
    private ClassifierStats classifierTrainStats;
    private ClassifierStats residuePredictionStats;
    private Dataset.Result datasetResult;
    private Long trainTime;
    private Long evalTime;
    private int train_positives;
    private int train_negatives;
    private List<Double> featureImportances;
    private List<EvalResults> subResults;
    private Map<String, Double> additionalStats;
    private boolean mode_residues;
    private boolean mode_pockets;
    private boolean rescoring;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public EvalResults(int runs) {
        ClassifierStats classifierStats;
        ClassifierStats classifierStats2;
        Evaluation evaluation;
        Evaluation evaluation2;
        int n;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n2;
        int n3;
        int n4;
        this.runs = n4 = 0;
        this.train_positives = n3 = 0;
        this.train_negatives = n2 = 0;
        ArrayList<EvalResults> arrayList = new ArrayList<EvalResults>();
        this.subResults = arrayList;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        this.additionalStats = hashMap;
        this.mode_residues = bl3 = this.getParams().isPredict_residues();
        this.mode_pockets = bl2 = !this.mode_residues;
        this.rescoring = bl = !this.getParams().isPredictions();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        Parametrized.Trait.Helper.$init$(this);
        this.runs = n = runs;
        this.eval = evaluation2 = new Evaluation();
        this.origEval = evaluation = new Evaluation();
        this.classifierStats = classifierStats2 = new ClassifierStats();
        if (this.getParams().isClassifier_train_stats()) {
            ClassifierStats classifierStats3;
            this.classifierTrainStats = classifierStats3 = new ClassifierStats();
        }
        this.residuePredictionStats = classifierStats = new ClassifierStats();
    }

    private static List<Double> repeat(Double value, int times) {
        ArrayList<Double> res = new ArrayList<Double>(times);
        int i = 0;
        while (i != times) {
            res.add(value);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return res;
    }

    private static List<Double> addVectors(List<Double> va, List<Double> vb) {
        if (va == null && vb == null) {
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        if (va == null) {
            List<Double> list = EvalResults.repeat(0.0, vb.size());
            va = list;
        }
        if (vb == null) {
            List<Double> list = EvalResults.repeat(0.0, va.size());
            vb = list;
        }
        ArrayList<Double> res = new ArrayList<Double>(va.size());
        int i = 0;
        while (i != va.size()) {
            res.add(DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.getAt(va, (int)i)) + DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.getAt(vb, (int)i)));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return res;
    }

    public void addSubResults(EvalResults results) {
        this.subResults.add(results);
        this.eval.addAll(results.getEval());
        this.origEval.addAll(results.getOrigEval());
        this.classifierStats.addAll(results.getClassifierStats());
        if (this.classifierTrainStats != null && results.getClassifierTrainStats() != null) {
            this.classifierTrainStats.addAll(results.getClassifierTrainStats());
        }
        this.residuePredictionStats.addAll(results.getResiduePredictionStats());
        if (this.trainTime == null) {
            Long l;
            this.trainTime = l = results.getTrainTime();
        }
        if (this.evalTime == null) {
            Long l;
            this.evalTime = l = results.getEvalTime();
        }
        this.train_negatives = this.train_negatives + results.getTrain_negatives();
        this.train_positives = this.train_positives + results.getTrain_positives();
        List<Double> list = EvalResults.addVectors(this.featureImportances, results.getFeatureImportances());
        this.featureImportances = list;
        this.runs = this.runs + results.getRuns();
    }

    public int getAvgTrainVectors() {
        return this.getAvgTrainPositives() + this.getAvgTrainNegatives();
    }

    public int getAvgTrainPositives() {
        return (int)((double)this.train_positives / (double)this.runs);
    }

    public int getAvgTrainNegatives() {
        return (int)((double)this.train_negatives / (double)this.runs);
    }

    public double getTrainPositivesRatio() {
        if (this.train_positives + this.train_negatives == 0) {
            return 0.0;
        }
        return (double)this.train_positives / (double)(this.train_positives + this.train_negatives);
    }

    public double getTrainRatio() {
        if (this.train_negatives == 0) {
            return 1.0;
        }
        return (double)this.train_positives / (double)this.train_negatives;
    }

    public Map<String, Double> getStats() {
        Long l;
        Reference m = new Reference(new TreeMap());
        if (this.mode_pockets) {
            ((TreeMap)m.get()).putAll(this.eval.getStats());
            double d = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("PROTEINS")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d, null, (Object)((TreeMap)m.get()), (String)"PROTEINS");
            double d2 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("POCKETS")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d2, null, (Object)((TreeMap)m.get()), (String)"POCKETS");
            double d3 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("LIGANDS")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d3, null, (Object)((TreeMap)m.get()), (String)"LIGANDS");
            double d4 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("LIGANDS_IGNORED")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d4, null, (Object)((TreeMap)m.get()), (String)"LIGANDS_IGNORED");
            double d5 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("LIGANDS_SMALL")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d5, null, (Object)((TreeMap)m.get()), (String)"LIGANDS_SMALL");
            double d6 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("LIGANDS_DISTANT")) / (double)this.runs;
            ScriptBytecodeAdapter.setProperty((Object)d6, null, (Object)((TreeMap)m.get()), (String)"LIGANDS_DISTANT");
        }
        double d = DefaultTypeTransformation.doubleUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)(l = this.trainTime)) ? l : (Long)ScriptBytecodeAdapter.castToType((Object)0, Long.class))) / (double)60000;
        ScriptBytecodeAdapter.setProperty((Object)d, null, (Object)((TreeMap)m.get()), (String)"TIME_TRAIN_M");
        Long l2 = this.evalTime;
        double d7 = DefaultTypeTransformation.doubleUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)l2) ? l2 : (Long)ScriptBytecodeAdapter.castToType((Object)0, Long.class))) / (double)60000;
        ScriptBytecodeAdapter.setProperty((Object)d7, null, (Object)((TreeMap)m.get()), (String)"TIME_EVAL_M");
        double d8 = DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("TIME_TRAIN_M")) + DefaultTypeTransformation.doubleUnbox(((TreeMap)m.get()).get("TIME_EVAL_M"));
        ScriptBytecodeAdapter.setProperty((Object)d8, null, (Object)((TreeMap)m.get()), (String)"TIME_M");
        int n = this.getAvgTrainVectors();
        ScriptBytecodeAdapter.setProperty((Object)((Double)ScriptBytecodeAdapter.castToType((Object)n, Double.class)), null, (Object)((TreeMap)m.get()), (String)"TRAIN_VECTORS");
        int n2 = this.getAvgTrainPositives();
        ScriptBytecodeAdapter.setProperty((Object)((Double)ScriptBytecodeAdapter.castToType((Object)n2, Double.class)), null, (Object)((TreeMap)m.get()), (String)"TRAIN_POSITIVES");
        int n3 = this.getAvgTrainNegatives();
        ScriptBytecodeAdapter.setProperty((Object)((Double)ScriptBytecodeAdapter.castToType((Object)n3, Double.class)), null, (Object)((TreeMap)m.get()), (String)"TRAIN_NEGATIVES");
        double d9 = this.getTrainRatio();
        ScriptBytecodeAdapter.setProperty((Object)d9, null, (Object)((TreeMap)m.get()), (String)"TRAIN_RATIO");
        double d10 = this.getTrainPositivesRatio();
        ScriptBytecodeAdapter.setProperty((Object)d10, null, (Object)((TreeMap)m.get()), (String)"TRAIN_POS_RATIO");
        if (this.mode_pockets) {
            ((TreeMap)m.get()).putAll(this.classifierStats.getMetricsMap());
            if (this.getParams().isClassifier_train_stats() && this.classifierTrainStats != null) {
                public final class _getStats_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getStats_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object key, Object value) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{StringGroovyMethods.plus((String)"train_", (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)key, CharSequence.class))), value});
                    }

                    public Object call(Object key, Object value) {
                        return this.doCall(key, value);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getStats_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((TreeMap)m.get()).putAll(DefaultGroovyMethods.collectEntries(this.classifierTrainStats.getMetricsMap(), (Closure)new _getStats_closure1(this, this)));
            }
        }
        if (this.mode_residues) {
            ((TreeMap)m.get()).putAll(this.residuePredictionStats.getMetricsMap());
            ((TreeMap)m.get()).putAll(Cutils.prefixMapKeys(this.classifierStats.getMetricsMap(), "point_"));
        }
        if (this.getParams().isFeature_importances() && this.featureImportances != null) {
            List list;
            public final class _getStats_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getStats_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return DefaultTypeTransformation.doubleUnbox((Object)it) / (double)((EvalResults)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), EvalResults.class)).getRuns();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getStats_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.featureImportances = list = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect(this.featureImportances, (Closure)new _getStats_closure2(this, this)));
            public final class _getStats_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference m;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getStats_closure3(Object _outerInstance, Object _thisObject, Reference m) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.m = reference = m;
                }

                public Object doCall(Object it) {
                    return ((TreeMap)this.m.get()).put(StringGroovyMethods.plus((String)"_FI_", (CharSequence)((FeatureImportance)it).getName()), ((FeatureImportance)it).getImportance());
                }

                public Map getM() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.m.get(), Map.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getStats_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.getNamedImportances(), (Closure)new _getStats_closure3(this, this, m));
        }
        ((TreeMap)m.get()).putAll(this.additionalStats);
        return (TreeMap)m.get();
    }

    public MultiRunStats getMultiStats() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            List<EvalResults> list = this.subResults;
            valueRecorder.record(list, 9);
            valueRecorder.record(list, 9);
            boolean bl = list.isEmpty();
            valueRecorder.record((Object)bl, 20);
            if (!bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !subResults.isEmpty()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        public final class _getMultiStats_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMultiStats_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((EvalResults)it).getStats();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMultiStats_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List subStats = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect(this.subResults, (Closure)new _getMultiStats_closure4(this, this)));
        List statNames = DefaultGroovyMethods.toList(((Map)DefaultGroovyMethods.getAt((List)subStats, (int)0)).keySet());
        return new MultiRunStats(statNames, subStats);
    }

    public Map<String, Double> getStatsStddev() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            List<EvalResults> list = this.subResults;
            valueRecorder.record(list, 9);
            valueRecorder.record(list, 9);
            boolean bl = list.isEmpty();
            valueRecorder.record((Object)bl, 20);
            if (!bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !subResults.isEmpty()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        public final class _getStatsStddev_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getStatsStddev_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((EvalResults)it).getStats();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getStatsStddev_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List subStats = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect(this.subResults, (Closure)new _getStatsStddev_closure5(this, this)));
        HashMap<String, Double> res = new HashMap<String, Double>();
        Reference stat = new Reference(null);
        Iterator iterator = ((Map)DefaultGroovyMethods.head((List)subStats)).keySet().iterator();
        while (iterator.hasNext()) {
            stat.set((Object)ShortTypeHandling.castToString(iterator.next()));
            public final class _getStatsStddev_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference stat;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getStatsStddev_closure6(Object _outerInstance, Object _thisObject, Reference stat) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.stat = reference = stat;
                }

                public Object doCall(Object it) {
                    return ((Map)it).get(this.stat.get());
                }

                public String getStat() {
                    return ShortTypeHandling.castToString((Object)this.stat.get());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getStatsStddev_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            double val = MathUtils.stddev(DefaultGroovyMethods.collect((Iterable)subStats, (Closure)new _getStatsStddev_closure6(this, this, stat)));
            res.put((String)stat.get(), val);
        }
        return res;
    }

    public String statsCSV(Map stats) {
        public final class _statsCSV_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _statsCSV_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{((Map.Entry)it).getKey(), Formatter.fmt(((Map.Entry)it).getValue())}, new String[]{"", ", ", ""});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _statsCSV_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Map)stats, (Closure)new _statsCSV_closure7(this, this)), (String)"\n");
    }

    public String logClassifierStats(String fileLabel, String classifierLabel, ClassifierStats cs, String outdir) {
        String stats_str = cs.toCSV(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{classifierLabel}, new String[]{" ", " "})));
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir, fileLabel}, new String[]{"", "/", ".csv"})), stats_str);
        String dir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir, fileLabel}, new String[]{"", "/", ""}));
        Futils.mkdirs(dir);
        if (cs.getCollecting() && this.getParams().isStats_curves()) {
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/roc_curve.csv"})), Curves.roc(cs.getPredictions()).toCSV());
        }
        return stats_str;
    }

    public void logAndStore(String outdir, String classifierName, Boolean logIndividualCases) {
        Futils.mkdirs(outdir);
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/stats.csv"})), this.statsCSV(this.getStats()));
        if (this.subResults.size() > 1) {
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/stats_stddev.csv"})), this.statsCSV(this.getStatsStddev()));
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/stats_runs.csv"})), this.getMultiStats().toCSV());
        }
        String pst = this.logClassifierStats("point_classification", classifierName, this.classifierStats, outdir);
        if (this.mode_residues) {
            String rst = this.logClassifierStats("residue_classification", "Residue classification", this.residuePredictionStats, outdir);
            EvalResults.write(StringGroovyMethods.plus((String)"\n", (CharSequence)CSV.tabulate(pst)));
            EvalResults.write(StringGroovyMethods.plus((String)CSV.tabulate(rst), (CharSequence)"\n"));
        }
        if (this.mode_pockets) {
            List<Integer> tolerances = this.getParams().getEval_tolerances();
            String succ_rates = this.origEval.toSuccRatesCSV(tolerances);
            String succ_rates_rescored = this.eval.toSuccRatesCSV(tolerances);
            String succ_rates_diff = this.eval.diffSuccRatesCSV(tolerances, this.origEval);
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/success_rates.csv"})), succ_rates_rescored);
            if (this.rescoring) {
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/success_rates_original.csv"})), succ_rates);
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/success_rates_diff.csv"})), succ_rates_diff);
            }
            Boolean bl = logIndividualCases;
            if (bl == null ? false : bl) {
                this.origEval.sort();
                this.eval.sort();
                String casedir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/cases"}));
                Futils.mkdirs(casedir);
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/proteins.csv"})), this.eval.toProteinsCSV());
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/ligands.csv"})), this.eval.toLigandsCSV());
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/pockets.csv"})), this.eval.toPocketsCSV());
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/ranks.csv"})), this.eval.toRanksCSV());
                if (this.rescoring) {
                    Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{casedir}, new String[]{"", "/ranks_original.csv"})), this.origEval.toRanksCSV());
                }
            }
            if (this.rescoring) {
                Object v1;
                if (log.isInfoEnabled()) {
                    log.info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\nSucess Rates - Original:\n", (CharSequence)CSV.tabulate(succ_rates)), (CharSequence)"\n"));
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
            EvalResults.write(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\nSucess Rates:\n", (CharSequence)CSV.tabulate(succ_rates_rescored)), (CharSequence)"\n"));
            if (this.rescoring) {
                Object v2;
                if (log.isInfoEnabled()) {
                    log.info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\nSucess Rates - Diff:\n", (CharSequence)CSV.tabulate(succ_rates_diff)), (CharSequence)"\n\n"));
                    v2 = null;
                } else {
                    v2 = null;
                }
            }
        }
        if (this.getParams().isFeature_importances() && this.featureImportances != null) {
            List<FeatureImportance> namedImportances = this.getNamedImportances();
            public final class _logAndStore_closure8
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _logAndStore_closure8(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return -((FeatureImportance)it).getImportance();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _logAndStore_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.sort(namedImportances, (Closure)new _logAndStore_closure8(this, this));
            public final class _logAndStore_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _logAndStore_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)((FeatureImportance)it).getName(), (CharSequence)", "), (CharSequence)EvalResults.fmt_fi(((FeatureImportance)it).getImportance()));
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _logAndStore_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            String sortedCsv = StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(namedImportances, (Closure)new _logAndStore_closure9(this, this)), (String)"\n"), (CharSequence)"\n");
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outdir}, new String[]{"", "/feature_importances_sorted.csv"})), sortedCsv);
        }
    }

    public static String fmt_fi(Object x) {
        if (x == null) {
            return "";
        }
        return DefaultGroovyMethods.sprintf(EvalResults.class, (String)"%8.6f", (Object)x);
    }

    public List<FeatureImportance> getNamedImportances() {
        if (this.featureImportances == null) {
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        List<String> names = FeatureExtractor.createFactory().getVectorHeader();
        ArrayList<FeatureImportance> namedImportances = new ArrayList<FeatureImportance>();
        int i = 0;
        while (i != names.size()) {
            namedImportances.add(new FeatureImportance(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(names, (int)i)), DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.getAt(this.featureImportances, (int)i))));
            int cfr_ignored_0 = i + 1;
        }
        return namedImportances;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EvalResults.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(EvalResults.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{EvalResults.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(EvalResults.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{EvalResults.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(EvalResults.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{EvalResults.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(EvalResults.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{EvalResults.class, arg1});
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.results.EvalResults");
        Writable.Trait.Helper.$static$init$(EvalResults.class);
        Parametrized.Trait.Helper.$static$init$(EvalResults.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(EvalResults.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, EvalResults.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(EvalResults.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ int pfaccess$0(EvalResults $that) {
        return $that.getRuns();
    }

    @Generated
    public void logAndStore(String outdir, String classifierName) {
        this.logAndStore(outdir, classifierName, this.getParams().isLog_cases());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public int getRuns() {
        return this.runs;
    }

    @Generated
    public void setRuns(int n) {
        this.runs = n;
    }

    @Generated
    public Evaluation getEval() {
        return this.eval;
    }

    @Generated
    public void setEval(Evaluation evaluation) {
        this.eval = evaluation;
    }

    @Generated
    public Evaluation getOrigEval() {
        return this.origEval;
    }

    @Generated
    public void setOrigEval(Evaluation evaluation) {
        this.origEval = evaluation;
    }

    @Generated
    public ClassifierStats getClassifierStats() {
        return this.classifierStats;
    }

    @Generated
    public void setClassifierStats(ClassifierStats classifierStats) {
        this.classifierStats = classifierStats;
    }

    @Generated
    public ClassifierStats getClassifierTrainStats() {
        return this.classifierTrainStats;
    }

    @Generated
    public void setClassifierTrainStats(ClassifierStats classifierStats) {
        this.classifierTrainStats = classifierStats;
    }

    @Generated
    public ClassifierStats getResiduePredictionStats() {
        return this.residuePredictionStats;
    }

    @Generated
    public void setResiduePredictionStats(ClassifierStats classifierStats) {
        this.residuePredictionStats = classifierStats;
    }

    @Generated
    public Dataset.Result getDatasetResult() {
        return this.datasetResult;
    }

    @Generated
    public void setDatasetResult(Dataset.Result result) {
        this.datasetResult = result;
    }

    @Generated
    public Long getTrainTime() {
        return this.trainTime;
    }

    @Generated
    public void setTrainTime(Long l) {
        this.trainTime = l;
    }

    @Generated
    public Long getEvalTime() {
        return this.evalTime;
    }

    @Generated
    public void setEvalTime(Long l) {
        this.evalTime = l;
    }

    @Generated
    public int getTrain_positives() {
        return this.train_positives;
    }

    @Generated
    public void setTrain_positives(int n) {
        this.train_positives = n;
    }

    @Generated
    public int getTrain_negatives() {
        return this.train_negatives;
    }

    @Generated
    public void setTrain_negatives(int n) {
        this.train_negatives = n;
    }

    @Generated
    public List<Double> getFeatureImportances() {
        return this.featureImportances;
    }

    @Generated
    public void setFeatureImportances(List<Double> list) {
        this.featureImportances = list;
    }

    @Generated
    public List<EvalResults> getSubResults() {
        return this.subResults;
    }

    @Generated
    public void setSubResults(List<EvalResults> list) {
        this.subResults = list;
    }

    @Generated
    public Map<String, Double> getAdditionalStats() {
        return this.additionalStats;
    }

    @Generated
    public void setAdditionalStats(Map<String, Double> map) {
        this.additionalStats = map;
    }

    @Generated
    public boolean getMode_residues() {
        return this.mode_residues;
    }

    @Generated
    public boolean isMode_residues() {
        return this.mode_residues;
    }

    @Generated
    public void setMode_residues(boolean bl) {
        this.mode_residues = bl;
    }

    @Generated
    public boolean getMode_pockets() {
        return this.mode_pockets;
    }

    @Generated
    public boolean isMode_pockets() {
        return this.mode_pockets;
    }

    @Generated
    public void setMode_pockets(boolean bl) {
        this.mode_pockets = bl;
    }

    @Generated
    public boolean getRescoring() {
        return this.rescoring;
    }

    @Generated
    public boolean isRescoring() {
        return this.rescoring;
    }

    @Generated
    public void setRescoring(boolean bl) {
        this.rescoring = bl;
    }

    public static class FeatureImportance
    implements GroovyObject {
        private String name;
        private double importance;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public FeatureImportance(String name, double importance) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = name;
            double d = importance;
            this.importance = d;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != FeatureImportance.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(FeatureImportance.class, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(FeatureImportance.class, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(FeatureImportance.class, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(FeatureImportance.class, EvalResults.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public double getImportance() {
            return this.importance;
        }

        @Generated
        public void setImportance(double d) {
            this.importance = d;
        }
    }
}

