/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import cz.siret.prank.domain.Dataset;
import cz.siret.prank.domain.Prediction;
import cz.siret.prank.domain.PredictionPair;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.prediction.pockets.rescorers.ModelBasedRescorer;
import cz.siret.prank.prediction.pockets.results.RescoringSummary;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.ml.Model;
import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RescoreRoutine
extends Routine {
    private Dataset dataset;
    private String modelf;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public RescoreRoutine(Dataset dataSet, String modelf, String outdir) {
        super(outdir);
        String string;
        Dataset dataset;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.dataset = dataset = dataSet;
        this.modelf = string = modelf;
    }

    public Dataset.Result execute() {
        Object v0;
        ATimer timer = ATimer.startTimer();
        Futils.mkdirs(this.getOutdir());
        this.writeParams(this.getOutdir());
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataset.getName()}, new String[]{"rescoring pockets on proteins from dataset [", "]"})));
        if (!(this.dataset.getHeader().contains(Dataset.getCOLUMN_PROTEIN()) && this.dataset.getHeader().contains(Dataset.getCOLUMN_PREDICTION()))) {
            throw (Throwable)new PrankException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Dataset.getCOLUMN_PROTEIN(), Dataset.getCOLUMN_PREDICTION()}, new String[]{"Dataset must contain '", "' and '", "' columns!"})));
        }
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"outdir: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        Reference model = new Reference((Object)Model.loadFromFile(this.modelf));
        ((Model)model.get()).disableParalelism();
        Reference extractor = new Reference((Object)FeatureExtractor.createFactory());
        public final class _execute_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference model;
            private /* synthetic */ Reference extractor;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure1(Object _outerInstance, Object _thisObject, Reference model, Reference extractor) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.model = reference2 = model;
                this.extractor = reference = extractor;
            }

            public Object doCall(Dataset.Item item) {
                Object v0;
                PredictionPair pair = item.getPredictionPair();
                Prediction prediction = pair.getPrediction();
                ModelBasedRescorer rescorer = new ModelBasedRescorer((Model)ScriptBytecodeAdapter.castToType((Object)this.model.get(), Model.class), (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)this.extractor.get(), FeatureExtractor.class));
                rescorer.reorderPockets(prediction, item.getContext());
                RescoringSummary rsum = new RescoringSummary(prediction);
                Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((RescoreRoutine)((Routine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Routine.class))).getOutdir(), item.getLabel()}, new String[]{"", "/", "_rescored.csv"})), rsum.toCSV());
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{item.getLabel()}, new String[]{"\n\nRescored pockets for [", "]: \n\n"}).plus(rsum.toTable()).plus("\n")));
                    v0 = null;
                } else {
                    v0 = null;
                }
                return v0;
            }

            public Object call(Dataset.Item item) {
                return this.doCall(item);
            }

            public Model getModel() {
                return (Model)ScriptBytecodeAdapter.castToType((Object)this.model.get(), Model.class);
            }

            public FeatureExtractor getExtractor() {
                return (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)this.extractor.get(), FeatureExtractor.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Dataset.Result result = this.dataset.processItems(new _execute_closure1(this, this, model, extractor));
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{timer.getFormatted()}, new String[]{"rescoring finished in ", ""})));
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Futils.absPath(this.getOutdir())}, new String[]{"results saved to directory [", "]"})));
        return result;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RescoreRoutine.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.RescoreRoutine");
    }

    @Generated
    public Dataset getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Generated
    public String getModelf() {
        return this.modelf;
    }

    @Generated
    public void setModelf(String string) {
        this.modelf = string;
    }
}

