/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import cz.siret.prank.domain.Dataset;
import cz.siret.prank.domain.PredictionPair;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.LigandBasedResidueLabeler;
import cz.siret.prank.domain.labeling.ResidueLabelings;
import cz.siret.prank.domain.loaders.LoaderParams;
import cz.siret.prank.features.FeatureExtractor;
import cz.siret.prank.prediction.metrics.ClassifierStats;
import cz.siret.prank.prediction.pockets.rescorers.ModelBasedRescorer;
import cz.siret.prank.prediction.pockets.results.PredictionSummary;
import cz.siret.prank.prediction.transformation.ScoreTransformer;
import cz.siret.prank.program.ml.Model;
import cz.siret.prank.program.rendering.OldPymolRenderer;
import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.program.routines.results.PredictResults;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.Iterator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictRoutine
extends Routine {
    private Dataset dataset;
    private String modelf;
    private boolean collectStats;
    private boolean produceVisualizations;
    private boolean produceFilesystemOutput;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PredictRoutine(Dataset dataset, String modelf, String outdir) {
        super(outdir);
        String string;
        Dataset dataset2;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.collectStats = bl3 = false;
        this.produceVisualizations = bl2 = this.getParams().getVisualizations();
        this.produceFilesystemOutput = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.dataset = dataset2 = dataset;
        this.modelf = string = modelf;
    }

    public static PredictRoutine createForInternalUse(Dataset dataset, String modelf) {
        PredictRoutine routine = new PredictRoutine(dataset, modelf, null);
        boolean bl = false;
        routine.setProduceFilesystemOutput(bl);
        boolean bl2 = false;
        routine.setProduceVisualizations(bl2);
        return routine;
    }

    public Dataset.Result execute() {
        ATimer timer = ATimer.startTimer();
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataset.getName()}, new String[]{"predicting pockets for proteins from dataset [", "]"})));
        if (this.produceFilesystemOutput) {
            Object v0;
            Futils.mkdirs(this.getOutdir());
            this.writeParams(this.getOutdir());
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"outdir: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        Reference model = new Reference((Object)Model.loadFromFile(this.modelf));
        ((Model)model.get()).disableParalelism();
        Reference visDir = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", "/visualizations"})));
        Reference predDir = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", ""})));
        if (this.produceVisualizations) {
            Futils.mkdirs((String)visDir.get());
        }
        if (this.collectStats) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", "/predictions"});
            predDir.set((Object)ShortTypeHandling.castToString((Object)gStringImpl));
            Futils.mkdirs((String)predDir.get());
        }
        Reference stats = new Reference((Object)new PredictResults());
        Reference extractor = new Reference((Object)FeatureExtractor.createFactory());
        if (!this.collectStats) {
            boolean bl = true;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        }
        Reference outputPredictionFiles = new Reference((Object)(this.produceFilesystemOutput && !this.getParams().getOutput_only_stats() ? 1 : 0));
        public final class _execute_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference model;
            private /* synthetic */ Reference extractor;
            private /* synthetic */ Reference visDir;
            private /* synthetic */ Reference outputPredictionFiles;
            private /* synthetic */ Reference predDir;
            private /* synthetic */ Reference stats;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure1(Object _outerInstance, Object _thisObject, Reference model, Reference extractor, Reference visDir, Reference outputPredictionFiles, Reference predDir, Reference stats) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.model = reference6 = model;
                this.extractor = reference5 = extractor;
                this.visDir = reference4 = visDir;
                this.outputPredictionFiles = reference3 = outputPredictionFiles;
                this.predDir = reference2 = predDir;
                this.stats = reference = stats;
            }

            public Object doCall(Dataset.Item item) {
                PredictionPair pair = item.getPredictionPair();
                ModelBasedRescorer rescorer = new ModelBasedRescorer((Model)ScriptBytecodeAdapter.castToType((Object)this.model.get(), Model.class), (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)this.extractor.get(), FeatureExtractor.class));
                rescorer.reorderPockets(pair.getPrediction(), item.getContext());
                if (((PredictRoutine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PredictRoutine.class)).getProduceVisualizations()) {
                    new OldPymolRenderer(ShortTypeHandling.castToString((Object)this.visDir.get())).visualizeHistograms(item, rescorer, pair);
                }
                Object object = this.outputPredictionFiles.get();
                if (object == null ? false : (Boolean)object) {
                    PredictionSummary psum = new PredictionSummary(pair.getPrediction());
                    String outf = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.predDir.get(), item.getLabel()}, new String[]{"", "/", "_predictions.csv"}));
                    Futils.writeFile(outf, psum.toCSV().toString());
                    if (((PredictRoutine)((Routine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Routine.class))).getParams().getLabel_residues() && pair.getPrediction().getResidueLabelings() != null) {
                        String resf = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.predDir.get(), item.getLabel()}, new String[]{"", "/", "_residues.csv"}));
                        Futils.writeFile(resf, pair.getPrediction().getResidueLabelings().toCSV());
                    }
                }
                if (((PredictRoutine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PredictRoutine.class)).getCollectStats()) {
                    if (((PredictRoutine)((Routine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Routine.class))).getParams().getLabel_residues() && pair.getPrediction().getResidueLabelings() != null) {
                        BinaryLabeling observed = new LigandBasedResidueLabeler().getBinaryLabeling(pair.getProtein());
                        BinaryLabeling binaryLabeling = observed;
                        pair.getPrediction().getResidueLabelings().setObserved(binaryLabeling);
                    }
                    ((PredictResults)this.stats.get()).getEvaluation().addPrediction(pair, pair.getPrediction().getPockets());
                    ClassifierStats classifierStats = ((PredictResults)this.stats.get()).getClassStats();
                    synchronized (classifierStats) {
                        ((PredictResults)this.stats.get()).getClassStats().addAll(rescorer.getStats());
                    }
                }
                if (!((PredictRoutine)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PredictRoutine.class)).getDataset().getCached()) {
                    Object var10_10 = null;
                    item.setCachedPair((PredictionPair)ScriptBytecodeAdapter.castToType(var10_10, PredictionPair.class));
                    return null;
                }
                return null;
            }

            public Object call(Dataset.Item item) {
                return this.doCall(item);
            }

            public Model getModel() {
                return (Model)ScriptBytecodeAdapter.castToType((Object)this.model.get(), Model.class);
            }

            public FeatureExtractor getExtractor() {
                return (FeatureExtractor)ScriptBytecodeAdapter.castToType((Object)this.extractor.get(), FeatureExtractor.class);
            }

            public String getVisDir() {
                return ShortTypeHandling.castToString((Object)this.visDir.get());
            }

            public Boolean getOutputPredictionFiles() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.outputPredictionFiles.get(), Boolean.class);
            }

            public String getPredDir() {
                return ShortTypeHandling.castToString((Object)this.predDir.get());
            }

            public PredictResults getStats() {
                return (PredictResults)ScriptBytecodeAdapter.castToType((Object)this.stats.get(), PredictResults.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Dataset.Result result = this.dataset.processItems(new _execute_closure1(this, this, model, extractor, visDir, outputPredictionFiles, predDir, stats));
        if (this.collectStats && this.produceFilesystemOutput) {
            String modelLabel = StringGroovyMethods.plus((String)((Model)model.get()).getClassifier().getClass().getSimpleName(), (CharSequence)new GStringImpl(new Object[]{this.modelf}, new String[]{" (", ")"}));
            ((PredictResults)stats.get()).logAndStore(this.getOutdir(), modelLabel);
            ((PredictResults)stats.get()).logMainResults(this.getOutdir(), modelLabel);
            if (this.getParams().getTrain_score_transformers() != null) {
                String scoreDir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", "/score"}));
                Futils.mkdirs(scoreDir);
                String name = null;
                Iterator<String> iterator = this.getParams().getTrain_score_transformers().iterator();
                while (iterator.hasNext()) {
                    name = ShortTypeHandling.castToString((Object)iterator.next());
                    try {
                        ScoreTransformer transformer = ScoreTransformer.create(name);
                        transformer.trainForPockets(((PredictResults)stats.get()).getEvaluation());
                        String fname = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{scoreDir, name}, new String[]{"", "/", ".json"}));
                        Futils.writeFile(fname, ScoreTransformer.saveToJson(transformer));
                        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, fname}, new String[]{"Trained score transformer '", "' written to: ", ""})));
                    }
                    catch (Exception e) {
                        Object v1;
                        if (log.isErrorEnabled()) {
                            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"Failed to train score transformer '", "'"})), (Throwable)e);
                            v1 = null;
                            continue;
                        }
                        v1 = null;
                    }
                }
            }
            if (this.getParams().getLabel_residues() && this.getParams().getTrain_score_transformers_for_residues()) {
                ResidueLabelings.trainResidueScoreTransformers(this.getOutdir(), ((PredictResults)stats.get()).getEvaluation());
            }
        }
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{timer.getFormatted()}, new String[]{"predicting pockets finished in ", ""})));
        if (this.produceFilesystemOutput) {
            Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Futils.absPath(this.getOutdir())}, new String[]{"results saved to directory [", "]"})));
        }
        return result;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PredictRoutine.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ Dataset pfaccess$0(PredictRoutine $that) {
        return $that.getDataset();
    }

    public static /* synthetic */ boolean pfaccess$1(PredictRoutine $that) {
        return $that.getCollectStats();
    }

    public static /* synthetic */ boolean pfaccess$2(PredictRoutine $that) {
        return $that.getProduceVisualizations();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.PredictRoutine");
    }

    @Generated
    public Dataset getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Generated
    public String getModelf() {
        return this.modelf;
    }

    @Generated
    public void setModelf(String string) {
        this.modelf = string;
    }

    @Generated
    public boolean getCollectStats() {
        return this.collectStats;
    }

    @Generated
    public boolean isCollectStats() {
        return this.collectStats;
    }

    @Generated
    public void setCollectStats(boolean bl) {
        this.collectStats = bl;
    }

    @Generated
    public boolean getProduceVisualizations() {
        return this.produceVisualizations;
    }

    @Generated
    public boolean isProduceVisualizations() {
        return this.produceVisualizations;
    }

    @Generated
    public void setProduceVisualizations(boolean bl) {
        this.produceVisualizations = bl;
    }

    @Generated
    public boolean getProduceFilesystemOutput() {
        return this.produceFilesystemOutput;
    }

    @Generated
    public boolean isProduceFilesystemOutput() {
        return this.produceFilesystemOutput;
    }

    @Generated
    public void setProduceFilesystemOutput(boolean bl) {
        this.produceFilesystemOutput = bl;
    }
}

