/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import cz.siret.prank.program.params.Params;
import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.program.routines.results.EvalResults;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.Cutils;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParamLooper
extends Routine {
    private List<Step> steps;
    private String statsTableFile;
    private String selectedStatsFile;
    private String plotsDir;
    private String tablesDir;
    private String runsDir;
    private Map<String, String> tables2D;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ParamLooper(String outdir) {
        super(outdir);
        MetaClass metaClass;
        ArrayList<Step> arrayList = new ArrayList<Step>();
        this.steps = arrayList;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.tables2D = linkedHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        GStringImpl gStringImpl = new GStringImpl(new Object[]{outdir}, new String[]{"", "/plots"});
        this.plotsDir = ShortTypeHandling.castToString((Object)gStringImpl);
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{outdir}, new String[]{"", "/param_stats.csv"});
        this.statsTableFile = ShortTypeHandling.castToString((Object)gStringImpl2);
        GStringImpl gStringImpl3 = new GStringImpl(new Object[]{outdir}, new String[]{"", "/selected_stats.csv"});
        this.selectedStatsFile = ShortTypeHandling.castToString((Object)gStringImpl3);
        GStringImpl gStringImpl4 = new GStringImpl(new Object[]{outdir}, new String[]{"", "/runs"});
        this.runsDir = ShortTypeHandling.castToString((Object)gStringImpl4);
    }

    public ParamLooper init() {
        Futils.mkdirs(this.getOutdir());
        Futils.mkdirs(this.runsDir);
        this.writeParams(this.getOutdir());
        return this;
    }

    public EvalResults processStep(Step step, String dirLabel, Closure<EvalResults> closure) {
        ATimer stepTimer = ATimer.startTimer();
        step.applyToParams(this.getParams());
        String stepDir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.runsDir, dirLabel}, new String[]{"", "/", ""}));
        EvalResults res = (EvalResults)ScriptBytecodeAdapter.castToType((Object)closure.call((Object)stepDir), EvalResults.class);
        step.getResults().putAll(res.getStats());
        double d = stepTimer.getMinutes();
        ScriptBytecodeAdapter.setProperty((Object)d, null, step.getResults(), (String)"TIME_MINUTES");
        if (res.getSubResults().size() > 1) {
            step.getResults().putAll(Cutils.prefixMapKeys(res.getStatsStddev(), "_stddev_"));
        }
        if (!Futils.exists(this.statsTableFile)) {
            Futils.appendl(this.statsTableFile, step.getHeader());
            Futils.appendl(this.selectedStatsFile, step.getHeader(this.getParams().getSelected_stats()));
        }
        Futils.appendl(this.statsTableFile, step.toCSV());
        Futils.appendl(this.selectedStatsFile, step.toCSV(this.getParams().getSelected_stats()));
        return res;
    }

    public static String fmt(Object x) {
        if (x == null) {
            return "";
        }
        if (x instanceof Double) {
            return DefaultGroovyMethods.sprintf(ParamLooper.class, (String)"%8.4f", (Object)x);
        }
        return DefaultGroovyMethods.toString((Object)x);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ParamLooper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ParamLooper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ParamLooper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ParamLooper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.ParamLooper");
    }

    @Generated
    public List<Step> getSteps() {
        return this.steps;
    }

    @Generated
    public void setSteps(List<Step> list) {
        this.steps = list;
    }

    @Generated
    public String getStatsTableFile() {
        return this.statsTableFile;
    }

    @Generated
    public void setStatsTableFile(String string) {
        this.statsTableFile = string;
    }

    @Generated
    public String getSelectedStatsFile() {
        return this.selectedStatsFile;
    }

    @Generated
    public void setSelectedStatsFile(String string) {
        this.selectedStatsFile = string;
    }

    @Generated
    public String getPlotsDir() {
        return this.plotsDir;
    }

    @Generated
    public void setPlotsDir(String string) {
        this.plotsDir = string;
    }

    @Generated
    public String getTablesDir() {
        return this.tablesDir;
    }

    @Generated
    public void setTablesDir(String string) {
        this.tablesDir = string;
    }

    @Generated
    public String getRunsDir() {
        return this.runsDir;
    }

    @Generated
    public void setRunsDir(String string) {
        this.runsDir = string;
    }

    @Generated
    public Map<String, String> getTables2D() {
        return this.tables2D;
    }

    @Generated
    public void setTables2D(Map<String, String> map) {
        this.tables2D = map;
    }

    public static class Step
    implements GroovyObject {
        private List<ParamVal> params;
        private Map<String, Double> results;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public Step(List<ParamVal> params, Map<String, Double> results) {
            MetaClass metaClass;
            ArrayList<ParamVal> arrayList = new ArrayList<ParamVal>();
            this.params = arrayList;
            LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
            this.results = linkedHashMap;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            List<ParamVal> list = params;
            this.params = list;
            Map<String, Double> map = results;
            this.results = map;
        }

        @Generated
        public Step(List<ParamVal> params) {
            this(params, new LinkedHashMap());
        }

        @Generated
        public Step() {
            this(new ArrayList(), new LinkedHashMap());
        }

        public void applyToParams(Params globalParams) {
            Reference globalParams2 = new Reference((Object)globalParams);
            public final class _applyToParams_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference globalParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _applyToParams_closure1(Object _outerInstance, Object _thisObject, Reference globalParams) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.globalParams = reference = globalParams;
                }

                public Object doCall(Object it) {
                    return ((Params)this.globalParams.get()).setParam(((ParamVal)it).getName(), ((ParamVal)it).getValue());
                }

                public Params getGlobalParams() {
                    return (Params)ScriptBytecodeAdapter.castToType((Object)this.globalParams.get(), Params.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _applyToParams_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.params, (Closure)new _applyToParams_closure1(this, this, globalParams2));
        }

        public Step extendWith(String pname, Object pval) {
            Step step = new Step();
            ParamVal paramVal = new ParamVal();
            String string = pname;
            paramVal.setName(string);
            Object object = pval;
            paramVal.setValue(object);
            List list = DefaultGroovyMethods.plus(this.params, (Object)paramVal);
            step.setParams(list);
            return step;
        }

        public String getLabel() {
            public final class _getLabel_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLabel_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)((ParamVal)it).getName(), (CharSequence)"."), (Object)((ParamVal)it).getValue());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLabel_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(this.params, (Closure)new _getLabel_closure2(this, this)), (String)".");
        }

        public String getHeader() {
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Step.class, this.params, (String)"name"), Iterable.class)), (String)", "), (CharSequence)", "), (CharSequence)DefaultGroovyMethods.join(this.results.keySet(), (String)", "));
        }

        public String getHeader(List<String> selectedStats) {
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Step.class, this.params, (String)"name"), Iterable.class)), (String)", "), (CharSequence)", "), (CharSequence)DefaultGroovyMethods.join(selectedStats, (String)", "));
        }

        public String toCSV() {
            CallSite[] callSiteArray = Step.$getCallSiteArray();
            public final class _toCSV_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _toCSV_closure3(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _toCSV_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _toCSV_closure3.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(it));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _toCSV_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toCSV_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "fmt";
                    stringArray[1] = "value";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _toCSV_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_toCSV_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _toCSV_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _toCSV_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _toCSV_closure4(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _toCSV_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _toCSV_closure4.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _toCSV_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toCSV_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "fmt";
                    return new CallSiteArray(_toCSV_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _toCSV_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return ShortTypeHandling.castToString((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(this.params, (Object)new _toCSV_closure3(this, this)), (Object)", "), (Object)", "), callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(this.results), (Object)new _toCSV_closure4(this, this)), (Object)", ")));
        }

        public String toCSV(List<String> selectedStats) {
            CallSite[] callSiteArray = Step.$getCallSiteArray();
            public final class _toCSV_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _toCSV_closure5(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _toCSV_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _toCSV_closure5.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(it));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _toCSV_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toCSV_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "fmt";
                    stringArray[1] = "value";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _toCSV_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_toCSV_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _toCSV_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _toCSV_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _toCSV_closure6(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _toCSV_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _toCSV_closure6.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), it));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _toCSV_closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toCSV_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "fmt";
                    stringArray[1] = "get";
                    stringArray[2] = "results";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _toCSV_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_toCSV_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _toCSV_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return ShortTypeHandling.castToString((Object)callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(this.params, (Object)new _toCSV_closure5(this, this)), (Object)", "), (Object)", "), callSiteArray[11].call(callSiteArray[12].call(selectedStats, (Object)new _toCSV_closure6(this, this)), (Object)", ")));
        }

        public String toString() {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.toListString(this.params), DefaultGroovyMethods.toMapString(this.results)}, new String[]{"Step{", ", ", "}"}));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Step.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Step.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Step.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Step.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Step.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public List<ParamVal> getParams() {
            return this.params;
        }

        @Generated
        public void setParams(List<ParamVal> list) {
            this.params = list;
        }

        @Generated
        public Map<String, Double> getResults() {
            return this.results;
        }

        @Generated
        public void setResults(Map<String, Double> map) {
            this.results = map;
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "plus";
            stringArray[2] = "join";
            stringArray[3] = "collect";
            stringArray[4] = "join";
            stringArray[5] = "collect";
            stringArray[6] = "values";
            stringArray[7] = "plus";
            stringArray[8] = "plus";
            stringArray[9] = "join";
            stringArray[10] = "collect";
            stringArray[11] = "join";
            stringArray[12] = "collect";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[13];
            Step.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Step.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Step.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ParamVal
    implements GroovyObject {
        private String name;
        private Object value;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ParamVal(String name, Object value) {
            Object object;
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = name;
            this.value = object = value;
        }

        @Generated
        public ParamVal(String name) {
            this(name, null);
        }

        @Generated
        public ParamVal() {
            this(null, null);
        }

        public String toString() {
            return StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)this.name, (CharSequence)":"), (Object)this.value);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ParamVal.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ParamVal.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ParamVal.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ParamVal.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ParamVal.class, ParamLooper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public void setValue(Object object) {
            this.value = object;
        }
    }
}

