/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import cz.siret.prank.program.params.ListParam;
import cz.siret.prank.program.routines.ParamLooper;
import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.program.routines.results.EvalResults;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.rlang.RPlotter;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovyx.gpars.GParsPool;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridOptimizer
extends ParamLooper {
    private List<ListParam> listParams;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GridOptimizer(String outdir, List<ListParam> listParams) {
        super(outdir);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        List<ListParam> list = listParams;
        this.listParams = list;
    }

    public void runGridOptimization(Closure<EvalResults> closure) {
        Object v0;
        ATimer timer = ATimer.startTimer();
        List<ParamLooper.Step> list = this.generateSteps(this.listParams);
        ScriptBytecodeAdapter.setGroovyObjectProperty(list, GridOptimizer.class, (GroovyObject)this, (String)"steps");
        if (log.isInfoEnabled()) {
            log.info(StringGroovyMethods.plus((String)"STEPS: ", (CharSequence)DefaultGroovyMethods.toListString(this.getSteps()).replace("Step", "\nStep")));
            v0 = null;
        } else {
            v0 = null;
        }
        ParamLooper.Step step = null;
        Iterator<ParamLooper.Step> iterator = this.getSteps().iterator();
        while (iterator.hasNext()) {
            step = (ParamLooper.Step)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ParamLooper.Step.class);
            this.processStep(step, step.getLabel(), closure);
            if (!(this.listParams.size() == 2)) continue;
            this.make2DTables(step);
        }
        this.logTime(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{timer.getFormatted()}, new String[]{"param iteration finished in ", ""})));
        Routine.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Futils.absPath(this.getOutdir())}, new String[]{"results saved to directory [", "]"})));
        this.makePlots();
        if (this.getParams().getPloop_delete_runs()) {
            Futils.delete(this.getRunsDir());
        } else if (this.getParams().getPloop_zip_runs()) {
            Futils.zipAndDelete(this.getRunsDir(), Futils.ZIP_BEST_COMPRESSION);
        }
        this.logTime(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{timer.getFormatted()}, new String[]{"ploop routine finished in ", ""})));
    }

    private void make2DTables(ParamLooper.Step step) {
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", "/tables"});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), GridOptimizer.class, (GroovyObject)this, (String)"tablesDir");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)map, LinkedHashMap.class)), GridOptimizer.class, (GroovyObject)this, (String)"tables2D");
        public final class _make2DTables_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _make2DTables_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((GridOptimizer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GridOptimizer.class)).make2DTable(ShortTypeHandling.castToString(((Map.Entry)it).getKey()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _make2DTables_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(step.getResults(), (Closure)new _make2DTables_closure1(this, this));
    }

    private Object makePlots() {
        Routine.write("generating R plots...");
        Futils.mkdirs(this.getPlotsDir());
        if (this.listParams.size() == 1) {
            return this.make1DPlots();
        }
        if (this.listParams.size() == 2) {
            return this.make2DPlots();
        }
        return null;
    }

    private int getRThreads() {
        return Math.min(this.getParams().getThreads(), this.getParams().getR_threads());
    }

    public boolean plotVariable(String name) {
        return !name.startsWith("_stddev_");
    }

    private Object make2DPlots() {
        CallSite[] callSiteArray = GridOptimizer.$getCallSiteArray();
        public final class _make2DPlots_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _make2DPlots_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _make2DPlots_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _make2DPlots_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _make2DPlots_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _make2DPlots_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "plotVariable";
                return new CallSiteArray(_make2DPlots_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _make2DPlots_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference vars = new Reference(callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), (Object)new _make2DPlots_closure2(this, this))));
        public final class _make2DPlots_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference vars;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _make2DPlots_closure3(Object _outerInstance, Object _thisObject, Reference vars) {
                Reference reference;
                CallSite[] callSiteArray = _make2DPlots_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.vars = reference = vars;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _make2DPlots_closure3.$getCallSiteArray();
                public final class _closure8
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure8(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(String key) {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        String value = ShortTypeHandling.castToString((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)key));
                        String label = key;
                        String fname = ShortTypeHandling.castToString((Object)callSiteArray[2].call(Futils.class, (Object)value));
                        String labelX = ShortTypeHandling.castToString((Object)callSiteArray[3].callGetProperty(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)1)));
                        String labelY = ShortTypeHandling.castToString((Object)callSiteArray[6].callGetProperty(callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)0)));
                        return callSiteArray[9].call(callSiteArray[10].callConstructor(RPlotter.class, callSiteArray[11].callGroovyObjectGetProperty((Object)this)), (Object)fname, (Object)label, (Object)labelX, (Object)labelY);
                    }

                    public Object call(String key) {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[12].callCurrent((GroovyObject)this, (Object)key);
                        }
                        return this.doCall(key);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "get";
                        stringArray[1] = "tables2D";
                        stringArray[2] = "absSafePath";
                        stringArray[3] = "name";
                        stringArray[4] = "getAt";
                        stringArray[5] = "listParams";
                        stringArray[6] = "name";
                        stringArray[7] = "getAt";
                        stringArray[8] = "listParams";
                        stringArray[9] = "plotHeatMapTable";
                        stringArray[10] = "<$constructor$>";
                        stringArray[11] = "plotsDir";
                        stringArray[12] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[13];
                        _closure8.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure8.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure8.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(this.vars.get(), (Object)new _closure8((Object)this, this.getThisObject()));
            }

            public Object getVars() {
                CallSite[] callSiteArray = _make2DPlots_closure3.$getCallSiteArray();
                return this.vars.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _make2DPlots_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _make2DPlots_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "eachParallel";
                return new CallSiteArray(_make2DPlots_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _make2DPlots_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[4].call(GParsPool.class, callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)new _make2DPlots_closure3(this, this, vars));
    }

    private Object make1DPlots() {
        RPlotter plotter = new RPlotter(this.getStatsTableFile(), this.getPlotsDir());
        public final class _make1DPlots_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _make1DPlots_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((GridOptimizer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GridOptimizer.class)).plotVariable(ShortTypeHandling.castToString((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _make1DPlots_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List vars = DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(plotter.getHeader(), (Closure)new _make1DPlots_closure4(this, this)));
        plotter.plot1DVariables(vars, this.getRThreads());
        return null;
    }

    private Object make2DTable(String statName) {
        ListParam paramX = (ListParam)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.listParams, (int)0), ListParam.class);
        ListParam paramY = (ListParam)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.listParams, (int)1), ListParam.class);
        Reference valueMap = new Reference(new HashMap());
        ParamLooper.Step s = null;
        Iterator<ParamLooper.Step> iterator = this.getSteps().iterator();
        while (iterator.hasNext()) {
            s = (ParamLooper.Step)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ParamLooper.Step.class);
            List key = ScriptBytecodeAdapter.createList((Object[])new Object[]{((ParamLooper.ParamVal)DefaultGroovyMethods.getAt(s.getParams(), (int)0)).getValue(), ((ParamLooper.ParamVal)DefaultGroovyMethods.getAt(s.getParams(), (int)1)).getValue()});
            ((HashMap)valueMap.get()).put(key, s.getResults().get(statName));
        }
        StringBuilder sb = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)sb, (Object)"# resName \n");
        public final class _make2DTable_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _make2DTable_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _make2DTable_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        StringGroovyMethods.leftShift((StringBuilder)sb, (Object)new GStringImpl(new Object[]{paramX.getName(), paramY.getName()}, new String[]{"", "/", ","}).plus(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)paramY.getValues(), (Closure)new _make2DTable_closure5(this, this)), (String)",")).plus("\n"));
        Reference va = new Reference(null);
        Iterator iterator2 = paramX.getValues().iterator();
        while (iterator2.hasNext()) {
            va.set(iterator2.next());
            public final class _make2DTable_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference valueMap;
                private /* synthetic */ Reference va;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _make2DTable_closure6(Object _outerInstance, Object _thisObject, Reference valueMap, Reference va) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.valueMap = reference2 = valueMap;
                    this.va = reference = va;
                }

                public Object doCall(Object vb) {
                    return ((HashMap)this.valueMap.get()).get(ScriptBytecodeAdapter.createList((Object[])new Object[]{this.va.get(), vb}));
                }

                public Map getValueMap() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.valueMap.get(), Map.class);
                }

                public Object getVa() {
                    return this.va.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _make2DTable_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _make2DTable_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _make2DTable_closure7(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ParamLooper.fmt(it);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _make2DTable_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            String row = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.collect((Iterable)paramY.getValues(), (Closure)new _make2DTable_closure6(this, this, valueMap, va)), (Closure)new _make2DTable_closure7(this, this)), (String)",");
            StringGroovyMethods.leftShift((StringBuilder)sb, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"", (Object)va.get()), (CharSequence)","), (CharSequence)row), (CharSequence)"\n"));
        }
        String fname = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTablesDir(), statName}, new String[]{"", "/", ".csv"}));
        this.getTables2D().put(statName, fname);
        Futils.writeFile(fname, sb.toString());
        return null;
    }

    private List<ParamLooper.Step> generateSteps(List<ListParam> lparams) {
        return this.genStepsRecur(new ArrayList<ParamLooper.Step>(), new ParamLooper.Step(), lparams);
    }

    private List<ParamLooper.Step> genStepsRecur(List<ParamLooper.Step> steps, ParamLooper.Step base, List<ListParam> rparams) {
        if (rparams.isEmpty()) {
            steps.add(base);
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        ListParam rparam = (ListParam)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.head(rparams), ListParam.class);
        Object val2 = null;
        for (Object val2 : rparam.getValues()) {
            ParamLooper.Step deeperStep = base.extendWith(rparam.getName(), val2);
            this.genStepsRecur(steps, deeperStep, DefaultGroovyMethods.tail(rparams));
        }
        return steps;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GridOptimizer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.GridOptimizer");
    }

    @Generated
    public List<ListParam> getListParams() {
        return this.listParams;
    }

    @Generated
    public void setListParams(List<ListParam> list) {
        this.listParams = list;
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "asList";
        stringArray[1] = "findAll";
        stringArray[2] = "keySet";
        stringArray[3] = "tables2D";
        stringArray[4] = "withPool";
        stringArray[5] = "RThreads";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[6];
        GridOptimizer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GridOptimizer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GridOptimizer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

