/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.program.routines.results.EvalResults;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Futils;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EvalRoutine
extends Routine {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public EvalRoutine(String outdir) {
        super(outdir);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public abstract EvalResults execute();

    public String toMainResultsCsv(String label, String model, EvalResults results) {
        String string;
        int proteins = results.getEval().getProteinCount();
        int ligands = results.getEval().getLigandCount();
        int pockets = results.getEval().getPocketCount();
        double top1 = results.getOrigEval().calcDefaultCriteriumSuccessRate(0);
        double all = results.getOrigEval().calcDefaultCriteriumSuccessRate(999);
        double rescored = results.getEval().calcDefaultCriteriumSuccessRate(0);
        double orig_DCA4_0 = results.getOrigEval().calcDefaultCriteriumSuccessRate(0);
        double orig_DCA4_2 = results.getOrigEval().calcDefaultCriteriumSuccessRate(2);
        double DCA4_0 = results.getEval().calcDefaultCriteriumSuccessRate(0);
        double DCA4_2 = results.getEval().calcDefaultCriteriumSuccessRate(2);
        double diff = rescored - top1;
        double possible = all - top1;
        double pcPossible = diff / possible;
        double P = results.getClassifierStats().getMetrics().getP();
        double R = results.getClassifierStats().getMetrics().getR();
        double FM = results.getClassifierStats().getMetrics().getF1();
        double MCC = results.getClassifierStats().getMetrics().getMCC();
        double ligSize = results.getEval().getAvgLigandAtoms();
        double pocketVol = results.getEval().getAvgPocketVolume();
        double pocketSurf = results.getEval().getAvgPocketSurfAtoms();
        String dir = Futils.shortName(this.getOutdir());
        String s = "dir,dataset,model,#proteins,#ligands,#pockets,orig_DCA4_0,orig_DCA4_2,DCA4_0,DCA4_2,top1,all,rescored,diff,%possible,possible,P,R,FM,MCC,avgLigSize,avgPocketVol,avgPocketSurfAtoms\n";
        s = string = StringGroovyMethods.plus((String)s, (CharSequence)new GStringImpl(new Object[]{dir, label, model, proteins, ligands, pockets}, new String[]{"", ",", ",", ",", ",", ",", ","}).plus((GString)new GStringImpl(new Object[]{Formatter.pc(orig_DCA4_0), Formatter.pc(orig_DCA4_2), Formatter.pc(DCA4_0), Formatter.pc(DCA4_2)}, new String[]{"", ",", ",", ",", ","})).plus((GString)new GStringImpl(new Object[]{Formatter.pc(top1), Formatter.pc(all), Formatter.pc(rescored), Formatter.pc(diff), Formatter.pc(pcPossible), Formatter.pc(possible)}, new String[]{"", ",", ",", ",", ",", ",", ","})).plus((GString)new GStringImpl(new Object[]{Formatter.fmt(P), Formatter.fmt(R), Formatter.fmt(FM), Formatter.fmt(MCC), Formatter.fmt(ligSize), Formatter.fmt(pocketVol), Formatter.fmt(pocketSurf)}, new String[]{"", ",", ",", ",", ",", ",", ",", "\n"})));
        return s;
    }

    public void logSummaryResults(String label, String model, EvalResults results) {
        String mainRes = this.toMainResultsCsv(label, model, results);
        Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getOutdir()}, new String[]{"", "/summary.csv"})), mainRes);
    }

    public String getEvalRoutineOutdir() {
        return this.getOutdir();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EvalRoutine.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.routines.EvalRoutine");
    }
}

