/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.routines;

import com.google.common.collect.ImmutableMap;
import cz.siret.prank.domain.AA;
import cz.siret.prank.domain.Dataset;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.ResidueChain;
import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.BinaryLabelings;
import cz.siret.prank.domain.labeling.LabeledResidue;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.domain.labeling.SprintLabelingLoader;
import cz.siret.prank.domain.loaders.DatasetCachedLoader;
import cz.siret.prank.domain.loaders.LoaderParams;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.SecondaryStructureUtils;
import cz.siret.prank.program.Main;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.rendering.PymolRenderer;
import cz.siret.prank.program.rendering.RenderingModel;
import cz.siret.prank.program.routines.Routine;
import cz.siret.prank.utils.BinCounter;
import cz.siret.prank.utils.CmdLineArgs;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeRoutine
extends Routine {
    private String subCommand;
    private String label;
    private String datasetFile;
    private Dataset dataset;
    private Map<String, Closure> commandRegister;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AnalyzeRoutine(CmdLineArgs args, Main main) {
        MetaClass metaClass;
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        super(null);
        Object object = callSiteArray[0].call(ImmutableMap.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"binding-residues", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdBindingResidues"), "labeled-residues", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdLabeledResidues"), "aa-propensities", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdAaPropensities"), "aa-surf-seq-duplets", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdAaSurfSeqDuplets"), "aa-surf-seq-triplets", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdAaSurfSeqTriplets"), "conservation", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdConservation"), "chains", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdChains"), "peptides", ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"cmdPeptides")}));
        this.commandRegister = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object2 = callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)args), (Object)0);
        this.subCommand = ShortTypeHandling.castToString((Object)object2);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(this.commandRegister, (Object)this.subCommand))) {
            callSiteArray[4].callCurrent((GroovyObject)this, callSiteArray[5].call((Object)new GStringImpl(new Object[]{this.subCommand}, new String[]{"Invalid analyze command '", "'! Available commands: "}), callSiteArray[6].call(this.commandRegister)));
            throw (Throwable)callSiteArray[7].callConstructor(PrankException.class, (Object)"Invalid command.");
        }
        String datasetParam = ShortTypeHandling.castToString((Object)callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)args), (Object)1));
        Object object3 = callSiteArray[10].call(Main.class, (Object)datasetParam);
        this.datasetFile = ShortTypeHandling.castToString((Object)object3);
        Object object4 = callSiteArray[11].call(DatasetCachedLoader.class, (Object)this.datasetFile);
        this.dataset = (Dataset)ScriptBytecodeAdapter.castToType((Object)object4, Dataset.class);
        Object object5 = callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call((Object)"analyze_", (Object)this.subCommand), (Object)"_"), callSiteArray[15].callGroovyObjectGetProperty((Object)this.dataset));
        this.label = ShortTypeHandling.castToString((Object)object5);
        Object object6 = callSiteArray[16].call((Object)main, (Object)this.label);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)object6), AnalyzeRoutine.class, (GroovyObject)this, (String)"outdir");
    }

    public void execute() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        callSiteArray[17].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.subCommand}, new String[]{"executing analyze ", " command"}));
        callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].callGroovyObjectGetProperty((Object)this));
        callSiteArray[20].call(callSiteArray[21].call(this.commandRegister, (Object)this.subCommand));
        callSiteArray[22].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{callSiteArray[23].call(Futils.class, callSiteArray[24].callGroovyObjectGetProperty((Object)this))}, new String[]{"results saved to directory [", "]"}));
    }

    public void cmdBindingResidues() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        Reference residueCutoff = new Reference((Object)((Double)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callGetProperty(callSiteArray[26].callGroovyObjectGetProperty((Object)this)), Double.class)));
        Reference summary = new Reference((Object)((StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callConstructor(StringBuffer.class), StringBuffer.class)));
        public final class _cmdBindingResidues_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference residueCutoff;
            private /* synthetic */ Reference summary;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdBindingResidues_closure1(Object _outerInstance, Object _thisObject, Reference residueCutoff, Reference summary) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _cmdBindingResidues_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.residueCutoff = reference2 = residueCutoff;
                this.summary = reference = summary;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdBindingResidues_closure1.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                Atoms bindingAtoms = (Atoms)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)p), callSiteArray[3].callGroovyObjectGetProperty((Object)p), this.residueCutoff.get()), Atoms.class);
                public final class _closure11
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure11(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "seqNum";
                        stringArray[1] = "residueNumber";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure11.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure11.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure11.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                List bindingResidueIds = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callGetProperty((Object)bindingAtoms), (Object)new _closure11((Object)this, this.getThisObject())))), List.class);
                String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)p), callSiteArray[9].callGroovyObjectGetProperty((Object)p), callSiteArray[10].callGetProperty((Object)bindingAtoms), callSiteArray[11].call((Object)bindingResidueIds)}, new String[]{"Protein [", "]  ligands: ", "  bindingAtoms: ", "  bindingResidues: ", ""}));
                callSiteArray[12].call(callSiteArray[13].callGetProperty(AnalyzeRoutine.class), (Object)msg);
                callSiteArray[14].call(this.summary.get(), callSiteArray[15].call((Object)msg, (Object)"\n"));
                String outf = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[16].callGroovyObjectGetProperty((Object)this), callSiteArray[17].callGroovyObjectGetProperty((Object)p)}, new String[]{"", "/", "_binding-residues.txt"}));
                return callSiteArray[18].callStatic(Futils.class, (Object)outf, callSiteArray[19].call((Object)bindingResidueIds, (Object)"\n"));
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdBindingResidues_closure1.$getCallSiteArray();
                return callSiteArray[20].callCurrent((GroovyObject)this, (Object)item);
            }

            public Double getResidueCutoff() {
                CallSite[] callSiteArray = _cmdBindingResidues_closure1.$getCallSiteArray();
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.residueCutoff.get(), Double.class);
            }

            public StringBuffer getSummary() {
                CallSite[] callSiteArray = _cmdBindingResidues_closure1.$getCallSiteArray();
                return (StringBuffer)ScriptBytecodeAdapter.castToType((Object)this.summary.get(), StringBuffer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdBindingResidues_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "cutoutShell";
                stringArray[2] = "proteinAtoms";
                stringArray[3] = "allLigandAtoms";
                stringArray[4] = "toSorted";
                stringArray[5] = "toSet";
                stringArray[6] = "collect";
                stringArray[7] = "distinctGroupsSorted";
                stringArray[8] = "name";
                stringArray[9] = "ligandCount";
                stringArray[10] = "count";
                stringArray[11] = "size";
                stringArray[12] = "info";
                stringArray[13] = "log";
                stringArray[14] = "leftShift";
                stringArray[15] = "plus";
                stringArray[16] = "outdir";
                stringArray[17] = "name";
                stringArray[18] = "writeFile";
                stringArray[19] = "join";
                stringArray[20] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[21];
                _cmdBindingResidues_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdBindingResidues_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdBindingResidues_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[28].call((Object)this.dataset, (Object)new _cmdBindingResidues_closure1(this, this, residueCutoff, summary));
        callSiteArray[29].callCurrent((GroovyObject)this, callSiteArray[30].call((Object)"\n", callSiteArray[31].call((Object)((StringBuffer)summary.get()))));
    }

    public void cmdPeptides() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference csv = new Reference((Object)((StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callConstructor(StringBuffer.class, (Object)"protein, pept_count, peptides\n"), StringBuffer.class)));
        public final class _cmdPeptides_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference csv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdPeptides_closure2(Object _outerInstance, Object _thisObject, Reference csv) {
                Reference reference;
                CallSite[] callSiteArray = _cmdPeptides_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.csv = reference = csv;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdPeptides_closure2.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure12(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        return new GStringImpl(new Object[]{callSiteArray[0].callGetProperty(it), callSiteArray[1].callGetProperty(it)}, new String[]{"(", ",", ")"});
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "id";
                        stringArray[1] = "length";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure12.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure12.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure12.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                String ps = ShortTypeHandling.castToString((Object)callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)p), (Object)new _closure12((Object)this, this.getThisObject())), (Object)" "));
                return callSiteArray[4].call(this.csv.get(), (Object)new GStringImpl(new Object[]{callSiteArray[5].callGroovyObjectGetProperty((Object)p), callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)p)), ps}, new String[]{"", ", ", ", ", "\n"}));
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdPeptides_closure2.$getCallSiteArray();
                return callSiteArray[8].callCurrent((GroovyObject)this, (Object)item);
            }

            public StringBuffer getCsv() {
                CallSite[] callSiteArray = _cmdPeptides_closure2.$getCallSiteArray();
                return (StringBuffer)ScriptBytecodeAdapter.castToType((Object)this.csv.get(), StringBuffer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdPeptides_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "join";
                stringArray[2] = "collect";
                stringArray[3] = "peptides";
                stringArray[4] = "leftShift";
                stringArray[5] = "name";
                stringArray[6] = "size";
                stringArray[7] = "peptides";
                stringArray[8] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _cmdPeptides_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdPeptides_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdPeptides_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[33].call((Object)this.dataset, (Object)new _cmdPeptides_closure2(this, this, csv));
        callSiteArray[34].callStatic(Futils.class, (Object)new GStringImpl(new Object[]{callSiteArray[35].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/peptides.csv"}), (Object)((StringBuffer)csv.get()));
        callSiteArray[36].callCurrent((GroovyObject)this, callSiteArray[37].call((Object)((StringBuffer)csv.get())));
    }

    public void cmdChains() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference csv = new Reference((Object)((StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callConstructor(StringBuffer.class, (Object)"protein, n_chains, chain_id, n_residues, residue_string\n"), StringBuffer.class)));
        public final class _cmdChains_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference csv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdChains_closure3(Object _outerInstance, Object _thisObject, Reference csv) {
                Reference reference;
                CallSite[] callSiteArray = _cmdChains_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.csv = reference = csv;
            }

            public Object doCall(Dataset.Item item) {
                Reference item2 = new Reference((Object)item);
                CallSite[] callSiteArray = _cmdChains_closure3.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)((Dataset.Item)item2.get())), Protein.class);
                Reference nchains = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)p)), Integer.class)));
                Reference rows = new Reference((Object)"");
                public final class _closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference rows;
                    private /* synthetic */ Reference item;
                    private /* synthetic */ Reference nchains;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure13(Object _outerInstance, Object _thisObject, Reference rows, Reference item, Reference nchains) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.rows = reference3 = rows;
                        this.item = reference2 = item;
                        this.nchains = reference = nchains;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        String chainId = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(it));
                        int nres = DefaultTypeTransformation.intUnbox((Object)callSiteArray[1].callGetProperty(it));
                        String chars = ShortTypeHandling.castToString((Object)callSiteArray[2].callGetProperty(it));
                        Object object = callSiteArray[3].call(this.rows.get(), (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty(this.item.get()), this.nchains.get(), chainId, nres, chars}, new String[]{"", ", ", ", ", ", ", ", ", " \n"}));
                        this.rows.set((Object)ShortTypeHandling.castToString((Object)object));
                        return object;
                    }

                    public String getRows() {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.rows.get());
                    }

                    public Dataset.Item getItem() {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        return (Dataset.Item)ScriptBytecodeAdapter.castToType((Object)this.item.get(), Dataset.Item.class);
                    }

                    public Integer getNchains() {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        return (Integer)ScriptBytecodeAdapter.castToType((Object)this.nchains.get(), Integer.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "id";
                        stringArray[1] = "length";
                        stringArray[2] = "codeCharString";
                        stringArray[3] = "plus";
                        stringArray[4] = "label";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure13.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure13.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure13.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)p), (Object)new _closure13((Object)this, this.getThisObject(), rows, item2, nchains));
                return callSiteArray[5].call(this.csv.get(), (Object)((String)rows.get()));
            }

            public Object call(Dataset.Item item) {
                Reference item2 = new Reference((Object)item);
                CallSite[] callSiteArray = _cmdChains_closure3.$getCallSiteArray();
                return callSiteArray[6].callCurrent((GroovyObject)this, (Object)((Dataset.Item)item2.get()));
            }

            public StringBuffer getCsv() {
                CallSite[] callSiteArray = _cmdChains_closure3.$getCallSiteArray();
                return (StringBuffer)ScriptBytecodeAdapter.castToType((Object)this.csv.get(), StringBuffer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdChains_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "size";
                stringArray[2] = "residueChains";
                stringArray[3] = "each";
                stringArray[4] = "residueChains";
                stringArray[5] = "leftShift";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _cmdChains_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdChains_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdChains_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[39].call((Object)this.dataset, (Object)new _cmdChains_closure3(this, this, csv));
        callSiteArray[40].callStatic(Futils.class, (Object)new GStringImpl(new Object[]{callSiteArray[41].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/chains.csv"}), (Object)((StringBuffer)csv.get()));
    }

    public void cmdLabeledResidues() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[42];
            Dataset dataset = this.dataset;
            valueRecorder.record((Object)dataset, 8);
            valueRecorder.record((Object)dataset, 8);
            Object object = callSite.call((Object)dataset);
            valueRecorder.record(object, 16);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert dataset.hasResidueLabeling()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference labeler = new Reference(callSiteArray[43].callGroovyObjectGetProperty((Object)this.dataset));
        Reference csv = new Reference((Object)((StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].callConstructor(StringBuffer.class, (Object)"protein, n_chains, chain_ids, n_residues, n_residues_in_labeling, positives, negatives, unlabeled\n"), StringBuffer.class)));
        if (labeler.get() instanceof SprintLabelingLoader) {
            callSiteArray[45].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)((SprintLabelingLoader)ScriptBytecodeAdapter.castToType((Object)labeler.get(), SprintLabelingLoader.class)), SprintLabelingLoader.class));
        }
        public final class _cmdLabeledResidues_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labeler;
            private /* synthetic */ Reference csv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdLabeledResidues_closure4(Object _outerInstance, Object _thisObject, Reference labeler, Reference csv) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _cmdLabeledResidues_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.labeler = reference2 = labeler;
                this.csv = reference = csv;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdLabeledResidues_closure4.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                BinaryLabeling labeling = (BinaryLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.labeler.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)p), (Object)p), BinaryLabeling.class);
                Object s = callSiteArray[3].call(BinaryLabelings.class, (Object)labeling);
                int nchains = DefaultTypeTransformation.intUnbox((Object)callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)p)));
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure14(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        return callSiteArray[0].callGetProperty(it);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "id";
                        return new CallSiteArray(_closure14.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure14.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                String chainIds = ShortTypeHandling.castToString((Object)callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)p), (Object)new _closure14((Object)this, this.getThisObject())), (Object)" "));
                int nres = DefaultTypeTransformation.intUnbox((Object)callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)p)));
                int nlabres = DefaultTypeTransformation.intUnbox((Object)callSiteArray[11].callGetProperty(s));
                callSiteArray[12].call(this.csv.get(), (Object)new GStringImpl(new Object[]{callSiteArray[13].callGroovyObjectGetProperty((Object)item), nchains, chainIds, nres, nlabres, callSiteArray[14].callGetProperty(s), callSiteArray[15].callGetProperty(s), callSiteArray[16].callGetProperty(s)}, new String[]{"", ", ", ", ", ", ", ", ", ", ", ", ", ", ", "\n"}));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty(callSiteArray[18].callGroovyObjectGetProperty((Object)this)))) {
                    return callSiteArray[19].call(callSiteArray[20].callConstructor(PymolRenderer.class, (Object)new GStringImpl(new Object[]{callSiteArray[21].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/visualizations"}), callSiteArray[22].callConstructor(RenderingModel.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"proteinFile", callSiteArray[23].callGroovyObjectGetProperty((Object)item), "label", callSiteArray[24].callGroovyObjectGetProperty((Object)item), "protein", callSiteArray[25].callGroovyObjectGetProperty((Object)item), "observedLabeling", labeling}))));
                }
                return null;
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdLabeledResidues_closure4.$getCallSiteArray();
                return callSiteArray[26].callCurrent((GroovyObject)this, (Object)item);
            }

            public Object getLabeler() {
                CallSite[] callSiteArray = _cmdLabeledResidues_closure4.$getCallSiteArray();
                return this.labeler.get();
            }

            public StringBuffer getCsv() {
                CallSite[] callSiteArray = _cmdLabeledResidues_closure4.$getCallSiteArray();
                return (StringBuffer)ScriptBytecodeAdapter.castToType((Object)this.csv.get(), StringBuffer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdLabeledResidues_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "getBinaryLabeling";
                stringArray[2] = "residues";
                stringArray[3] = "getStats";
                stringArray[4] = "size";
                stringArray[5] = "residueChains";
                stringArray[6] = "join";
                stringArray[7] = "collect";
                stringArray[8] = "residueChains";
                stringArray[9] = "size";
                stringArray[10] = "residues";
                stringArray[11] = "total";
                stringArray[12] = "leftShift";
                stringArray[13] = "label";
                stringArray[14] = "positives";
                stringArray[15] = "negatives";
                stringArray[16] = "unlabeled";
                stringArray[17] = "visualizations";
                stringArray[18] = "params";
                stringArray[19] = "render";
                stringArray[20] = "<$constructor$>";
                stringArray[21] = "outdir";
                stringArray[22] = "<$constructor$>";
                stringArray[23] = "proteinFile";
                stringArray[24] = "label";
                stringArray[25] = "protein";
                stringArray[26] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[27];
                _cmdLabeledResidues_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdLabeledResidues_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdLabeledResidues_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[46].call((Object)this.dataset, (Object)new _cmdLabeledResidues_closure4(this, this, labeler, csv));
        callSiteArray[47].callStatic(Futils.class, (Object)new GStringImpl(new Object[]{callSiteArray[48].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/residue_stats.csv"}), (Object)((StringBuffer)csv.get()));
    }

    public void cmdConservation() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        public final class _cmdConservation_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdConservation_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _cmdConservation_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdConservation_closure5.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                ResidueLabeling labeling = (ResidueLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call((Object)p), ResidueLabeling.class);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)labeling, null)) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(AnalyzeRoutine.class)))) {
                        public final class _closure15
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure15(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this))) ? callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"conserv. for residue {}: {}", callSiteArray[4].callGetProperty(it), callSiteArray[5].callGetProperty(it)) : null;
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure15.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "isDebugEnabled";
                                stringArray[1] = "log";
                                stringArray[2] = "debug";
                                stringArray[3] = "log";
                                stringArray[4] = "residue";
                                stringArray[5] = "label";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[6];
                                _closure15.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure15.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure15.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)labeling), (Object)new _closure15((Object)this, this.getThisObject()));
                        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(AnalyzeRoutine.class))) ? callSiteArray[8].call(callSiteArray[9].callGetProperty(AnalyzeRoutine.class), callSiteArray[10].call((Object)"score map:", callSiteArray[11].call(callSiteArray[12].call((Object)p)))) : null;
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty((Object)this)))) {
                        return callSiteArray[15].call(callSiteArray[16].callConstructor(PymolRenderer.class, (Object)new GStringImpl(new Object[]{callSiteArray[17].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/visualizations"}), callSiteArray[18].callConstructor(RenderingModel.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"proteinFile", callSiteArray[19].callGroovyObjectGetProperty((Object)item), "label", callSiteArray[20].callGroovyObjectGetProperty((Object)item), "protein", callSiteArray[21].callGroovyObjectGetProperty((Object)item), "doubleLabeling", labeling}))));
                    }
                    return null;
                }
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call(callSiteArray[23].callGetProperty(AnalyzeRoutine.class))) ? callSiteArray[24].call(callSiteArray[25].callGetProperty(AnalyzeRoutine.class), (Object)"Failed to load score for [{}]", callSiteArray[26].callGroovyObjectGetProperty((Object)item)) : null;
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdConservation_closure5.$getCallSiteArray();
                return callSiteArray[27].callCurrent((GroovyObject)this, (Object)item);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdConservation_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "getConservationLabeling";
                stringArray[2] = "isDebugEnabled";
                stringArray[3] = "log";
                stringArray[4] = "each";
                stringArray[5] = "labeledResidues";
                stringArray[6] = "isDebugEnabled";
                stringArray[7] = "log";
                stringArray[8] = "debug";
                stringArray[9] = "log";
                stringArray[10] = "plus";
                stringArray[11] = "getScoreMap";
                stringArray[12] = "getConservationScore";
                stringArray[13] = "visualizations";
                stringArray[14] = "params";
                stringArray[15] = "render";
                stringArray[16] = "<$constructor$>";
                stringArray[17] = "outdir";
                stringArray[18] = "<$constructor$>";
                stringArray[19] = "proteinFile";
                stringArray[20] = "label";
                stringArray[21] = "protein";
                stringArray[22] = "isErrorEnabled";
                stringArray[23] = "log";
                stringArray[24] = "error";
                stringArray[25] = "log";
                stringArray[26] = "label";
                stringArray[27] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[28];
                _cmdConservation_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdConservation_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdConservation_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[49].call((Object)this.dataset, (Object)new _cmdConservation_closure5(this, this));
    }

    private void printSprintChains(SprintLabelingLoader loader) {
        Reference loader2 = new Reference((Object)loader);
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        Reference csv = new Reference((Object)((StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callConstructor(StringBuffer.class, (Object)"chain_code, source, length, residue_string\n"), StringBuffer.class)));
        public final class _printSprintChains_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loader;
            private /* synthetic */ Reference csv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _printSprintChains_closure6(Object _outerInstance, Object _thisObject, Reference loader, Reference csv) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _printSprintChains_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.loader = reference2 = loader;
                this.csv = reference = csv;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _printSprintChains_closure6.$getCallSiteArray();
                Protein p = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                callSiteArray[1].callStatic(SecondaryStructureUtils.class, callSiteArray[2].callGroovyObjectGetProperty((Object)p));
                ResidueChain chain = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)p)), Iterator.class);
                while (iterator.hasNext()) {
                    chain = (ResidueChain)ScriptBytecodeAdapter.castToType(iterator.next(), ResidueChain.class);
                    String chainCode = ShortTypeHandling.castToString((Object)callSiteArray[5].call(this.loader.get(), (Object)p, (Object)chain));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty(this.loader.get()), (Object)chainCode))) {
                        callSiteArray[8].call(callSiteArray[9].callGetProperty(AnalyzeRoutine.class), (Object)"writing sprint chain [{}]", (Object)chainCode);
                        Object strStruct = callSiteArray[10].callGroovyObjectGetProperty((Object)chain);
                        Object strLabeler = callSiteArray[11].callGetProperty(callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty(this.loader.get()), (Object)chainCode));
                        Object strLabels = callSiteArray[14].callGetProperty(callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty(this.loader.get()), (Object)chainCode));
                        Object secStruct = callSiteArray[17].callGroovyObjectGetProperty((Object)chain);
                        String status = "OK";
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[18].call(strStruct), (Object)callSiteArray[19].call(strLabeler))) {
                            String string;
                            status = string = "!:LEN";
                        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)strStruct, (Object)strLabeler)) {
                            String string;
                            status = string = "!:RES";
                        }
                        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(StringBuilder.class), StringBuilder.class);
                        callSiteArray[21].call((Object)sb, callSiteArray[22].call(String.class, ArrayUtil.createArray((Object)"%s, structure, %-6s, %6s, %s \n", (Object)chainCode, (Object)status, (Object)callSiteArray[23].call(strStruct), (Object)strStruct)));
                        callSiteArray[24].call((Object)sb, callSiteArray[25].call(String.class, ArrayUtil.createArray((Object)"%s,   labeler, %-6s, %6s, %s \n", (Object)chainCode, (Object)status, (Object)callSiteArray[26].call(strLabeler), (Object)strLabeler)));
                        callSiteArray[27].call((Object)sb, callSiteArray[28].call(String.class, ArrayUtil.createArray((Object)"%s,    labels, %-6s, %6s, %s \n", (Object)chainCode, (Object)status, (Object)callSiteArray[29].call(strLabels), (Object)strLabels)));
                        callSiteArray[30].call((Object)sb, callSiteArray[31].call(String.class, ArrayUtil.createArray((Object)"%s, sec.struc, %-6s, %6s, %s \n", (Object)chainCode, (Object)status, (Object)callSiteArray[32].call(secStruct), (Object)secStruct)));
                        callSiteArray[33].call(this.csv.get(), callSiteArray[34].call((Object)sb));
                        continue;
                    }
                    callSiteArray[35].call(callSiteArray[36].callGetProperty(AnalyzeRoutine.class), (Object)"labeling for chain [{}] not found", (Object)chainCode);
                }
                return null;
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _printSprintChains_closure6.$getCallSiteArray();
                return callSiteArray[37].callCurrent((GroovyObject)this, (Object)item);
            }

            public SprintLabelingLoader getLoader() {
                CallSite[] callSiteArray = _printSprintChains_closure6.$getCallSiteArray();
                return (SprintLabelingLoader)ScriptBytecodeAdapter.castToType((Object)this.loader.get(), SprintLabelingLoader.class);
            }

            public StringBuffer getCsv() {
                CallSite[] callSiteArray = _printSprintChains_closure6.$getCallSiteArray();
                return (StringBuffer)ScriptBytecodeAdapter.castToType((Object)this.csv.get(), StringBuffer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _printSprintChains_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "assignSecondaryStructure";
                stringArray[2] = "structure";
                stringArray[3] = "iterator";
                stringArray[4] = "residueChains";
                stringArray[5] = "toElementCode";
                stringArray[6] = "containsKey";
                stringArray[7] = "elementsByCode";
                stringArray[8] = "info";
                stringArray[9] = "log";
                stringArray[10] = "codeCharString";
                stringArray[11] = "chain";
                stringArray[12] = "get";
                stringArray[13] = "elementsByCode";
                stringArray[14] = "labels";
                stringArray[15] = "get";
                stringArray[16] = "elementsByCode";
                stringArray[17] = "secStructString";
                stringArray[18] = "length";
                stringArray[19] = "length";
                stringArray[20] = "<$constructor$>";
                stringArray[21] = "leftShift";
                stringArray[22] = "format";
                stringArray[23] = "length";
                stringArray[24] = "leftShift";
                stringArray[25] = "format";
                stringArray[26] = "length";
                stringArray[27] = "leftShift";
                stringArray[28] = "format";
                stringArray[29] = "length";
                stringArray[30] = "leftShift";
                stringArray[31] = "format";
                stringArray[32] = "length";
                stringArray[33] = "leftShift";
                stringArray[34] = "toString";
                stringArray[35] = "warn";
                stringArray[36] = "log";
                stringArray[37] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[38];
                _printSprintChains_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_printSprintChains_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _printSprintChains_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[51].call((Object)this.dataset, (Object)new _printSprintChains_closure6(this, this, loader2, csv));
        callSiteArray[52].callStatic(Futils.class, (Object)new GStringImpl(new Object[]{callSiteArray[53].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/sprint_chains.csv"}), (Object)((StringBuffer)csv.get()));
    }

    private void cmdAaPropensities() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[54];
            Dataset dataset = this.dataset;
            valueRecorder.record((Object)dataset, 8);
            valueRecorder.record((Object)dataset, 8);
            Object object = callSite.call((Object)dataset);
            valueRecorder.record(object, 16);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert dataset.hasResidueLabeling()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference labeler = new Reference(callSiteArray[55].callGroovyObjectGetProperty((Object)this.dataset));
        Reference counters = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call(Collections.class, callSiteArray[57].callConstructor(ArrayList.class)), List.class)));
        public final class _cmdAaPropensities_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labeler;
            private /* synthetic */ Reference counters;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdAaPropensities_closure7(Object _outerInstance, Object _thisObject, Reference labeler, Reference counters) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _cmdAaPropensities_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.labeler = reference2 = labeler;
                this.counters = reference = counters;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaPropensities_closure7.$getCallSiteArray();
                Protein prot = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                BinaryLabeling labeling = (BinaryLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.labeler.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)prot), (Object)prot), BinaryLabeling.class);
                Reference counter = new Reference(callSiteArray[3].callConstructor(BinCounter.class));
                public final class _closure16
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference counter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure16(Object _outerInstance, Object _thisObject, Reference counter) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.counter = reference = counter;
                    }

                    public Object doCall(LabeledResidue<Boolean> lres) {
                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                        AA aa = (AA)ShortTypeHandling.castToEnum((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty(lres)), AA.class);
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)aa), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[2].callGroovyObjectGetProperty(lres), null)) {
                                return callSiteArray[3].call(this.counter.get(), (Object)aa, callSiteArray[4].callGroovyObjectGetProperty(lres));
                            }
                            return null;
                        }
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)aa), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[5].callGroovyObjectGetProperty(lres), null)) {
                            return callSiteArray[6].call(this.counter.get(), (Object)aa, callSiteArray[7].callGroovyObjectGetProperty(lres));
                        }
                        return null;
                    }

                    public Object call(LabeledResidue<Boolean> lres) {
                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                        return callSiteArray[8].callCurrent((GroovyObject)this, lres);
                    }

                    public Object getCounter() {
                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                        return this.counter.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure16.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "aa";
                        stringArray[1] = "residue";
                        stringArray[2] = "label";
                        stringArray[3] = "add";
                        stringArray[4] = "label";
                        stringArray[5] = "label";
                        stringArray[6] = "add";
                        stringArray[7] = "label";
                        stringArray[8] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[9];
                        _closure16.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure16.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure16.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)labeling), (Object)new _closure16((Object)this, this.getThisObject(), counter));
                return callSiteArray[6].call(this.counters.get(), counter.get());
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaPropensities_closure7.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)item);
            }

            public Object getLabeler() {
                CallSite[] callSiteArray = _cmdAaPropensities_closure7.$getCallSiteArray();
                return this.labeler.get();
            }

            public List getCounters() {
                CallSite[] callSiteArray = _cmdAaPropensities_closure7.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.counters.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdAaPropensities_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "getBinaryLabeling";
                stringArray[2] = "exposedResidues";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "each";
                stringArray[5] = "labeledResidues";
                stringArray[6] = "add";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _cmdAaPropensities_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdAaPropensities_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdAaPropensities_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[58].call((Object)this.dataset, (Object)new _cmdAaPropensities_closure7(this, this, labeler, counters));
        BinCounter counter = (BinCounter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(BinCounter.class, (Object)((List)counters.get())), BinCounter.class);
        callSiteArray[60].callStatic(AnalyzeRoutine.class, (Object)new GStringImpl(new Object[]{callSiteArray[61].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/aa-propensities.csv"}), (Object)counter);
    }

    private void cmdAaSurfSeqDuplets() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[62];
            Dataset dataset = this.dataset;
            valueRecorder.record((Object)dataset, 8);
            valueRecorder.record((Object)dataset, 8);
            Object object = callSite.call((Object)dataset);
            valueRecorder.record(object, 16);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert dataset.hasResidueLabeling()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference labeler = new Reference(callSiteArray[63].callGroovyObjectGetProperty((Object)this.dataset));
        Reference counters = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(Collections.class, callSiteArray[65].callConstructor(ArrayList.class)), List.class)));
        public final class _cmdAaSurfSeqDuplets_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labeler;
            private /* synthetic */ Reference counters;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdAaSurfSeqDuplets_closure8(Object _outerInstance, Object _thisObject, Reference labeler, Reference counters) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _cmdAaSurfSeqDuplets_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.labeler = reference2 = labeler;
                this.counters = reference = counters;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaSurfSeqDuplets_closure8.$getCallSiteArray();
                Protein prot = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                BinaryLabeling labeling = (BinaryLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.labeler.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)prot), (Object)prot), BinaryLabeling.class);
                Reference counter = new Reference(callSiteArray[3].callConstructor(BinCounter.class));
                public final class _closure17
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference counter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure17(Object _outerInstance, Object _thisObject, Reference counter) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.counter = reference = counter;
                    }

                    public Object doCall(LabeledResidue<Boolean> lres) {
                        CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                        Object res = callSiteArray[0].callGroovyObjectGetProperty(lres);
                        Object prev = callSiteArray[1].callGetProperty(res);
                        Object next = callSiteArray[2].callGetProperty(res);
                        callSiteArray[3].call(this.counter.get(), callSiteArray[4].call(Residue.class, res, prev), callSiteArray[5].callGroovyObjectGetProperty(lres));
                        return callSiteArray[6].call(this.counter.get(), callSiteArray[7].call(Residue.class, res, next), callSiteArray[8].callGroovyObjectGetProperty(lres));
                    }

                    public Object call(LabeledResidue<Boolean> lres) {
                        CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                        return callSiteArray[9].callCurrent((GroovyObject)this, lres);
                    }

                    public Object getCounter() {
                        CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                        return this.counter.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure17.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "residue";
                        stringArray[1] = "previousInChain";
                        stringArray[2] = "nextInChain";
                        stringArray[3] = "add";
                        stringArray[4] = "safeOrderedCode2";
                        stringArray[5] = "label";
                        stringArray[6] = "add";
                        stringArray[7] = "safeOrderedCode2";
                        stringArray[8] = "label";
                        stringArray[9] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[10];
                        _closure17.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure17.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure17.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)labeling), (Object)new _closure17((Object)this, this.getThisObject(), counter));
                return callSiteArray[6].call(this.counters.get(), counter.get());
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaSurfSeqDuplets_closure8.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)item);
            }

            public Object getLabeler() {
                CallSite[] callSiteArray = _cmdAaSurfSeqDuplets_closure8.$getCallSiteArray();
                return this.labeler.get();
            }

            public List getCounters() {
                CallSite[] callSiteArray = _cmdAaSurfSeqDuplets_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.counters.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdAaSurfSeqDuplets_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "getBinaryLabeling";
                stringArray[2] = "exposedResidues";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "each";
                stringArray[5] = "labeledResidues";
                stringArray[6] = "add";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _cmdAaSurfSeqDuplets_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdAaSurfSeqDuplets_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdAaSurfSeqDuplets_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[66].call((Object)this.dataset, (Object)new _cmdAaSurfSeqDuplets_closure8(this, this, labeler, counters));
        callSiteArray[67].callStatic(AnalyzeRoutine.class, (Object)new GStringImpl(new Object[]{callSiteArray[68].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/aa_surf_seq_duplet_propensities.csv"}), callSiteArray[69].call(BinCounter.class, (Object)((List)counters.get())));
    }

    private void cmdAaSurfSeqTriplets() {
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[70];
            Dataset dataset = this.dataset;
            valueRecorder.record((Object)dataset, 8);
            valueRecorder.record((Object)dataset, 8);
            Object object = callSite.call((Object)dataset);
            valueRecorder.record(object, 16);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert dataset.hasResidueLabeling()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, LoaderParams.class, (String)"ignoreLigandsSwitch");
        Reference labeler = new Reference(callSiteArray[71].callGroovyObjectGetProperty((Object)this.dataset));
        Reference counters = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].call(Collections.class, callSiteArray[73].callConstructor(ArrayList.class)), List.class)));
        public final class _cmdAaSurfSeqTriplets_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labeler;
            private /* synthetic */ Reference counters;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cmdAaSurfSeqTriplets_closure9(Object _outerInstance, Object _thisObject, Reference labeler, Reference counters) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _cmdAaSurfSeqTriplets_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.labeler = reference2 = labeler;
                this.counters = reference = counters;
            }

            public Object doCall(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaSurfSeqTriplets_closure9.$getCallSiteArray();
                Protein prot = (Protein)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)item), Protein.class);
                BinaryLabeling labeling = (BinaryLabeling)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.labeler.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)prot), (Object)prot), BinaryLabeling.class);
                Reference counter = new Reference(callSiteArray[3].callConstructor(BinCounter.class));
                public final class _closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference counter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure18(Object _outerInstance, Object _thisObject, Reference counter) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.counter = reference = counter;
                    }

                    public Object doCall(Object lres) {
                        CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                        String code = ShortTypeHandling.castToString((Object)callSiteArray[0].call(Residue.class, callSiteArray[1].callGetProperty(lres)));
                        return callSiteArray[2].call(this.counter.get(), (Object)code, callSiteArray[3].callGetProperty(lres));
                    }

                    public Object getCounter() {
                        CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                        return this.counter.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "safeSorted3CodeFor";
                        stringArray[1] = "residue";
                        stringArray[2] = "add";
                        stringArray[3] = "label";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure18.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure18.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure18.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)labeling), (Object)new _closure18((Object)this, this.getThisObject(), counter));
                return callSiteArray[6].call(this.counters.get(), counter.get());
            }

            public Object call(Dataset.Item item) {
                CallSite[] callSiteArray = _cmdAaSurfSeqTriplets_closure9.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)item);
            }

            public Object getLabeler() {
                CallSite[] callSiteArray = _cmdAaSurfSeqTriplets_closure9.$getCallSiteArray();
                return this.labeler.get();
            }

            public List getCounters() {
                CallSite[] callSiteArray = _cmdAaSurfSeqTriplets_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.counters.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cmdAaSurfSeqTriplets_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protein";
                stringArray[1] = "getBinaryLabeling";
                stringArray[2] = "exposedResidues";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "each";
                stringArray[5] = "labeledResidues";
                stringArray[6] = "add";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _cmdAaSurfSeqTriplets_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cmdAaSurfSeqTriplets_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cmdAaSurfSeqTriplets_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[74].call((Object)this.dataset, (Object)new _cmdAaSurfSeqTriplets_closure9(this, this, labeler, counters));
        callSiteArray[75].callStatic(AnalyzeRoutine.class, (Object)new GStringImpl(new Object[]{callSiteArray[76].callGroovyObjectGetProperty((Object)this)}, new String[]{"", "/aa_surf_seq_triplet_propensities.csv"}), callSiteArray[77].call(BinCounter.class, (Object)((List)counters.get())));
    }

    private static void savePropensities(String fname, BinCounter counter) {
        Reference counter2 = new Reference((Object)counter);
        CallSite[] callSiteArray = AnalyzeRoutine.$getCallSiteArray();
        Reference csv = new Reference((Object)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(StringBuilder.class, (Object)"key, pos_ratio, pos_ratio^2, count, pos, neg\n"), StringBuilder.class)));
        public final class _savePropensities_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference counter;
            private /* synthetic */ Reference csv;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _savePropensities_closure10(Object _outerInstance, Object _thisObject, Reference counter, Reference csv) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _savePropensities_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.counter = reference2 = counter;
                this.csv = reference = csv;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _savePropensities_closure10.$getCallSiteArray();
                Object bin = callSiteArray[0].call(this.counter.get(), it);
                double r = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[1].callGetProperty(bin));
                if (!BytecodeInterface8.isOrigD() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].call(this.csv.get(), callSiteArray[3].call(String.class, ArrayUtil.createArray((Object)"%s, %-7s, %-7s, %8s, %8s, %8s\n", (Object)it, (Object)callSiteArray[4].callStatic(Formatter.class, (Object)r, (Object)5), (Object)callSiteArray[5].callStatic(Formatter.class, callSiteArray[6].call((Object)r, (Object)r), (Object)5), (Object)callSiteArray[7].callGetProperty(bin), (Object)callSiteArray[8].callGetProperty(bin), (Object)callSiteArray[9].callGetProperty(bin))));
                }
                return callSiteArray[10].call(this.csv.get(), callSiteArray[11].call(String.class, ArrayUtil.createArray((Object)"%s, %-7s, %-7s, %8s, %8s, %8s\n", (Object)it, (Object)callSiteArray[12].callStatic(Formatter.class, (Object)r, (Object)5), (Object)callSiteArray[13].callStatic(Formatter.class, (Object)(r * r), (Object)5), (Object)callSiteArray[14].callGetProperty(bin), (Object)callSiteArray[15].callGetProperty(bin), (Object)callSiteArray[16].callGetProperty(bin))));
            }

            public BinCounter getCounter() {
                CallSite[] callSiteArray = _savePropensities_closure10.$getCallSiteArray();
                return (BinCounter)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), BinCounter.class);
            }

            public StringBuilder getCsv() {
                CallSite[] callSiteArray = _savePropensities_closure10.$getCallSiteArray();
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.csv.get(), StringBuilder.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _savePropensities_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _savePropensities_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "posRatio";
                stringArray[2] = "leftShift";
                stringArray[3] = "format";
                stringArray[4] = "format";
                stringArray[5] = "format";
                stringArray[6] = "multiply";
                stringArray[7] = "count";
                stringArray[8] = "positives";
                stringArray[9] = "negatives";
                stringArray[10] = "leftShift";
                stringArray[11] = "format";
                stringArray[12] = "format";
                stringArray[13] = "format";
                stringArray[14] = "count";
                stringArray[15] = "positives";
                stringArray[16] = "negatives";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _savePropensities_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_savePropensities_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _savePropensities_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].callGroovyObjectGetProperty((Object)((BinCounter)counter2.get())))), (Object)new _savePropensities_closure10(AnalyzeRoutine.class, AnalyzeRoutine.class, counter2, csv));
        callSiteArray[83].callStatic(Futils.class, (Object)fname, (Object)((StringBuilder)csv.get()));
        callSiteArray[84].callStatic(AnalyzeRoutine.class, (Object)new GStringImpl(new Object[]{fname}, new String[]{"Calculated propensities saved to [", "]"}));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AnalyzeRoutine.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = AnalyzeRoutine.$getCallSiteArray()[85].call(LoggerFactory.class, (Object)"cz.siret.prank.program.routines.AnalyzeRoutine");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public String getSubCommand() {
        return this.subCommand;
    }

    @Generated
    public void setSubCommand(String string) {
        this.subCommand = string;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(String string) {
        this.label = string;
    }

    @Generated
    public String getDatasetFile() {
        return this.datasetFile;
    }

    @Generated
    public void setDatasetFile(String string) {
        this.datasetFile = string;
    }

    @Generated
    public Dataset getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Generated
    public Map<String, Closure> getCommandRegister() {
        return this.commandRegister;
    }

    @Generated
    public void setCommandRegister(Map<String, Closure> map) {
        this.commandRegister = map;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "copyOf";
        stringArray[1] = "getAt";
        stringArray[2] = "unnamedArgs";
        stringArray[3] = "containsKey";
        stringArray[4] = "write";
        stringArray[5] = "plus";
        stringArray[6] = "keySet";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "getAt";
        stringArray[9] = "unnamedArgs";
        stringArray[10] = "findDataset";
        stringArray[11] = "loadDataset";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "label";
        stringArray[16] = "findOutdir";
        stringArray[17] = "write";
        stringArray[18] = "writeParams";
        stringArray[19] = "outdir";
        stringArray[20] = "call";
        stringArray[21] = "get";
        stringArray[22] = "write";
        stringArray[23] = "absPath";
        stringArray[24] = "outdir";
        stringArray[25] = "ligand_protein_contact_distance";
        stringArray[26] = "params";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "processItems";
        stringArray[29] = "write";
        stringArray[30] = "plus";
        stringArray[31] = "toString";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "processItems";
        stringArray[34] = "writeFile";
        stringArray[35] = "outdir";
        stringArray[36] = "write";
        stringArray[37] = "toString";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "processItems";
        stringArray[40] = "writeFile";
        stringArray[41] = "outdir";
        stringArray[42] = "hasResidueLabeling";
        stringArray[43] = "binaryResidueLabeler";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "printSprintChains";
        stringArray[46] = "processItems";
        stringArray[47] = "writeFile";
        stringArray[48] = "outdir";
        stringArray[49] = "processItems";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "processItems";
        stringArray[52] = "writeFile";
        stringArray[53] = "outdir";
        stringArray[54] = "hasResidueLabeling";
        stringArray[55] = "binaryResidueLabeler";
        stringArray[56] = "synchronizedList";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "processItems";
        stringArray[59] = "join";
        stringArray[60] = "savePropensities";
        stringArray[61] = "outdir";
        stringArray[62] = "hasResidueLabeling";
        stringArray[63] = "binaryResidueLabeler";
        stringArray[64] = "synchronizedList";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "processItems";
        stringArray[67] = "savePropensities";
        stringArray[68] = "outdir";
        stringArray[69] = "join";
        stringArray[70] = "hasResidueLabeling";
        stringArray[71] = "binaryResidueLabeler";
        stringArray[72] = "synchronizedList";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "processItems";
        stringArray[75] = "savePropensities";
        stringArray[76] = "outdir";
        stringArray[77] = "join";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "each";
        stringArray[80] = "toSorted";
        stringArray[81] = "keySet";
        stringArray[82] = "table";
        stringArray[83] = "writeFile";
        stringArray[84] = "write";
        stringArray[85] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[86];
        AnalyzeRoutine.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AnalyzeRoutine.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AnalyzeRoutine.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

