/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.rendering;

import cz.siret.prank.domain.labeling.BinaryLabeling;
import cz.siret.prank.domain.labeling.LabeledPoint;
import cz.siret.prank.domain.labeling.LabeledResidue;
import cz.siret.prank.domain.labeling.ResidueLabeling;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.program.rendering.RenderingModel;
import cz.siret.prank.utils.Futils;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PymolRenderer
implements Parametrized,
GroovyObject {
    private String outdir;
    private RenderingModel model;
    private String label;
    private String pmlFile;
    private String dataDir;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PymolRenderer(String outdir, RenderingModel model) {
        RenderingModel renderingModel;
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        this.outdir = string = outdir;
        this.model = renderingModel = model;
    }

    public void render() {
        String string;
        this.label = string = this.model.getLabel();
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.outdir, this.label}, new String[]{"", "/", ".pml"});
        this.pmlFile = ShortTypeHandling.castToString((Object)gStringImpl);
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{this.outdir}, new String[]{"", "/data"});
        this.dataDir = ShortTypeHandling.castToString((Object)gStringImpl2);
        Futils.mkdirs(this.dataDir);
        String proteinFileAbs = Futils.absPath(this.model.getProteinFile());
        String proteinFile = proteinFileAbs;
        if (this.model.getDoubleLabeling() != null) {
            public final class _render_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ float $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _render_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    ((Atom)it).setTempFactor($const$0);
                    return null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _render_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                    float f;
                    $const$0 = f = 0.0f;
                }

                static {
                    _render_closure1.__$swapInit();
                }
            }
            DefaultGroovyMethods.each((Iterable)this.model.getProtein().getAllAtoms(), (Closure)new _render_closure1(this, this));
            public final class _render_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _render_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object lr) {
                    Reference lr2 = new Reference(lr);
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference lr;
                        private static /* synthetic */ float $const$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure3(Object _outerInstance, Object _thisObject, Reference lr) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.lr = reference = lr;
                        }

                        public Object doCall(Object a) {
                            Object l = ((LabeledResidue)this.lr.get()).getLabel();
                            Double d = (Double)ScriptBytecodeAdapter.castToType(l, Double.class);
                            ((Atom)a).setTempFactor(DefaultTypeTransformation.floatUnbox((Object)(DefaultTypeTransformation.booleanUnbox(l) ? d : (Double)ScriptBytecodeAdapter.castToType((Object)Float.valueOf($const$0), Double.class))));
                            return null;
                        }

                        public Object getLr() {
                            return this.lr.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public static /* synthetic */ void __$swapInit() {
                            float f;
                            $const$0 = f = 0.0f;
                        }

                        static {
                            _closure3.__$swapInit();
                        }
                    }
                    return DefaultGroovyMethods.each((List)((LabeledResidue)lr2.get()).getResidue().getAminoAcid().getAtoms(), (Closure)new _closure3((Object)this, this.getThisObject(), lr2));
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _render_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.model.getDoubleLabeling().getLabeledResidues(), (Closure)new _render_closure2(this, this));
        }
        if (this.getParams().getVis_generate_proteins() || this.getParams().getVis_copy_proteins()) {
            String string2;
            String string3;
            String name = Futils.shortName(proteinFile);
            String newfAbs = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataDir, name}, new String[]{"", "/", ""}));
            if (this.getParams().getVis_generate_proteins()) {
                String string4;
                newfAbs = string4 = this.model.getProtein().saveToPdbFile(newfAbs, true);
            } else if (this.getParams().getVis_copy_proteins()) {
                Futils.copy(proteinFileAbs, newfAbs);
            }
            String newfRelative = StringGroovyMethods.plus((String)"data/", (CharSequence)Futils.shortName(newfAbs));
            proteinFile = string3 = newfRelative;
            proteinFileAbs = string2 = newfAbs;
        }
        Futils.writeFile(this.pmlFile, this.renderMain(proteinFile));
    }

    private String renderMain(String proteinFile) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{proteinFile, this.renderLabaledPoints(), this.renderResidueColoring()}, new String[]{"\nfrom pymol import cmd,stored\n\nset depth_cue, 1\nset fog_start, 0.4\n\nset_color b_col, [36,36,85]\nset_color t_col, [10,10,10]\nset bg_rgb_bottom, b_col\nset bg_rgb_top, t_col      \nset bg_gradient\n\nset  spec_power  =  200\nset  spec_refl   =  0\n\nload ", ", protein\ncreate ligands, protein and organic\nselect xlig, protein and organic\ndelete xlig\n\nhide everything, all\nremove hydrogens\nremove solvent\n\ncolor white, elem c\ncolor bluewhite, protein\nshow surface, protein\n\nshow sticks, ligands\nset stick_color, magenta\n\n", " \n\n", "\n\ndeselect\n\norient\n"}));
    }

    private String renderResidueColoring() {
        if (this.model.getObservedLabeling() != null) {
            if (this.model.getPredictedLabeling() != null) {
                return this.renderObservedVsPredicted(this.model.getObservedLabeling(), this.model.getPredictedLabeling());
            }
            return this.renderBinaryResidueColoring(this.model.getObservedLabeling());
        }
        if (this.model.getDoubleLabeling() != null) {
            return this.renderDoubleColoring(this.model.getDoubleLabeling());
        }
        return ShortTypeHandling.castToString(null);
    }

    private String renderDoubleColoring(ResidueLabeling<Double> labeling) {
        return "                      \ncmd.spectrum(\"b\", \"rainbow\", selection=\"protein\", minimum=0, maximum=1)\n";
    }

    private String renderBinaryResidueColoring(BinaryLabeling labeling) {
        StringBuilder res = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)res, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"set_color pos_res_col = ", (CharSequence)PymolRenderer.pyColor(this.model.getStyle().getPositiveResiduesColor())), (CharSequence)"\n"));
        StringGroovyMethods.leftShift((StringBuilder)res, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"set_color neg_res_col = ", (CharSequence)PymolRenderer.pyColor(this.model.getStyle().getNegativeResiduesColor())), (CharSequence)"\n"));
        int i = 1;
        LabeledResidue lr = null;
        Iterator iterator = labeling.getLabeledResidues().iterator();
        while (iterator.hasNext()) {
            lr = (LabeledResidue)ScriptBytecodeAdapter.castToType(iterator.next(), LabeledResidue.class);
            String ids = DefaultGroovyMethods.join(lr.getResidue().getAtoms().getIndexes(), (String)",");
            String key = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{i}, new String[]{"residue_", ""}));
            Object l = lr.getLabel();
            String ncol = (l == null ? false : (Boolean)l) ? "pos_res_col" : "neg_res_col";
            StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{key, ids}, new String[]{"select ", ", protein and id [", "] \n"}));
            StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{ncol, key}, new String[]{"color ", ", ", " \n"}));
            StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{ncol, key}, new String[]{"set surface_color, ", ", ", " \n"}));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return res.toString();
    }

    private String renderObservedVsPredicted(BinaryLabeling observed, BinaryLabeling predicted) {
        StringBuilder res = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)res, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"set_color tp_col = ", (CharSequence)PymolRenderer.pyColor(this.model.getStyle().getTpColor())), (CharSequence)"\n"));
        StringGroovyMethods.leftShift((StringBuilder)res, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"set_color fp_col = ", (CharSequence)PymolRenderer.pyColor(this.model.getStyle().getFpColor())), (CharSequence)"\n"));
        StringGroovyMethods.leftShift((StringBuilder)res, (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"set_color fn_col = ", (CharSequence)PymolRenderer.pyColor(this.model.getStyle().getFnColor())), (CharSequence)"\n"));
        int i = 0;
        while (i != observed.getLabeledResidues().size()) {
            LabeledResidue obs = (LabeledResidue)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(observed.getLabeledResidues(), (int)i), LabeledResidue.class);
            LabeledResidue pred = (LabeledResidue)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(predicted.getLabeledResidues(), (int)i), LabeledResidue.class);
            if (!(!DefaultTypeTransformation.booleanUnbox(obs.getLabel()) && !DefaultTypeTransformation.booleanUnbox(pred.getLabel()))) {
                String col = "";
                Object l = obs.getLabel();
                if (l == null ? false : (Boolean)l) {
                    String string;
                    String string2;
                    Object l2 = pred.getLabel();
                    col = (l2 == null ? false : (Boolean)l2) ? (string2 = "tp_col") : (string = "fn_col");
                } else {
                    String string;
                    col = string = "fp_col";
                }
                String ids = DefaultGroovyMethods.join(obs.getResidue().getAtoms().getIndexes(), (String)",");
                String key = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{i}, new String[]{"residue_", ""}));
                StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{key, ids}, new String[]{"select ", ", protein and id [", "] \n"}));
                StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{col, key}, new String[]{"color ", ", ", " \n"}));
                StringGroovyMethods.leftShift((StringBuilder)res, (Object)new GStringImpl(new Object[]{col, key}, new String[]{"set surface_color, ", ", ", " \n"}));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return res.toString();
    }

    private String renderLabaledPoints() {
        if (this.model.getLabeledPoints() == null) {
            return "";
        }
        String pointsfAbs = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataDir, this.label}, new String[]{"", "/", "_points.pdb.gz"}));
        String pointsfRel = StringGroovyMethods.plus((String)"data/", (CharSequence)Futils.shortName(pointsfAbs));
        this.writeLabeledPoints(pointsfAbs, this.model.getLabeledPoints());
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pointsfRel}, new String[]{"\nload ", ", points\nhide nonbonded, points\nshow nb_spheres, points\ncmd.spectrum(\"b\", \"green_red\", selection=\"points\", minimum=0, maximum=0.7)\n\n#select pockets, resn STP\nstored.list=[]\ncmd.iterate(\"(resn STP)\",\"stored.list.append(resi)\")    #read info about residues STP\n#print stored.list\nlastSTP=stored.list[-1] #get the index of the last residu\nhide lines, resn STP\n\n# sas points\ncmd.select(\"rest\", \"resn STP and resi 0\")\ncmd.set(\"sphere_scale\",\"0.3\",\"rest\")\n\n# pockets (old)\n#for my_index in range(1,int(lastSTP)+1): cmd.select(\"pocket\"+str(my_index), \"resn STP and resi \"+str(my_index))\n#for my_index in range(1,int(lastSTP)+1): cmd.show(\"spheres\",\"pocket\"+str(my_index))\n#for my_index in range(1,int(lastSTP)+1): cmd.set(\"sphere_scale\",\"0.4\",\"pocket\"+str(my_index))\n#for my_index in range(1,int(lastSTP)+1): cmd.set(\"sphere_transparency\",\"0.1\",\"pocket\"+str(my_index))\n"}));
    }

    public void writeLabeledPoints(String fname, List<LabeledPoint> labeledPoints) {
        PrintWriter pdb = Futils.getGzipWriter(fname);
        int i = 0;
        LabeledPoint lp = null;
        Iterator<LabeledPoint> iterator = labeledPoints.iterator();
        while (iterator.hasNext()) {
            lp = (LabeledPoint)ScriptBytecodeAdapter.castToType((Object)iterator.next(), LabeledPoint.class);
            double beta = lp.getScore();
            Atom p = lp.getPoint();
            String lab = "STP";
            pdb.printf("HETATM%5d H    %3s 1  %2d    %8.3f%8.3f%8.3f  0.50%6.3f\n", i, lab, lp.getPocket(), p.getX(), p.getY(), p.getZ(), beta);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        pdb.close();
    }

    public static String pyColor(Color c) {
        return DefaultGroovyMethods.sprintf(PymolRenderer.class, (String)"[%5.3f,%5.3f,%5.3f]", (Object[])new Object[]{NumberNumberDiv.div((Number)c.getRed(), (Number)255), NumberNumberDiv.div((Number)c.getGreen(), (Number)255), NumberNumberDiv.div((Number)c.getBlue(), (Number)255)});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PymolRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.rendering.PymolRenderer");
        Parametrized.Trait.Helper.$static$init$(PymolRenderer.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getOutdir() {
        return this.outdir;
    }

    @Generated
    public void setOutdir(String string) {
        this.outdir = string;
    }

    @Generated
    public RenderingModel getModel() {
        return this.model;
    }

    @Generated
    public void setModel(RenderingModel renderingModel) {
        this.model = renderingModel;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(String string) {
        this.label = string;
    }

    @Generated
    public String getPmlFile() {
        return this.pmlFile;
    }

    @Generated
    public void setPmlFile(String string) {
        this.pmlFile = string;
    }

    @Generated
    public String getDataDir() {
        return this.dataDir;
    }

    @Generated
    public void setDataDir(String string) {
        this.dataDir = string;
    }
}

