/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program.params.optimizer.spearmint;

import com.google.gson.Gson;
import cz.siret.prank.program.PrankException;
import cz.siret.prank.program.params.optimizer.HObjectiveFunction;
import cz.siret.prank.program.params.optimizer.HOptimizer;
import cz.siret.prank.program.params.optimizer.HStep;
import cz.siret.prank.program.params.optimizer.HVariable;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.ProcessRunner;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSpearmintOptimizer
extends HOptimizer
implements Writable {
    private static int SLEEP_INTERVAL;
    private String spearmintCommand;
    private String mongodbCommand;
    private Likelihood likelihood;
    private Path spearmintDir;
    private Path experimentDir;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public HSpearmintOptimizer(Path spearmintDir, Path experimentDir) {
        Path path;
        Path path2;
        MetaClass metaClass;
        Likelihood likelihood;
        String string;
        String string2;
        this.spearmintCommand = string2 = "python main.py";
        this.mongodbCommand = string = "mongod";
        this.likelihood = likelihood = Likelihood.GAUSSIAN;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        this.spearmintDir = path2 = spearmintDir;
        this.experimentDir = path = experimentDir;
    }

    @Override
    public HStep optimize(HObjectiveFunction objective) {
        Object v2;
        String mongoDataDir;
        String mongoOutFile;
        String mongoLogFile;
        String mongoDir;
        String evalDir;
        String varsDir;
        String dir;
        block12: {
            dir = Futils.absSafePath(this.experimentDir.toString());
            varsDir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/vars"}));
            evalDir = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/eval"}));
            Futils.delete(dir);
            Futils.mkdirs(dir);
            Futils.mkdirs(varsDir);
            Futils.mkdirs(evalDir);
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/config.json"})), this.genConfig());
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/eval.py"})), this.genEval());
            String sysTmpDir = Futils.getSystemTempDir();
            mongoDir = Futils.absSafePath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{sysTmpDir}, new String[]{"", "/prank/hopt/mongo"})));
            mongoLogFile = Futils.absSafePath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mongoDir}, new String[]{"", "/mongo.log"})));
            mongoOutFile = Futils.absSafePath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mongoDir}, new String[]{"", "/mongo.out"})));
            mongoDataDir = Futils.absSafePath(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mongoDir}, new String[]{"", "/data"})));
            Futils.delete(mongoDir);
            Futils.mkdirs(mongoDataDir);
            try {
                HSpearmintOptimizer.write("Killing mongodb");
                ProcessRunner.process("sudo pkill mongo").inheritIO().executeAndWait();
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                    v0 = null;
                    break block12;
                }
                v0 = null;
            }
        }
        HSpearmintOptimizer.write("Starting mongodb");
        String mcmd = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.mongodbCommand, mongoLogFile, mongoDataDir}, new String[]{"", " --fork --smallfiles --logpath ", " --dbpath ", ""}));
        HSpearmintOptimizer.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mcmd}, new String[]{"  executing '", "'"})));
        ProcessRunner mongoProc = ProcessRunner.process(mcmd, mongoDir).redirectErrorStream().redirectOutput(new File(mongoOutFile));
        int exitCode = mongoProc.executeAndWait();
        if (exitCode != 0) {
            Object v1;
            if (log.isErrorEnabled()) {
                log.error(StringGroovyMethods.plus((String)"Mongodb log: \n ", (CharSequence)Futils.readFile(mongoLogFile)));
                v1 = null;
            } else {
                v1 = null;
            }
            throw (Throwable)new PrankException("Failed to execute mongodb (required by spearmint)");
        }
        HSpearmintOptimizer.write("Starting spearmint");
        String scmd = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.spearmintCommand, (CharSequence)" "), (CharSequence)dir);
        HSpearmintOptimizer.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{scmd}, new String[]{"  executing '", "'"})));
        ProcessRunner spearmintProc = ProcessRunner.process(scmd, this.spearmintDir.toString()).inheritIO();
        spearmintProc.execute();
        int stepNumber = 0;
        int jobId = 0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{varsDir}, new String[]{"waiting for first vars file in '", "'"})));
            v2 = null;
        } else {
            v2 = null;
        }
        while (Futils.isDirEmpty(varsDir)) {
            log.debug("waiting...");
            DefaultGroovyStaticMethods.sleep(null, (long)SLEEP_INTERVAL);
        }
        Integer n = StringGroovyMethods.toInteger((CharSequence)((File)DefaultGroovyMethods.first(Futils.listFiles(varsDir))).getName());
        jobId = n;
        List varNames = DefaultGroovyMethods.toList((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(HSpearmintOptimizer.class, this.getVariables(), (String)"name"), Iterable.class)));
        String stepsf = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/steps.csv"}));
        Futils.writeFile(stepsf, StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[num], [job_id], ", (CharSequence)DefaultGroovyMethods.join((Iterable)varNames, (String)", ")), (CharSequence)", [value] \n"));
        double sumTime = 0.0;
        while (stepNumber < this.getMaxIterations()) {
            ATimer timer = ATimer.startTimer();
            log.info("job id: {}", (Object)jobId);
            String varf = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{varsDir, jobId}, new String[]{"", "/", ""}));
            this.waitForFile(varf);
            Reference vars = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)new Gson().fromJson(Futils.readFile(varf), Map.class), Map.class)));
            log.info("vars: {}", (Object)((Map)vars.get()));
            double val = objective.eval((Map)vars.get(), stepNumber);
            log.info("value: {}", (Object)val);
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{evalDir, jobId}, new String[]{"", "/", ""})), this.formatValue(val));
            HStep step = new HStep(stepNumber, (Map)vars.get(), val);
            this.getSteps().add(step);
            public final class _optimize_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference vars;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _optimize_closure1(Object _outerInstance, Object _thisObject, Reference vars) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.vars = reference = vars;
                }

                public Object doCall(Object it) {
                    return HSpearmintOptimizer.fmt(((Map)this.vars.get()).get(it));
                }

                public Map getVars() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.vars.get(), Map.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _optimize_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Futils.append(stepsf, new GStringImpl(new Object[]{stepNumber, jobId}, new String[]{"", ", ", ", "}).plus(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)varNames, (Closure)new _optimize_closure1(this, this, vars)), (String)", ")).plus((GString)new GStringImpl(new Object[]{HSpearmintOptimizer.fmt(val)}, new String[]{", ", " \n"})));
            String bests = this.printBestStep(this.getBestStep(), varNames);
            Futils.writeFile(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"", "/best.csv"})), bests);
            HSpearmintOptimizer.write(StringGroovyMethods.plus((String)"BEST STEP:\n", (CharSequence)bests));
            HSpearmintOptimizer.write(StringGroovyMethods.plus((String)"For results see ", (CharSequence)stepsf));
            long time = timer.getTimeSec();
            double cfr_ignored_0 = sumTime + (double)time;
            long avgTime = (long)(sumTime / (double)(stepNumber + 1));
            HSpearmintOptimizer.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stepNumber, time, avgTime}, new String[]{"Step ", " finished in ", "s (avg: ", "s)"})));
            int n2 = stepNumber;
            int cfr_ignored_1 = n2 + 1;
            int n3 = jobId;
            int cfr_ignored_2 = n3 + 1;
        }
        spearmintProc.kill();
        mongoProc.kill();
        return this.getBestStep();
    }

    public String printBestStep(HStep step, List<String> varNames) {
        Reference step2 = new Reference((Object)step);
        public final class _printBestStep_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference step;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _printBestStep_closure2(Object _outerInstance, Object _thisObject, Reference step) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.step = reference = step;
            }

            public Object doCall(Object it) {
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)it), (CharSequence)",\t\t"), (CharSequence)HSpearmintOptimizer.fmt(((HStep)this.step.get()).getVariableValues().get(it)));
            }

            public HStep getStep() {
                return (HStep)ScriptBytecodeAdapter.castToType((Object)this.step.get(), HStep.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _printBestStep_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(varNames, (Closure)new _printBestStep_closure2(this, this, step2)), (String)"\n"), (CharSequence)"\nvalue,\t\t"), (CharSequence)HSpearmintOptimizer.fmt(((HStep)step2.get()).getFunctionValue())), (CharSequence)"\n");
    }

    public String formatValue(double v) {
        return Formatter.format(v, 5);
    }

    public static String fmt(Object x) {
        if (x == null) {
            return "";
        }
        return DefaultGroovyMethods.sprintf(HSpearmintOptimizer.class, (String)"%8.4f", (Object)x);
    }

    public void waitForFile(String fname) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fname}, new String[]{"waiting for file '", "'"})));
            v0 = null;
        } else {
            v0 = null;
        }
        while (!Futils.exists(fname)) {
            log.debug("waiting...");
            DefaultGroovyStaticMethods.sleep(null, (long)SLEEP_INTERVAL);
        }
    }

    private String genConfig() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.likelihood, this.genVariables()}, new String[]{"\n        {\n            \"language\"        : \"PYTHON\",\n            \"main-file\"       : \"eval.py\",\n            \"experiment-name\" : \"spearmint_experiment\",\n            \"likelihood\"      : \"", "\",\n            \"variables\" : {\n                ", "\n            }\n        }\n        "}));
    }

    private String genVariable(HVariable var) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{var.getName(), var.getType(), var.getMin(), var.getMax()}, new String[]{"\n                \"", "\" : {\n                    \"type\" : \"", "\",\n                    \"size\" : 1,\n                    \"min\"  : ", ",\n                    \"max\"  : ", "\n                }\n        "}));
    }

    private String genVariables() {
        public final class _genVariables_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _genVariables_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((HSpearmintOptimizer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), HSpearmintOptimizer.class)).genVariable((HVariable)ScriptBytecodeAdapter.castToType((Object)it, HVariable.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _genVariables_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(this.getVariables(), (Closure)new _genVariables_closure3(this, this)), (String)",\n");
    }

    private String genEval() {
        return "\nimport numpy as np\nimport math\nimport os.path\nimport time\nimport json\nimport os\n\ndef eval(job_id, variables):\n\n    valf = \"eval/\" + str(job_id)\n\n    # wait until value file exists\n    while not os.path.exists(valf):\n        time.sleep(1)\n\n    with open(valf) as file:\n        value = file.read()\n        \n    return float(value)\n\ndef main(job_id, variables):\n    print \"variables: \" + str(variables)\n\n    # prepare vars for java\n    vars = {}\n    for key, value in variables.iteritems():\n        vars[key] = value[0]\n    print \"vars: \" + json.dumps(vars)\n    if not os.path.exists(\"vars\"):\n        os.makedirs(\"vars\")\n    varf = \"vars/\" + str(job_id) \n    with open(varf, \"w\") as file:\n        file.write(str(json.dumps(vars)) + \"\\n\")\n\n    return eval(job_id, variables)\n    \n        ";
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HSpearmintOptimizer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(HSpearmintOptimizer.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{HSpearmintOptimizer.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(HSpearmintOptimizer.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{HSpearmintOptimizer.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(HSpearmintOptimizer.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{HSpearmintOptimizer.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(HSpearmintOptimizer.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{HSpearmintOptimizer.class, arg1});
    }

    static {
        Logger logger;
        int n;
        SLEEP_INTERVAL = n = 100;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.program.params.optimizer.spearmint.HSpearmintOptimizer");
        Writable.Trait.Helper.$static$init$(HSpearmintOptimizer.class);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HSpearmintOptimizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, HSpearmintOptimizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(HSpearmintOptimizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static int getSLEEP_INTERVAL() {
        return SLEEP_INTERVAL;
    }

    @Generated
    public static void setSLEEP_INTERVAL(int n) {
        SLEEP_INTERVAL = n;
    }

    @Generated
    public String getSpearmintCommand() {
        return this.spearmintCommand;
    }

    @Generated
    public void setSpearmintCommand(String string) {
        this.spearmintCommand = string;
    }

    @Generated
    public String getMongodbCommand() {
        return this.mongodbCommand;
    }

    @Generated
    public void setMongodbCommand(String string) {
        this.mongodbCommand = string;
    }

    @Generated
    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    @Generated
    public void setLikelihood(Likelihood likelihood) {
        this.likelihood = likelihood;
    }

    @Generated
    public Path getSpearmintDir() {
        return this.spearmintDir;
    }

    @Generated
    public void setSpearmintDir(Path path) {
        this.spearmintDir = path;
    }

    @Generated
    public Path getExperimentDir() {
        return this.experimentDir;
    }

    @Generated
    public void setExperimentDir(Path path) {
        this.experimentDir = path;
    }

    public static final class Likelihood
    extends Enum<Likelihood>
    implements GroovyObject {
        public static final /* enum */ Likelihood NOISELESS;
        public static final /* enum */ Likelihood GAUSSIAN;
        public static final Likelihood MIN_VALUE;
        public static final Likelihood MAX_VALUE;
        private static final /* synthetic */ Likelihood[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Likelihood(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum cz.siret.prank.program.params.optimizer.spearmint.HSpearmintOptimizer$Likelihood was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public Likelihood() {
            this(new LinkedHashMap());
        }

        public static final Likelihood[] values() {
            return (Likelihood[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Likelihood[].class);
        }

        public /* synthetic */ Likelihood next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Likelihood)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Likelihood.class);
        }

        public /* synthetic */ Likelihood previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Likelihood)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Likelihood.class);
        }

        public static Likelihood valueOf(String name) {
            return (Likelihood)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Likelihood.class, name)), Likelihood.class);
        }

        public static final /* synthetic */ Likelihood $INIT(Object ... para) {
            Likelihood likelihood;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Likelihood.class)) {
                case -1348271900: {
                    Likelihood likelihood2;
                    likelihood = likelihood2;
                    Object[] objectArray2 = objectArray;
                    likelihood2 = new Likelihood();
                    break;
                }
                case -242181752: {
                    Likelihood likelihood2;
                    likelihood = likelihood2;
                    Object[] objectArray2 = objectArray;
                    likelihood2 = new Likelihood((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return likelihood;
        }

        static {
            Likelihood likelihood;
            Likelihood likelihood2;
            Likelihood likelihood3;
            Likelihood likelihood4;
            NOISELESS = likelihood4 = Likelihood.$INIT("NOISELESS", 0);
            GAUSSIAN = likelihood3 = Likelihood.$INIT("GAUSSIAN", 1);
            MIN_VALUE = likelihood2 = NOISELESS;
            MAX_VALUE = likelihood = GAUSSIAN;
            Likelihood[] likelihoodArray = new Likelihood[]{NOISELESS, GAUSSIAN};
            $VALUES = likelihoodArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Likelihood.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

