/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.program;

import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.Writable;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogManager
implements Writable,
GroovyObject {
    private static final String LOGGER_NAME = "cz.siret.prank";
    private static final String CONSOLE_APPENDER_NAME = "Console";
    private static final String FILE_APPENDER_NAME = "File";
    private static final String PATTERN = "[%level] %logger{0} - %msg%n";
    private boolean loggingToFile;
    private String logFile;
    private Appender fileAppender;
    private Configuration config;
    private LoggerConfig loggerConfig;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public LogManager() {
        MetaClass metaClass;
        boolean bl;
        this.loggingToFile = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
    }

    public void configureLoggers(String logLevel, boolean logToConsole, boolean logToFile, String outdir) {
        LoggerConfig loggerConfig;
        Configuration configuration;
        String loggerName = LOGGER_NAME;
        Level level = Level.getLevel((String)logLevel);
        LoggerContext ctx = (LoggerContext)ScriptBytecodeAdapter.castToType((Object)org.apache.logging.log4j.LogManager.getContext((boolean)false), LoggerContext.class);
        this.config = configuration = ctx.getConfiguration();
        this.loggerConfig = loggerConfig = this.config.getLoggerConfig(loggerName);
        LogManager.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{logToConsole}, new String[]{"logToConsole: ", ""})));
        LogManager.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{logToFile}, new String[]{"logToFile: ", ""})));
        LogManager.write(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{level.name()}, new String[]{"logLevel: ", ""})));
        this.loggerConfig.setLevel(level);
        if (logToFile) {
            boolean bl;
            Appender appender;
            GStringImpl gStringImpl = new GStringImpl(new Object[]{outdir}, new String[]{"", "/run.log"});
            this.logFile = ShortTypeHandling.castToString((Object)gStringImpl);
            this.fileAppender = appender = LogManager.addFileAppender(this.config, loggerName, this.logFile, level);
            this.loggingToFile = bl = true;
        }
        if (!logToConsole) {
            this.loggerConfig.setLevel(Level.ERROR);
        }
        ctx.updateLoggers();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private static Appender addFileAppender(Configuration config, String loggerName, String logFile, Level level) {
        String pattern = PATTERN;
        int bufferSize = 5000;
        Futils.delete(logFile);
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(pattern).build();
        FileAppender appender = FileAppender.createAppender((String)logFile, (String)"false", (String)"false", (String)FILE_APPENDER_NAME, (String)"false", (String)"false", (String)"true", (String)StringGroovyMethods.plus((CharSequence)"", (Object)bufferSize), (Layout)layout, null, (String)"false", null, (Configuration)config);
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)FILE_APPENDER_NAME, null, null);
        AppenderRef[] refs = (AppenderRef[])ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ref}).toArray(), AppenderRef[].class);
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        loggerConfig.addAppender((Appender)appender, level, null);
        return appender;
    }

    public void stopFileAppender() {
        if (this.fileAppender != null) {
            this.fileAppender.stop();
        }
        this.loggerConfig.removeAppender(FILE_APPENDER_NAME);
        this.config.getRootLogger().removeAppender(FILE_APPENDER_NAME);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LogManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(LogManager.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{LogManager.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(LogManager.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{LogManager.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(LogManager.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{LogManager.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(LogManager.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{LogManager.class, arg1});
    }

    static {
        Writable.Trait.Helper.$static$init$(LogManager.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public static String getLOGGER_NAME() {
        return LOGGER_NAME;
    }

    @Generated
    public static String getCONSOLE_APPENDER_NAME() {
        return CONSOLE_APPENDER_NAME;
    }

    @Generated
    public static String getFILE_APPENDER_NAME() {
        return FILE_APPENDER_NAME;
    }

    @Generated
    public static String getPATTERN() {
        return PATTERN;
    }

    @Generated
    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    @Generated
    public boolean isLoggingToFile() {
        return this.loggingToFile;
    }

    @Generated
    public void setLoggingToFile(boolean bl) {
        this.loggingToFile = bl;
    }

    @Generated
    public String getLogFile() {
        return this.logFile;
    }

    @Generated
    public void setLogFile(String string) {
        this.logFile = string;
    }

    @Generated
    public Appender getFileAppender() {
        return this.fileAppender;
    }

    @Generated
    public void setFileAppender(Appender appender) {
        this.fileAppender = appender;
    }

    @Generated
    public Configuration getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    @Generated
    public LoggerConfig getLoggerConfig() {
        return this.loggerConfig;
    }

    @Generated
    public void setLoggerConfig(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
    }
}

