/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.prediction.transformation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cz.siret.prank.prediction.transformation.ScoreTransformer;
import cz.siret.prank.program.routines.results.Evaluation;
import cz.siret.prank.utils.StatSample;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;

public class ProbabilityScoreTransformer
extends ScoreTransformer
implements Writable {
    private static int NBINS;
    private double min;
    private double max;
    private int nbins;
    private int[] tp_cumul_hist;
    private int[] fp_cumul_hist;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ProbabilityScoreTransformer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
    }

    @Override
    public double transformScore(double rawScore) {
        double tpx = this.getInterpoletedVal(this.tp_cumul_hist, rawScore);
        double fpx = this.getInterpoletedVal(this.fp_cumul_hist, rawScore);
        double res = tpx / (tpx + fpx);
        return res;
    }

    private double getInterpoletedVal(int[] hist, double x) {
        double step = (this.max - this.min) / (double)this.nbins;
        int idx = (int)((x - this.min) / step);
        if (idx < 0) {
            int n;
            idx = n = 0;
        }
        if (idx >= this.nbins) {
            int n;
            idx = n = this.nbins - 1;
        }
        if (idx == this.nbins - 1) {
            return BytecodeInterface8.intArrayGet((int[])hist, (int)idx);
        }
        double mod = x - this.min - step * (double)idx;
        double add = (double)(BytecodeInterface8.intArrayGet((int[])hist, (int)(idx + 1)) - BytecodeInterface8.intArrayGet((int[])hist, (int)idx)) * (mod / step);
        return (double)BytecodeInterface8.intArrayGet((int[])hist, (int)idx) + add;
    }

    public void doTrain(List<Double> posScores, List<Double> negScores) {
        int n;
        this.nbins = n = NBINS;
        List scores = DefaultGroovyMethods.plus(posScores, negScores);
        StatSample scoresSample = new StatSample(scores);
        double d = scoresSample.getMin();
        this.min = d;
        double d2 = scoresSample.getMax();
        this.max = d2;
        int[] tp_hist = this.calcHist(this.nbins, this.min, this.max, posScores);
        int[] fp_hist = this.calcHist(this.nbins, this.min, this.max, negScores);
        int i = 1;
        while (i < this.nbins) {
            int n2 = i;
            int n3 = BytecodeInterface8.intArrayGet((int[])tp_hist, (int)n2) + BytecodeInterface8.intArrayGet((int[])tp_hist, (int)(i - 1));
            BytecodeInterface8.intArraySet((int[])tp_hist, (int)n2, (int)n3);
            int n4 = i;
            int cfr_ignored_0 = n4 + 1;
        }
        int i2 = this.nbins - 2;
        while (ScriptBytecodeAdapter.compareGreaterThan((Object)i2, (Object)-1)) {
            int n5 = i2;
            int n6 = BytecodeInterface8.intArrayGet((int[])fp_hist, (int)n5) + BytecodeInterface8.intArrayGet((int[])fp_hist, (int)(i2 + 1));
            BytecodeInterface8.intArraySet((int[])fp_hist, (int)n5, (int)n6);
            int n7 = i2;
            int cfr_ignored_1 = n7 - 1;
        }
        int[] nArray = tp_hist;
        this.tp_cumul_hist = nArray;
        int[] nArray2 = fp_hist;
        this.fp_cumul_hist = nArray2;
    }

    @Override
    public void trainForPockets(Evaluation evaluation) {
        public final class _trainForPockets_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _trainForPockets_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Evaluation.PocketRow)it).isTruePocket();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _trainForPockets_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _trainForPockets_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _trainForPockets_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Evaluation.PocketRow)it).getScore();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _trainForPockets_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List tpScores = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll(evaluation.getPocketRows(), (Closure)new _trainForPockets_closure1(this, this)), (Closure)new _trainForPockets_closure2(this, this)));
        public final class _trainForPockets_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _trainForPockets_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return !((Evaluation.PocketRow)it).isTruePocket();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _trainForPockets_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _trainForPockets_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _trainForPockets_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Evaluation.PocketRow)it).getScore();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _trainForPockets_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List fpScores = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll(evaluation.getPocketRows(), (Closure)new _trainForPockets_closure3(this, this)), (Closure)new _trainForPockets_closure4(this, this)));
        this.doTrain(tpScores, fpScores);
    }

    private int[] calcHist(int nbins, double min, double max, List<Double> scores) {
        int[] hist = new int[nbins];
        double step = (max - min) / (double)nbins;
        Double x = null;
        Iterator<Double> iterator = scores.iterator();
        while (iterator.hasNext()) {
            x = (Double)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Double.class);
            int idx = (int)((x - min) / step);
            if (idx > nbins - 1) {
                int n;
                idx = n = nbins - 1;
            }
            int n = idx;
            int n2 = BytecodeInterface8.intArrayGet((int[])hist, (int)n);
            int n3 = n2 + 1;
            BytecodeInterface8.intArraySet((int[])hist, (int)n, (int)n3);
        }
        return hist;
    }

    @Override
    public JsonElement toJson() {
        return new Gson().toJsonTree((Object)this);
    }

    @Override
    public ScoreTransformer loadFromJson(JsonElement json) {
        return (ScoreTransformer)ScriptBytecodeAdapter.castToType((Object)new Gson().fromJson(json, ProbabilityScoreTransformer.class), ScoreTransformer.class);
    }

    public String toString() {
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)"ProbabilityScoreTransformer{", (CharSequence)"min="), (Object)this.min), (CharSequence)", max="), (Object)this.max), (CharSequence)", nbins="), (Object)this.nbins), (CharSequence)", tp_cumul_hist="), (CharSequence)Arrays.toString(this.tp_cumul_hist)), (CharSequence)", fp_cumul_hist="), (CharSequence)Arrays.toString(this.fp_cumul_hist)), (CharSequence)"}");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProbabilityScoreTransformer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(ProbabilityScoreTransformer.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{ProbabilityScoreTransformer.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(ProbabilityScoreTransformer.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{ProbabilityScoreTransformer.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(ProbabilityScoreTransformer.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{ProbabilityScoreTransformer.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(ProbabilityScoreTransformer.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{ProbabilityScoreTransformer.class, arg1});
    }

    static {
        int n;
        NBINS = n = 1000;
        Writable.Trait.Helper.$static$init$(ProbabilityScoreTransformer.class);
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public void setMin(double d) {
        this.min = d;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public void setMax(double d) {
        this.max = d;
    }

    @Generated
    public int getNbins() {
        return this.nbins;
    }

    @Generated
    public void setNbins(int n) {
        this.nbins = n;
    }

    @Generated
    public int[] getTp_cumul_hist() {
        return this.tp_cumul_hist;
    }

    @Generated
    public void setTp_cumul_hist(int ... nArray) {
        this.tp_cumul_hist = nArray;
    }

    @Generated
    public int[] getFp_cumul_hist() {
        return this.fp_cumul_hist;
    }

    @Generated
    public void setFp_cumul_hist(int ... nArray) {
        this.fp_cumul_hist = nArray;
    }
}

