/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.prediction.pockets.rescorers;

import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Prediction;
import cz.siret.prank.features.api.ProcessedItemContext;
import cz.siret.prank.features.tables.PropertyTable;
import cz.siret.prank.prediction.pockets.rescorers.PocketRescorer;
import cz.siret.prank.utils.Futils;
import cz.siret.prank.utils.PdbUtils;
import cz.siret.prank.utils.Sutils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLBIndexRescorer
extends PocketRescorer {
    private static final PropertyTable aaPropensitiesTable;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PLBIndexRescorer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void rescorePockets(Prediction prediction, ProcessedItemContext context) {
        double d;
        ArrayList<ExtPocket> extPockets = new ArrayList<ExtPocket>();
        double M = prediction.getPocketCount();
        Pocket pocket = null;
        Iterator<Pocket> iterator = prediction.getPockets().iterator();
        while (iterator.hasNext()) {
            double d2;
            double d3;
            Pocket pocket2;
            pocket = (Pocket)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Pocket.class);
            double plbi = 0.0;
            if (this.getParams().getPlb_rescorer_atomic()) {
                Atom a = null;
                Iterator<Atom> iterator2 = pocket.getSurfaceAtoms().iterator();
                while (iterator2.hasNext()) {
                    a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Atom.class);
                    String aaCode = PdbUtils.getCorrectedAtomResidueCode(a);
                    Double prop = aaPropensitiesTable.getValue(aaCode, "RAx");
                    if (!(prop != null)) continue;
                    plbi = DefaultTypeTransformation.doubleUnbox((Object)NumberNumberPlus.plus((Number)plbi, (Number)prop));
                }
            } else {
                Group g = null;
                Iterator<Group> iterator3 = pocket.getSurfaceAtoms().getDistinctGroupsSorted().iterator();
                while (iterator3.hasNext()) {
                    g = (Group)ScriptBytecodeAdapter.castToType((Object)iterator3.next(), Group.class);
                    String aaCode = PdbUtils.getCorrectedResidueCode(g);
                    Double prop = aaPropensitiesTable.getValue(aaCode, "RAx");
                    if (!(prop != null)) continue;
                    plbi = DefaultTypeTransformation.doubleUnbox((Object)NumberNumberPlus.plus((Number)plbi, (Number)prop));
                }
            }
            ExtPocket extPocket = new ExtPocket();
            extPocket.setPocket(pocket2);
            extPocket.setPLBi(d3);
            ExtPocket extPocket2 = extPocket;
            extPocket2.setPLBi(d2);
            extPockets.add(extPocket2);
        }
        double mu = DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.sum((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(PLBIndexRescorer.class, extPockets, (String)"PLBi"), Iterable.class)), (Object)0)) / M;
        double sig = 0.0;
        ExtPocket p = null;
        Iterator iterator4 = extPockets.iterator();
        while (iterator4.hasNext()) {
            p = (ExtPocket)ScriptBytecodeAdapter.castToType(iterator4.next(), ExtPocket.class);
            double x = p.getPLBi() - mu;
            double cfr_ignored_0 = sig + x * x;
        }
        sig = d = Math.sqrt(sig / M);
        ExtPocket p2 = null;
        Iterator iterator5 = extPockets.iterator();
        while (iterator5.hasNext()) {
            Object v0;
            double d4;
            double d5;
            p2 = (ExtPocket)ScriptBytecodeAdapter.castToType(iterator5.next(), ExtPocket.class);
            double cfr_ignored_1 = (p2.getPLBi() - mu) / sig;
            p2.setZPLB(d5);
            p2.getZPLB();
            p2.getPocket().setNewScore(d4);
            if (log.isInfoEnabled()) {
                log.info(Sutils.toStr(p2));
                v0 = null;
                continue;
            }
            v0 = null;
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PLBIndexRescorer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PLBIndexRescorer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PLBIndexRescorer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PLBIndexRescorer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    static {
        Logger logger;
        PropertyTable propertyTable;
        aaPropensitiesTable = propertyTable = PropertyTable.parse(Futils.readResource("/tables/aa-propensities.csv"));
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.prediction.pockets.rescorers.PLBIndexRescorer");
    }

    @Generated
    public static PropertyTable getAaPropensitiesTable() {
        return aaPropensitiesTable;
    }

    static class ExtPocket
    implements GroovyObject {
        private Pocket pocket;
        private double PLBi;
        private double ZPLB;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ExtPocket() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExtPocket.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExtPocket.class, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExtPocket.class, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExtPocket.class, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExtPocket.class, PLBIndexRescorer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Pocket getPocket() {
            return this.pocket;
        }

        @Generated
        public void setPocket(Pocket pocket) {
            this.pocket = pocket;
        }

        @Generated
        public double getPLBi() {
            return this.PLBi;
        }

        @Generated
        public void setPLBi(double d) {
            this.PLBi = d;
        }

        @Generated
        public double getZPLB() {
            return this.ZPLB;
        }

        @Generated
        public void setZPLB(double d) {
            this.ZPLB = d;
        }
    }
}

