/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.prediction.pockets.criteria;

import cz.siret.prank.domain.Ligand;
import cz.siret.prank.domain.Pocket;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.prediction.pockets.criteria.DSO;
import cz.siret.prank.prediction.pockets.criteria.PocketCriterium;
import cz.siret.prank.program.routines.results.EvalContext;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Tuple2;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class DSWO
implements PocketCriterium,
GroovyObject {
    private final double ligandCoverageThreshold;
    private final double pocketCoverageThreshold;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DSWO(double ligandCoverageThreshold, double pocketCoverageThreshold) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        double d = ligandCoverageThreshold;
        this.ligandCoverageThreshold = d;
        double d2 = pocketCoverageThreshold;
        this.pocketCoverageThreshold = d2;
    }

    @Override
    public boolean isIdentified(Ligand ligand, Pocket pocket, EvalContext context) {
        if (pocket.getSasPoints() == null) {
            return false;
        }
        Tuple2<Atoms, Atoms> sets = DSO.getUnionAndIntersection(ligand, pocket, context);
        int inter = ((Atoms)sets.getSecond()).getCount();
        if (inter == 0) {
            return false;
        }
        int nlig = ligand.getSasPoints().getCount();
        int npoc = pocket.getSasPoints().getCount();
        double ligCov = DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)inter, (Number)nlig));
        double pocCov = DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)inter, (Number)npoc));
        return !(ligCov < this.ligandCoverageThreshold) && !(pocCov < this.pocketCoverageThreshold);
    }

    @Override
    public double score(Ligand ligand, Pocket pocket) {
        return Double.NaN;
    }

    public String toString() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.ligandCoverageThreshold, this.pocketCoverageThreshold}, new String[]{"DSWO(", ";", ")"}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DSWO.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public final double getLigandCoverageThreshold() {
        return this.ligandCoverageThreshold;
    }

    @Generated
    public final double getPocketCoverageThreshold() {
        return this.pocketCoverageThreshold;
    }
}

