/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.prediction.metrics;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;

public class Histogram
implements GroovyObject {
    private double min;
    private double max;
    private int nbins;
    private double step;
    private long[] bins;
    private long count;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Histogram(double min, double max, int nbins) {
        int n;
        MetaClass metaClass;
        int n2 = 0;
        this.count = n2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            double d = min;
            valueRecorder.record((Object)d, 8);
            double d2 = max;
            valueRecorder.record((Object)d2, 15);
            boolean bl = d <= d2;
            valueRecorder.record((Object)bl, 12);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert min <= max", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            int n3 = nbins;
            valueRecorder2.record((Object)n3, 8);
            boolean bl = n3 > 0;
            valueRecorder2.record((Object)bl, 14);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert nbins > 0", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        double d = min;
        this.min = d;
        double d3 = max;
        this.max = d3;
        this.nbins = n = nbins;
        double d4 = (max - min) / (double)nbins;
        this.step = d4;
        long[] lArray = new long[nbins];
        this.bins = lArray;
    }

    private int findBin(double value) {
        if (value <= this.min) {
            return 0;
        }
        if (!(value < this.max)) {
            return this.nbins - 1;
        }
        return (int)((value - this.min) / this.step);
    }

    public void put(double value) {
        int bin = this.findBin(value);
        long l = BytecodeInterface8.lArrayGet((long[])this.bins, (int)bin) + (long)1;
        BytecodeInterface8.lArraySet((long[])this.bins, (int)bin, (long)l);
        long l2 = this.count;
        this.count = l2 + 1L;
    }

    public double[] getRelativeBins() {
        double[] rbins = new double[this.nbins];
        int i = 0;
        while (i != this.nbins) {
            double d = (double)BytecodeInterface8.lArrayGet((long[])this.bins, (int)i) / (double)this.count;
            BytecodeInterface8.dArraySet((double[])rbins, (int)i, (double)d);
            int cfr_ignored_0 = i + 1;
        }
        return rbins;
    }

    public void add(Histogram other) {
        if (!(this.nbins == other.getNbins())) {
            StringBuffer stringBuffer = new StringBuffer("(nbins == other.nbins). Values: ");
            stringBuffer.append((Object)"nbins = ");
            stringBuffer.append(InvokerHelper.toString((Object)this.nbins));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Unequal number of bins!");
        }
        this.count = this.count + other.getCount();
        int i = 0;
        while (i != this.nbins) {
            long l = BytecodeInterface8.lArrayGet((long[])this.bins, (int)i) + BytecodeInterface8.lArrayGet((long[])other.getBins(), (int)i);
            BytecodeInterface8.lArraySet((long[])this.bins, (int)i, (long)l);
            int cfr_ignored_0 = i + 1;
        }
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        double[] rbins = this.getRelativeBins();
        StringGroovyMethods.leftShift((StringBuilder)sb, (Object)"BIN_MAX, I, N, RATIO \n");
        int i = 0;
        while (i != this.nbins) {
            double binMax = this.min + (double)(i + 1) * this.step;
            StringGroovyMethods.leftShift((StringBuilder)sb, (Object)new GStringImpl(new Object[]{binMax, i, BytecodeInterface8.lArrayGet((long[])this.bins, (int)i), BytecodeInterface8.dArrayGet((double[])rbins, (int)i)}, new String[]{"", ", ", ", ", ", ", " \n"}));
            int cfr_ignored_0 = i + 1;
        }
        return sb.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Histogram.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public void setMin(double d) {
        this.min = d;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public void setMax(double d) {
        this.max = d;
    }

    @Generated
    public int getNbins() {
        return this.nbins;
    }

    @Generated
    public void setNbins(int n) {
        this.nbins = n;
    }

    @Generated
    public double getStep() {
        return this.step;
    }

    @Generated
    public void setStep(double d) {
        this.step = d;
    }

    @Generated
    public long[] getBins() {
        return this.bins;
    }

    @Generated
    public void setBins(long ... lArray) {
        this.bins = lArray;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public void setCount(long l) {
        this.count = l;
    }
}

