/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.prediction.metrics;

import cz.siret.prank.prediction.metrics.Histogram;
import cz.siret.prank.prediction.metrics.PPred;
import cz.siret.prank.prediction.metrics.WekaStatsHelper;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Formatter;
import cz.siret.prank.utils.Writable;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierStats
implements Parametrized,
Writable,
GroovyObject {
    private static final double EPS;
    private static final int HISTOGRAM_BINS = 100;
    private String name;
    private int[][] op;
    private int count;
    private int nclasses;
    private double sumE;
    private double sumEpos;
    private double sumEneg;
    private double sumSE;
    private double sumSEpos;
    private double sumSEneg;
    private double sumLogLoss;
    private Histograms histograms;
    private Metrics metrics;
    private boolean collecting;
    private ArrayList<PPred> predictions;
    private static final double[] HIST_0;
    private static final double[] HIST_1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ClassifierStats() {
        boolean bl;
        int n;
        MetaClass metaClass;
        boolean bl2;
        Metrics metrics;
        Histograms histograms;
        int n2;
        this.count = n2 = 0;
        boolean bl3 = false;
        this.sumE = (double)bl3;
        boolean bl4 = false;
        this.sumEpos = (double)bl4;
        boolean bl5 = false;
        this.sumEneg = (double)bl5;
        boolean bl6 = false;
        this.sumSE = (double)bl6;
        boolean bl7 = false;
        this.sumSEpos = (double)bl7;
        boolean bl8 = false;
        this.sumSEneg = (double)bl8;
        boolean bl9 = false;
        this.sumLogLoss = (double)bl9;
        this.histograms = histograms = new Histograms(this);
        this.metrics = metrics = new Metrics(this);
        this.collecting = bl2 = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Writable.Trait.Helper.$init$(this);
        Parametrized.Trait.Helper.$init$(this);
        this.nclasses = n = 2;
        int[][] nArray = new int[this.nclasses][this.nclasses];
        this.op = nArray;
        this.collecting = bl = this.getParams().isStats_collect_predictions();
        if (this.collecting) {
            ArrayList arrayList = new ArrayList();
            this.predictions = arrayList;
        }
    }

    public void addAll(ClassifierStats other) {
        int i = 0;
        while (i != this.nclasses) {
            int j = 0;
            while (j != this.nclasses) {
                int n = j;
                int[] nArray = (int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.op, (int)i), int[].class);
                int n2 = BytecodeInterface8.intArrayGet((int[])nArray, (int)n) + BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])other.getOp(), (int)i), int[].class)), (int)j);
                BytecodeInterface8.intArraySet((int[])nArray, (int)n, (int)n2);
                int cfr_ignored_0 = j + 1;
            }
            int cfr_ignored_1 = i + 1;
        }
        this.count = this.count + other.getCount();
        this.sumE = this.sumE + other.getSumE();
        this.sumEpos = this.sumEpos + other.getSumEpos();
        this.sumEneg = this.sumEneg + other.getSumEneg();
        this.sumSE = this.sumSE + other.getSumSE();
        this.sumSEpos = this.sumSEpos + other.getSumSEpos();
        this.sumSEneg = this.sumSEneg + other.getSumSEneg();
        this.histograms.add(other.getHistograms());
        if (this.predictions != null && other.getPredictions() != null) {
            this.predictions.addAll(other.getPredictions());
        }
    }

    public void addPrediction(boolean observed, boolean predicted) {
        double score = predicted ? 1 : 0;
        double[] hist = predicted ? HIST_1 : HIST_0;
        this.addPrediction(observed, predicted, score, hist);
    }

    public void addPrediction(boolean observed, boolean predicted, double score) {
        if (score < 0.0) {
            double d;
            score = d = 0.0;
        }
        double[] hist = new double[]{1.0 - score, score};
        this.addPrediction(observed, predicted, score, hist);
    }

    public void addPrediction(boolean observed, boolean predicted, double score, double ... hist) {
        double obsv = observed ? 1.0 : 0.0;
        double e = Math.abs(obsv - score);
        double se = e * e;
        this.sumE = this.sumE + e;
        this.sumSE = this.sumSE + se;
        if (observed) {
            this.sumEpos = this.sumEpos + e;
            this.sumSEpos = this.sumSEpos + se;
        } else {
            this.sumEneg = this.sumEneg + e;
            this.sumSEneg = this.sumSEneg + se;
        }
        double pCorrect = observed ? score : 1.0 - score;
        if (pCorrect < EPS) {
            double d;
            pCorrect = d = EPS;
        }
        this.sumLogLoss = this.sumLogLoss - Math.log(pCorrect);
        this.histograms.getScore().put(score);
        if (observed) {
            this.histograms.getScorePos().put(score);
        } else {
            this.histograms.getScoreNeg().put(score);
        }
        this.histograms.getScore0().put(BytecodeInterface8.dArrayGet((double[])hist, (int)0));
        this.histograms.getScore1().put(BytecodeInterface8.dArrayGet((double[])hist, (int)1));
        if (this.collecting) {
            this.predictions.add(new PPred(observed, score));
        }
        int n = predicted ? 1 : 0;
        int n2 = BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.op, (int)(observed ? 1 : 0)), int[].class)), (int)n);
        int n3 = n2 + 1;
        BytecodeInterface8.intArraySet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.op, (int)(observed ? 1 : 0)), int[].class)), (int)n, (int)n3);
        int n4 = this.count;
        this.count = n4 + 1;
    }

    public double calcMCC(double TP, double FP, double TN, double FN) {
        double d;
        double n = TP * TN - FP * FN;
        double d2 = (TP + FP) * (TP + FN) * (TN + FP) * (TN + FN);
        d2 = d = Math.sqrt(d2);
        if (d2 == 0.0) {
            double d3;
            d2 = d3 = 1.0;
        }
        return n / d2;
    }

    public double div(double a, double b) {
        if (b == 0.0) {
            return Double.NaN;
        }
        return a / b;
    }

    public Map<String, Double> getMetricsMap() {
        return this.metrics.toMap();
    }

    private static String format(double x) {
        return new DecimalFormat("#.####").format(x);
    }

    private String rel(double x) {
        return Formatter.formatPercent(x / (double)this.count);
    }

    public String toCSV(String classifierLabel) {
        Reference classifierLabel2 = new Reference((Object)classifierLabel);
        Metrics s = this.metrics;
        Reference P = new Reference((Object)s.getP());
        Reference R = new Reference((Object)s.getR());
        Reference sb = new Reference((Object)new StringBuilder());
        public final class _toCSV_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sb;
            private /* synthetic */ Reference classifierLabel;
            private /* synthetic */ Reference R;
            private /* synthetic */ Reference P;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toCSV_closure1(Object _outerInstance, Object _thisObject, Reference sb, Reference classifierLabel, Reference R, Reference P) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.sb = reference4 = sb;
                this.classifierLabel = reference3 = classifierLabel;
                this.R = reference2 = R;
                this.P = reference = P;
            }

            public Object doCall(Object it) {
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{this.classifierLabel.get()}, new String[]{"classifier: ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)",TN   , FP, (spc)\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)",FN   , TP, (r)\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)",(npv),(p)\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{((ClassifierStats)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ClassifierStats.class)).getCount()}, new String[]{"n:,", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"pred:  , [0],  [1]\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{((Metrics)this.getDelegate()).getTN(), ((Metrics)this.getDelegate()).getFP(), Formatter.formatPercent(((Metrics)this.getDelegate()).getSPC())}, new String[]{"obs[0] , ", ",  ", ", ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{((Metrics)this.getDelegate()).getFN(), ((Metrics)this.getDelegate()).getTP(), Formatter.formatPercent(DefaultTypeTransformation.doubleUnbox((Object)this.R.get()))}, new String[]{"obs[1] , ", ",  ", ", ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{Formatter.formatPercent(((Metrics)this.getDelegate()).getNPV()), Formatter.formatPercent(DefaultTypeTransformation.doubleUnbox((Object)this.P.get()))}, new String[]{"       , ", ",  ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"%:\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{((ClassifierStats)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ClassifierStats.class)).rel(((Metrics)this.getDelegate()).getTN()), ((ClassifierStats)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ClassifierStats.class)).rel(((Metrics)this.getDelegate()).getFP())}, new String[]{", ", ", ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{((ClassifierStats)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ClassifierStats.class)).rel(((Metrics)this.getDelegate()).getFN()), ((ClassifierStats)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ClassifierStats.class)).rel(((Metrics)this.getDelegate()).getTP())}, new String[]{", ", ", ", "\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getACC())}, new String[]{"ACC:, ", ", accuracy\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(DefaultTypeTransformation.doubleUnbox((Object)this.P.get()))}, new String[]{"P:, ", ", precision / positive predictive value    ,,TP / (TP + FP)\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(DefaultTypeTransformation.doubleUnbox((Object)this.R.get()))}, new String[]{"R:, ", ", recall / sensitivity / true positive rate,,TP / (TP + FN)\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getNPV())}, new String[]{"NPV:, ", ", negative predictive value       ,,TN / (TN + FN)\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getSPC())}, new String[]{"SPC:, ", ", specificity / true negative rate,,TN / (TN + FP)\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)"\n");
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getTPX())}, new String[]{"TPX:, ", ", TP / (TP + FN + FP)\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getAUPRC())}, new String[]{"AUPRC:, ", ", area under PR curve\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getAUC())}, new String[]{"AUC:, ", ", area under ROC curve\n"}));
                StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getF1())}, new String[]{"F1:, ", ", f-measure\n"}));
                return StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class)), (Object)new GStringImpl(new Object[]{ClassifierStats.format(((Metrics)this.getDelegate()).getMCC())}, new String[]{"MCC:, ", ", Matthews correlation coefficient\n"}));
            }

            public StringBuilder getSb() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class);
            }

            public String getClassifierLabel() {
                return ShortTypeHandling.castToString((Object)this.classifierLabel.get());
            }

            public Double getR() {
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.R.get(), Double.class);
            }

            public Double getP() {
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.P.get(), Double.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toCSV_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.with((Object)this.metrics, (Closure)new _toCSV_closure1(this, this, sb, classifierLabel2, R, P));
        return ((StringBuilder)sb.get()).toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ClassifierStats.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Lorg/slf4j/Logger;)V")
    public static void write(String arg1, Logger arg2) {
        ScriptBytecodeAdapter.invokeMethodN(ClassifierStats.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{ClassifierStats.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;Ljava/lang/Throwable;)V")
    public static void writeError(String arg1, Throwable arg2) {
        ScriptBytecodeAdapter.invokeMethodN(ClassifierStats.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{ClassifierStats.class, arg1, arg2});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void write(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(ClassifierStats.class, Writable.Trait.Helper.class, (String)"write", (Object[])new Object[]{ClassifierStats.class, arg1});
    }

    @Traits.TraitBridge(traitClass=Writable.class, desc="(Ljava/lang/String;)V")
    public static void writeError(String arg1) {
        ScriptBytecodeAdapter.invokeMethodN(ClassifierStats.class, Writable.Trait.Helper.class, (String)"writeError", (Object[])new Object[]{ClassifierStats.class, arg1});
    }

    static {
        Logger logger;
        ClassifierStats.__$swapInit();
        BigDecimal bigDecimal = new BigDecimal("0.01");
        EPS = DefaultTypeTransformation.doubleUnbox((Object)bigDecimal);
        double[] dArray = new double[]{1.0, 0.0};
        HIST_0 = dArray;
        double[] dArray2 = new double[]{0.0, 1.0};
        HIST_1 = dArray2;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.prediction.metrics.ClassifierStats");
        Writable.Trait.Helper.$static$init$(ClassifierStats.class);
        Parametrized.Trait.Helper.$static$init$(ClassifierStats.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ClassifierStats.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ClassifierStats.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ClassifierStats.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ int pfaccess$0(ClassifierStats $that) {
        return HISTOGRAM_BINS;
    }

    public static /* synthetic */ int[][] pfaccess$1(ClassifierStats $that) {
        return $that.getOp();
    }

    public static /* synthetic */ int pfaccess$2(ClassifierStats $that) {
        return $that.getCount();
    }

    public static /* synthetic */ double pfaccess$3(ClassifierStats $that) {
        return $that.getSumE();
    }

    public static /* synthetic */ double pfaccess$4(ClassifierStats $that) {
        return $that.getSumEpos();
    }

    public static /* synthetic */ double pfaccess$5(ClassifierStats $that) {
        return $that.getSumEneg();
    }

    public static /* synthetic */ double pfaccess$6(ClassifierStats $that) {
        return $that.getSumSE();
    }

    public static /* synthetic */ double pfaccess$7(ClassifierStats $that) {
        return $that.getSumSEpos();
    }

    public static /* synthetic */ double pfaccess$8(ClassifierStats $that) {
        return $that.getSumSEneg();
    }

    public static /* synthetic */ double pfaccess$9(ClassifierStats $that) {
        return $that.getSumLogLoss();
    }

    public static /* synthetic */ boolean pfaccess$10(ClassifierStats $that) {
        return $that.getCollecting();
    }

    public static /* synthetic */ ArrayList<PPred> pfaccess$11(ClassifierStats $that) {
        return $that.getPredictions();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.01");
    }

    @Generated
    public static double getEPS() {
        return EPS;
    }

    @Generated
    public static int getHISTOGRAM_BINS() {
        return HISTOGRAM_BINS;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public int[][] getOp() {
        return this.op;
    }

    @Generated
    public void setOp(int[] ... nArray) {
        this.op = nArray;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public void setCount(int n) {
        this.count = n;
    }

    @Generated
    public int getNclasses() {
        return this.nclasses;
    }

    @Generated
    public void setNclasses(int n) {
        this.nclasses = n;
    }

    @Generated
    public double getSumE() {
        return this.sumE;
    }

    @Generated
    public void setSumE(double d) {
        this.sumE = d;
    }

    @Generated
    public double getSumEpos() {
        return this.sumEpos;
    }

    @Generated
    public void setSumEpos(double d) {
        this.sumEpos = d;
    }

    @Generated
    public double getSumEneg() {
        return this.sumEneg;
    }

    @Generated
    public void setSumEneg(double d) {
        this.sumEneg = d;
    }

    @Generated
    public double getSumSE() {
        return this.sumSE;
    }

    @Generated
    public void setSumSE(double d) {
        this.sumSE = d;
    }

    @Generated
    public double getSumSEpos() {
        return this.sumSEpos;
    }

    @Generated
    public void setSumSEpos(double d) {
        this.sumSEpos = d;
    }

    @Generated
    public double getSumSEneg() {
        return this.sumSEneg;
    }

    @Generated
    public void setSumSEneg(double d) {
        this.sumSEneg = d;
    }

    @Generated
    public double getSumLogLoss() {
        return this.sumLogLoss;
    }

    @Generated
    public void setSumLogLoss(double d) {
        this.sumLogLoss = d;
    }

    @Generated
    public Histograms getHistograms() {
        return this.histograms;
    }

    @Generated
    public void setHistograms(Histograms histograms) {
        this.histograms = histograms;
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    @Generated
    public boolean getCollecting() {
        return this.collecting;
    }

    @Generated
    public boolean isCollecting() {
        return this.collecting;
    }

    @Generated
    public void setCollecting(boolean bl) {
        this.collecting = bl;
    }

    @Generated
    public ArrayList<PPred> getPredictions() {
        return this.predictions;
    }

    @Generated
    public void setPredictions(ArrayList<PPred> arrayList) {
        this.predictions = arrayList;
    }

    public class Histograms
    implements GroovyObject {
        private Histogram score;
        private Histogram scoreNeg;
        private Histogram scorePos;
        private Histogram score0;
        private Histogram score1;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ ClassifierStats this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Histograms(ClassifierStats $p$) {
            MetaClass metaClass;
            Histogram histogram;
            Histogram histogram2;
            Histogram histogram3;
            Histogram histogram4;
            Histogram histogram5;
            ClassifierStats classifierStats;
            this.this$0 = classifierStats = $p$;
            this.score = histogram5 = new Histogram(0.0, 1.0, ClassifierStats.getHISTOGRAM_BINS());
            this.scoreNeg = histogram4 = new Histogram(0.0, 1.0, ClassifierStats.getHISTOGRAM_BINS());
            this.scorePos = histogram3 = new Histogram(0.0, 1.0, ClassifierStats.getHISTOGRAM_BINS());
            this.score0 = histogram2 = new Histogram(0.0, 1.0, ClassifierStats.getHISTOGRAM_BINS());
            this.score1 = histogram = new Histogram(0.0, 1.0, ClassifierStats.getHISTOGRAM_BINS());
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void add(Histograms others) {
            this.score.add(others.getScore());
            this.scoreNeg.add(others.getScoreNeg());
            this.scorePos.add(others.getScorePos());
            this.score0.add(others.getScore0());
            this.score1.add(others.getScore1());
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Histograms.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Histograms.class, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Histograms.class, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Histogram getScore() {
            return this.score;
        }

        @Generated
        public void setScore(Histogram histogram) {
            this.score = histogram;
        }

        @Generated
        public Histogram getScoreNeg() {
            return this.scoreNeg;
        }

        @Generated
        public void setScoreNeg(Histogram histogram) {
            this.scoreNeg = histogram;
        }

        @Generated
        public Histogram getScorePos() {
            return this.scorePos;
        }

        @Generated
        public void setScorePos(Histogram histogram) {
            this.scorePos = histogram;
        }

        @Generated
        public Histogram getScore0() {
            return this.score0;
        }

        @Generated
        public void setScore0(Histogram histogram) {
            this.score0 = histogram;
        }

        @Generated
        public Histogram getScore1() {
            return this.score1;
        }

        @Generated
        public void setScore1(Histogram histogram) {
            this.score1 = histogram;
        }
    }

    public class Metrics
    implements GroovyObject {
        private Advanced advanced;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ ClassifierStats this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Metrics(ClassifierStats $p$) {
            MetaClass metaClass;
            ClassifierStats classifierStats;
            this.this$0 = classifierStats = $p$;
            Object var3_3 = null;
            this.advanced = (Advanced)ScriptBytecodeAdapter.castToType(var3_3, Advanced.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public double getTP() {
            return BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.this$0.getOp(), (int)1), int[].class)), (int)1);
        }

        public double getFP() {
            return BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.this$0.getOp(), (int)0), int[].class)), (int)1);
        }

        public double getTN() {
            return BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.this$0.getOp(), (int)0), int[].class)), (int)0);
        }

        public double getFN() {
            return BytecodeInterface8.intArrayGet((int[])((int[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.this$0.getOp(), (int)1), int[].class)), (int)0);
        }

        public double getOP() {
            return this.getTP() + this.getFN();
        }

        public double getON() {
            return this.getFP() + this.getTN();
        }

        public double getPP() {
            return this.getTP() + this.getFP();
        }

        public double getPN() {
            return this.getTN() + this.getFN();
        }

        public double getOPON_ratio() {
            return this.this$0.div(this.getOP(), this.getON());
        }

        public double getPPPN_ratio() {
            return this.this$0.div(this.getPP(), this.getPN());
        }

        public double getP() {
            return this.this$0.div(this.getTP(), this.getTP() + this.getFP());
        }

        public double getR() {
            return this.this$0.div(this.getTP(), this.getTP() + this.getFN());
        }

        public double getF1() {
            return this.this$0.div((double)2 * (this.getP() * this.getR()), this.getP() + this.getR());
        }

        public double getF2() {
            return this.getFWeighted(2);
        }

        public double getF05() {
            return this.getFWeighted(0.5);
        }

        public double getMCC() {
            return this.this$0.calcMCC(this.getTP(), this.getFP(), this.getTN(), this.getFN());
        }

        public double getNPV() {
            return this.this$0.div(this.getTN(), this.getTN() + this.getFN());
        }

        public double getSPC() {
            return this.this$0.div(this.getTN(), this.getTN() + this.getFP());
        }

        public double getACC() {
            return this.this$0.div(this.getTP() + this.getTN(), this.this$0.getCount());
        }

        public double getBACC() {
            return (this.getR() + this.getSPC()) / (double)2;
        }

        public double getTPX() {
            return this.this$0.div(this.getTP(), this.getTP() + this.getFN() + this.getFP());
        }

        public double getLTP() {
            double d = -Math.log(this.getTP() / (this.getPP() * this.getOP()));
            try {
                return d;
            }
            catch (Exception e) {
                double d2 = Double.NaN;
                return d2;
            }
        }

        public double getFPR() {
            return this.this$0.div(this.getFP(), this.getFP() + this.getTN());
        }

        public double getFNR() {
            return this.this$0.div(this.getFN(), this.getTP() + this.getFN());
        }

        public double getPLR() {
            return this.this$0.div(this.getR(), this.getFPR());
        }

        public double getNLR() {
            return this.this$0.div(this.getFNR(), this.getSPC());
        }

        public double getDOR() {
            return this.this$0.div(this.getPLR(), this.getNLR());
        }

        public double getFDR() {
            return this.this$0.div(this.getFP(), this.getTP() + this.getFP());
        }

        public double getFOR() {
            return this.this$0.div(this.getFN(), this.getFN() + this.getTN());
        }

        public double getYJS() {
            return this.getR() + this.getSPC() - 1.0;
        }

        public double getMRK() {
            return this.getP() + this.getNPV() - 1.0;
        }

        public double getDPOW() {
            if (this.getR() == 1.0 || this.getSPC() == 1.0) {
                return Double.NaN;
            }
            double x = this.getR() / (1.0 - this.getR());
            double y = this.getSPC() / (1.0 - this.getSPC());
            double c = Math.sqrt(3) / Math.PI;
            return c * (Math.log(x) + Math.log(y));
        }

        public double getME() {
            return this.this$0.div(this.this$0.getSumE(), this.this$0.getCount());
        }

        public double getMEpos() {
            return this.this$0.div(this.this$0.getSumEpos(), this.this$0.getCount());
        }

        public double getMEneg() {
            return this.this$0.div(this.this$0.getSumEneg(), this.this$0.getCount());
        }

        public double getMEbalanced() {
            return (this.getMEneg() + this.getMEpos()) / (double)2;
        }

        public double getMSE() {
            return this.this$0.div(this.this$0.getSumSE(), this.this$0.getCount());
        }

        public double getMSEpos() {
            return this.this$0.div(this.this$0.getSumSEpos(), this.this$0.getCount());
        }

        public double getMSEneg() {
            return this.this$0.div(this.this$0.getSumSEneg(), this.this$0.getCount());
        }

        public double getMSEbalanced() {
            return (this.getMSEneg() + this.getMSEpos()) / (double)2;
        }

        public double getLogLoss() {
            return this.this$0.div(this.this$0.getSumLogLoss(), this.this$0.getCount());
        }

        public double getUC() {
            double L = (this.getOP() + this.getON()) * Math.log(this.getOP() + this.getON());
            double LTP = this.getTP() * Math.log(this.getTP() / (this.getPP() * this.getOP()));
            double LFP = this.getFP() * Math.log(this.getFP() / (this.getPP() * this.getON()));
            double LFN = this.getFN() * Math.log(this.getFN() / (this.getPN() * this.getOP()));
            double LTN = this.getTN() * Math.log(this.getTN() / (this.getPN() * this.getON()));
            double LP = this.getOP() * Math.log(this.getOP() / (double)this.this$0.getCount());
            double LN = this.getON() * Math.log(this.getON() / (double)this.this$0.getCount());
            double UC = (L + LTP + LFP + LFN + LTN) / (L + LP + LN);
            double d = UC;
            try {
                return d;
            }
            catch (Exception e) {
                double d2 = Double.NaN;
                return d2;
            }
        }

        public double getAUC() {
            if (this.advanced == null) {
                Advanced advanced;
                this.advanced = advanced = this.calculateAdvanced();
            }
            return this.advanced.getWekaAUC();
        }

        public double getAUPRC() {
            if (this.advanced == null) {
                Advanced advanced;
                this.advanced = advanced = this.calculateAdvanced();
            }
            return this.advanced.getWekaAUPRC();
        }

        private double getFWeighted(double beta) {
            double betaSqr = beta * beta;
            return this.this$0.div((1.0 + betaSqr) * this.getP() * this.getR(), this.getR() + betaSqr * this.getP());
        }

        public Map<String, Double> toMap() {
            Reference res = new Reference(new TreeMap());
            public final class _toMap_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _toMap_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Map.Entry)it).getValue() instanceof Double;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toMap_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _toMap_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference res;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _toMap_closure2(Object _outerInstance, Object _thisObject, Reference res) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.res = reference = res;
                }

                public Object doCall(Object it) {
                    return ((TreeMap)this.res.get()).put(ShortTypeHandling.castToString(((Map.Entry)it).getKey()).toUpperCase(), (Double)ScriptBytecodeAdapter.castToType(((Map.Entry)it).getValue(), Double.class));
                }

                public Map getRes() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.res.get(), Map.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toMap_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Map)DefaultGroovyMethods.findAll((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.getProperty("properties"), Map.class)), (Closure)new _toMap_closure1(this, this)), (Closure)new _toMap_closure2(this, this, res));
            return (TreeMap)res.get();
        }

        public Advanced calculateAdvanced() {
            Advanced res = new Advanced(this);
            if (this.this$0.getCollecting() && this.this$0.getPredictions() != null) {
                if (!this.this$0.getPredictions().isEmpty()) {
                    WekaStatsHelper wekaHelper = new WekaStatsHelper(this.this$0.getPredictions());
                    double d = wekaHelper.areaUnderROC();
                    res.setWekaAUC(d);
                    double d2 = wekaHelper.areaUnderPRC();
                    res.setWekaAUPRC(d2);
                    if (res.getWekaAUC() == Double.NaN) {
                        log.error("Calculated AUC is NaN");
                    }
                    if (res.getWekaAUPRC() == Double.NaN) {
                        log.error("Calculated AUPRC is NaN");
                    }
                    log.warn("AUC: {}", (Object)res.getWekaAUC());
                    log.warn("AUPRC: {}", (Object)res.getWekaAUPRC());
                } else {
                    log.error("Predictions are empty! Cannot calculate AUC and AUPRC stats.");
                }
            }
            return res;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Metrics.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Metrics.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Metrics.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(Metrics.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Metrics.class, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Metrics.class, ClassifierStats.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public class Advanced
        implements GroovyObject {
            private double wekaAUC;
            private double wekaAUPRC;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            public /* synthetic */ Metrics this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo$;

            public Advanced(Metrics $p$) {
                MetaClass metaClass;
                Metrics metrics;
                this.this$0 = metrics = $p$;
                double d = Double.NaN;
                this.wekaAUC = d;
                double d2 = Double.NaN;
                this.wekaAUPRC = d2;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != Advanced.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(Advanced.class, Metrics.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Metrics.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(Advanced.class, Metrics.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            @Generated
            public double getWekaAUC() {
                return this.wekaAUC;
            }

            @Generated
            public void setWekaAUC(double d) {
                this.wekaAUC = d;
            }

            @Generated
            public double getWekaAUPRC() {
                return this.wekaAUPRC;
            }

            @Generated
            public void setWekaAUPRC(double d) {
                this.wekaAUPRC = d;
            }
        }
    }
}

