/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom.samplers;

import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Box;
import cz.siret.prank.geom.samplers.PointSampler;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Random;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomPointSampler
extends PointSampler
implements Parametrized {
    private double MIN_DISTFROM_PROTEIN;
    private double MAX_DISTFROM_POCKET;
    private Random rand;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public RandomPointSampler(Protein protein) {
        super(protein);
        MetaClass metaClass;
        Random random;
        double d = this.getParams().getPoint_min_distfrom_protein();
        this.MIN_DISTFROM_PROTEIN = d;
        double d2 = this.getParams().getPoint_max_distfrom_pocket();
        this.MAX_DISTFROM_POCKET = d2;
        this.rand = random = new Random();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    public Atom randomPoint(Box box) {
        AtomImpl a = new AtomImpl();
        double d = this.randomFromRange(box.getMin().getX(), box.getMax().getX());
        a.setX(d);
        double d2 = this.randomFromRange(box.getMin().getY(), box.getMax().getY());
        a.setY(d2);
        double d3 = this.randomFromRange(box.getMin().getZ(), box.getMax().getZ());
        a.setZ(d3);
        return a;
    }

    @Override
    public Atoms samplePointsForPocket(Pocket pocket) {
        Object v3;
        int count = pocket.getSurfaceAtoms().getCount() * this.getParams().getSampling_multiplier();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            int n = count;
            valueRecorder.record((Object)n, 8);
            boolean bl = n > 0;
            valueRecorder.record((Object)bl, 13);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert count>0", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Atoms res = new Atoms();
        Box box = Box.aroundAtoms(pocket.getSurfaceAtoms());
        Atoms surroundingProteinAtoms = this.getProtein().getProteinAtoms().cutoutBox(box.enlarge(this.MIN_DISTFROM_PROTEIN));
        Atoms realSurfaceAtoms = this.getProtein().getProteinAtoms().cutoutShell(pocket.getSurfaceAtoms(), 1.0);
        int SAMPLING_TRIAL_LIMIT = count * 400;
        int i = 1;
        while (res.getCount() < count && i <= SAMPLING_TRIAL_LIMIT) {
            Atom ra = this.randomPoint(box);
            if (surroundingProteinAtoms.areDistantFromAtomAtLeast(ra, this.MIN_DISTFROM_PROTEIN) && realSurfaceAtoms.areWithinDistance(ra, this.MAX_DISTFROM_POCKET)) {
                res.add(ra);
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{res.getCount(), count, i}, new String[]{"Sampled ", "/", " points from ", " trials"})));
            v3 = null;
        } else {
            v3 = null;
        }
        return res;
    }

    public double randomFromRange(double min, double max) {
        return min + this.rand.nextDouble() * (max - min);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RandomPointSampler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(PointSampler.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.geom.samplers.RandomPointSampler");
        Parametrized.Trait.Helper.$static$init$(RandomPointSampler.class);
    }
}

