/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom.samplers;

import cz.siret.prank.domain.Pocket;
import cz.siret.prank.domain.Protein;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Box;
import cz.siret.prank.geom.Point;
import cz.siret.prank.geom.samplers.GridGenerator;
import cz.siret.prank.geom.samplers.PointSampler;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Iterator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridPointSampler
extends PointSampler
implements Parametrized {
    private static double BOX_MARGIN;
    private double MIN_DISTFROM_PROTEIN;
    private double MAX_DISTFROM_POCKET;
    private double CELL_EDGE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GridPointSampler(Protein protein) {
        super(protein);
        MetaClass metaClass;
        double d = this.getParams().getPoint_min_distfrom_protein();
        this.MIN_DISTFROM_PROTEIN = d;
        double d2 = this.getParams().getPoint_max_distfrom_pocket();
        this.MAX_DISTFROM_POCKET = d2;
        double d3 = this.getParams().getGrid_cell_edge();
        this.CELL_EDGE = d3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public Atoms samplePointsForPocket(Pocket pocket) {
        Object v1;
        Atoms res = new Atoms();
        Box box = Box.aroundAtoms(pocket.getSurfaceAtoms()).enlarge(BOX_MARGIN);
        this.getProtein().getProteinAtoms().withKdTreeConditional();
        Atoms surroundingProteinAtoms = this.getProtein().getProteinAtoms().cutoutBox(box.enlarge(this.MIN_DISTFROM_PROTEIN));
        Atoms realSurfaceAtoms = surroundingProteinAtoms.cutoutShell(pocket.getSurfaceAtoms(), 1.0);
        if (pocket.getSurfaceAtoms().getCount() != realSurfaceAtoms.getCount()) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pocket.getSurfaceAtoms().getCount(), realSurfaceAtoms.getCount()}, new String[]{"received pocket surface atoms != real surface atoms (", " != ", ")"})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        surroundingProteinAtoms.withKdTreeConditional();
        double sqrMinProteinDist = this.MIN_DISTFROM_PROTEIN * this.MIN_DISTFROM_PROTEIN;
        realSurfaceAtoms.withKdTreeConditional();
        double sqrMaxPocketDist = this.MAX_DISTFROM_POCKET * this.MAX_DISTFROM_POCKET;
        GridGenerator grid = new GridGenerator(box, this.CELL_EDGE);
        Point p = null;
        Iterator<Point> iterator = grid.iterator();
        while (iterator.hasNext()) {
            p = (Point)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Point.class);
            if (!(realSurfaceAtoms.sqrDist(p) <= sqrMaxPocketDist) || !(!(surroundingProteinAtoms.sqrDist(p) < sqrMinProteinDist))) continue;
            res.add(p.copy());
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{res.getCount(), grid.getCount()}, new String[]{"Sampled ", " out of ", " grid points"})));
            v1 = null;
        } else {
            v1 = null;
        }
        return res;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GridPointSampler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(PointSampler.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        int n = 3;
        BOX_MARGIN = n;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.geom.samplers.GridPointSampler");
        Parametrized.Trait.Helper.$static$init$(GridPointSampler.class);
    }
}

