/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom.samplers;

import cz.siret.prank.geom.Box;
import cz.siret.prank.geom.Point;
import java.util.Iterator;

public class GridGenerator
implements Iterable<Point> {
    private double edge;
    private double originX;
    private double originY;
    private double originZ;
    private int nx;
    private int ny;
    private int nz;

    private GridGenerator() {
    }

    public GridGenerator(double edge, double originX, double originY, double originZ, int nx, int ny, int nz) {
        this.edge = edge;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
    }

    public static double shift(double min, double max, double edge) {
        return min + Math.IEEEremainder(max - min, edge);
    }

    public GridGenerator(Box box, double edge) {
        this.edge = edge;
        this.originX = GridGenerator.shift(box.getMin().getX(), box.getMax().getX(), edge);
        this.originY = GridGenerator.shift(box.getMin().getY(), box.getMax().getY(), edge);
        this.originZ = GridGenerator.shift(box.getMin().getZ(), box.getMax().getZ(), edge);
        this.nx = (int)(box.getWx() / edge);
        this.ny = (int)(box.getWy() / edge);
        this.nz = (int)(box.getWz() / edge);
    }

    public int getCount() {
        return this.nx * this.ny * this.nz;
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            private Point resPoint = new Point();
            private int x = 0;
            private int y = 0;
            private int z = 0;

            @Override
            public boolean hasNext() {
                return this.z < GridGenerator.this.nz;
            }

            @Override
            public Point next() {
                this.resPoint.setXYZ(GridGenerator.this.originX + (double)this.x * GridGenerator.this.edge, GridGenerator.this.originY + (double)this.y * GridGenerator.this.edge, GridGenerator.this.originZ + (double)this.z * GridGenerator.this.edge);
                ++this.x;
                if (this.x >= GridGenerator.this.nx) {
                    this.x = 0;
                    ++this.y;
                    if (this.y >= GridGenerator.this.ny) {
                        this.y = 0;
                        ++this.z;
                    }
                }
                return this.resPoint;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Point> iteratorSnake() {
        return new Iterator<Point>(){
            private Point resPoint = new Point();
            private int x = 0;
            private int y = 0;
            private int z = 0;
            private int xinc = 1;
            private int yinc = 1;

            @Override
            public boolean hasNext() {
                return this.z < GridGenerator.this.nz;
            }

            @Override
            public Point next() {
                this.resPoint.setXYZ(GridGenerator.this.originX + (double)this.x * GridGenerator.this.edge, GridGenerator.this.originY + (double)this.y * GridGenerator.this.edge, GridGenerator.this.originZ + (double)this.z * GridGenerator.this.edge);
                this.x += this.xinc;
                if (this.x >= GridGenerator.this.nx || this.x < 0) {
                    this.xinc *= -1;
                    this.x += this.xinc;
                    this.y += this.yinc;
                    if (this.y >= GridGenerator.this.ny || this.y < 0) {
                        this.yinc *= -1;
                        this.y += this.yinc;
                        ++this.z;
                    }
                }
                return this.resPoint;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

