/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom.kdtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class KdTree<T> {
    private static final int bucketSize = 24;
    private final int dimensions;
    private final KdTree<T> parent;
    private final LinkedList<double[]> locationStack;
    private final Integer sizeLimit;
    private double[][] locations;
    private Object[] data;
    private int locationCount;
    private KdTree<T> left;
    private KdTree<T> right;
    private int splitDimension;
    private double splitValue;
    private double[] minLimit;
    private double[] maxLimit;
    private boolean singularity;
    private Status status;

    private KdTree(int dimensions, Integer sizeLimit) {
        this.dimensions = dimensions;
        this.locations = new double[24][];
        this.data = new Object[24];
        this.locationCount = 0;
        this.singularity = true;
        this.parent = null;
        this.sizeLimit = sizeLimit;
        this.locationStack = sizeLimit != null ? new LinkedList() : null;
    }

    private KdTree(KdTree<T> parent, boolean right) {
        this.dimensions = parent.dimensions;
        this.locations = new double[Math.max(24, parent.locationCount)][];
        this.data = new Object[Math.max(24, parent.locationCount)];
        this.locationCount = 0;
        this.singularity = true;
        this.parent = parent;
        this.locationStack = null;
        this.sizeLimit = null;
    }

    public int size() {
        return this.locationCount;
    }

    public void addPoint(double[] location, T value) {
        KdTree<T> cursor = this;
        while (cursor.locations == null || cursor.locationCount >= cursor.locations.length) {
            if (cursor.locations != null) {
                cursor.splitDimension = cursor.findWidestAxis();
                cursor.splitValue = (cursor.minLimit[cursor.splitDimension] + cursor.maxLimit[cursor.splitDimension]) * 0.5;
                if (cursor.splitValue == Double.POSITIVE_INFINITY) {
                    cursor.splitValue = Double.MAX_VALUE;
                } else if (cursor.splitValue == Double.NEGATIVE_INFINITY) {
                    cursor.splitValue = -1.7976931348623157E308;
                } else if (Double.isNaN(cursor.splitValue)) {
                    cursor.splitValue = 0.0;
                }
                if (cursor.minLimit[cursor.splitDimension] == cursor.maxLimit[cursor.splitDimension]) {
                    double[][] newLocations = new double[cursor.locations.length * 2][];
                    System.arraycopy(cursor.locations, 0, newLocations, 0, cursor.locationCount);
                    cursor.locations = newLocations;
                    Object[] newData = new Object[newLocations.length];
                    System.arraycopy(cursor.data, 0, newData, 0, cursor.locationCount);
                    cursor.data = newData;
                    break;
                }
                if (cursor.splitValue == cursor.maxLimit[cursor.splitDimension]) {
                    cursor.splitValue = cursor.minLimit[cursor.splitDimension];
                }
                ChildNode left = new ChildNode(cursor, false);
                ChildNode right = new ChildNode(cursor, true);
                for (int i = 0; i < cursor.locationCount; ++i) {
                    double[] oldLocation = cursor.locations[i];
                    Object oldData = cursor.data[i];
                    if (oldLocation[cursor.splitDimension] > cursor.splitValue) {
                        right.locations[right.locationCount] = oldLocation;
                        right.data[right.locationCount] = oldData;
                        ++right.locationCount;
                        super.extendBounds(oldLocation);
                        continue;
                    }
                    left.locations[left.locationCount] = oldLocation;
                    left.data[left.locationCount] = oldData;
                    ++left.locationCount;
                    super.extendBounds(oldLocation);
                }
                cursor.left = left;
                cursor.right = right;
                cursor.locations = null;
                cursor.data = null;
            }
            ++cursor.locationCount;
            cursor.extendBounds(location);
            if (location[cursor.splitDimension] > cursor.splitValue) {
                cursor = cursor.right;
                continue;
            }
            cursor = cursor.left;
        }
        cursor.locations[cursor.locationCount] = location;
        cursor.data[cursor.locationCount] = value;
        ++cursor.locationCount;
        super.extendBounds(location);
        if (this.sizeLimit != null) {
            this.locationStack.add(location);
            if (this.locationCount > this.sizeLimit) {
                super.removeOld();
            }
        }
    }

    private final void extendBounds(double[] location) {
        if (this.minLimit == null) {
            this.minLimit = new double[this.dimensions];
            System.arraycopy(location, 0, this.minLimit, 0, this.dimensions);
            this.maxLimit = new double[this.dimensions];
            System.arraycopy(location, 0, this.maxLimit, 0, this.dimensions);
            return;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (Double.isNaN(location[i])) {
                this.minLimit[i] = Double.NaN;
                this.maxLimit[i] = Double.NaN;
                this.singularity = false;
                continue;
            }
            if (this.minLimit[i] > location[i]) {
                this.minLimit[i] = location[i];
                this.singularity = false;
                continue;
            }
            if (!(this.maxLimit[i] < location[i])) continue;
            this.maxLimit[i] = location[i];
            this.singularity = false;
        }
    }

    private final int findWidestAxis() {
        int widest = 0;
        double width = (this.maxLimit[0] - this.minLimit[0]) * this.getAxisWeightHint(0);
        if (Double.isNaN(width)) {
            width = 0.0;
        }
        for (int i = 1; i < this.dimensions; ++i) {
            double nwidth = (this.maxLimit[i] - this.minLimit[i]) * this.getAxisWeightHint(i);
            if (Double.isNaN(nwidth)) {
                nwidth = 0.0;
            }
            if (!(nwidth > width)) continue;
            widest = i;
            width = nwidth;
        }
        return widest;
    }

    private void removeOld() {
        double[] location = this.locationStack.removeFirst();
        KdTree<T> cursor = this;
        while (cursor.locations == null) {
            if (location[cursor.splitDimension] > cursor.splitValue) {
                cursor = cursor.right;
                continue;
            }
            cursor = cursor.left;
        }
        for (int i = 0; i < cursor.locationCount; ++i) {
            if (cursor.locations[i] != location) continue;
            System.arraycopy(cursor.locations, i + 1, cursor.locations, i, cursor.locationCount - i - 1);
            cursor.locations[cursor.locationCount - 1] = null;
            System.arraycopy(cursor.data, i + 1, cursor.data, i, cursor.locationCount - i - 1);
            cursor.data[cursor.locationCount - 1] = null;
            do {
                --cursor.locationCount;
            } while ((cursor = cursor.parent) != null);
            return;
        }
    }

    public List<Entry<T>> nearestNeighbor(double[] location, int count, boolean sequentialSorting) {
        KdTree<T> cursor = this;
        cursor.status = Status.NONE;
        double range = Double.POSITIVE_INFINITY;
        ResultHeap resultHeap = new ResultHeap(count);
        do {
            if (cursor.status == Status.ALLVISITED) {
                cursor = cursor.parent;
                continue;
            }
            if (cursor.status == Status.NONE && cursor.locations != null) {
                if (cursor.locationCount > 0) {
                    if (cursor.singularity) {
                        double dist = this.pointDist(cursor.locations[0], location);
                        if (dist <= range) {
                            for (int i = 0; i < cursor.locationCount; ++i) {
                                resultHeap.addValue(dist, cursor.data[i]);
                            }
                        }
                    } else {
                        for (int i = 0; i < cursor.locationCount; ++i) {
                            double dist = this.pointDist(cursor.locations[i], location);
                            resultHeap.addValue(dist, cursor.data[i]);
                        }
                    }
                    range = resultHeap.getMaxDist();
                }
                if (cursor.parent == null) break;
                cursor = cursor.parent;
                continue;
            }
            KdTree<T> nextCursor = null;
            if (cursor.status == Status.NONE) {
                if (location[cursor.splitDimension] > cursor.splitValue) {
                    nextCursor = cursor.right;
                    cursor.status = Status.RIGHTVISITED;
                } else {
                    nextCursor = cursor.left;
                    cursor.status = Status.LEFTVISITED;
                }
            } else if (cursor.status == Status.LEFTVISITED) {
                nextCursor = cursor.right;
                cursor.status = Status.ALLVISITED;
            } else if (cursor.status == Status.RIGHTVISITED) {
                nextCursor = cursor.left;
                cursor.status = Status.ALLVISITED;
            }
            if (cursor.status == Status.ALLVISITED && (nextCursor.locationCount == 0 || !nextCursor.singularity && this.pointRegionDist(location, nextCursor.minLimit, nextCursor.maxLimit) > range)) continue;
            cursor = nextCursor;
            cursor.status = Status.NONE;
        } while (cursor.parent != null || cursor.status != Status.ALLVISITED);
        ArrayList<Entry<T>> results = new ArrayList<Entry<T>>(resultHeap.values);
        if (sequentialSorting) {
            while (resultHeap.values > 0) {
                resultHeap.removeLargest();
                results.add(new Entry(resultHeap.removedDist, resultHeap.removedData));
            }
        } else {
            for (int i = 0; i < resultHeap.values; ++i) {
                results.add(new Entry(resultHeap.distance[i], resultHeap.data[i]));
            }
        }
        return results;
    }

    public List<Entry<T>> neighboursWithinRadius(double[] location, double radius, boolean sequentialSorting) {
        KdTree<T> cursor = this;
        cursor.status = Status.NONE;
        double range = radius;
        ArrayList<Entry<T>> resultHeap = new ArrayList<Entry<T>>();
        do {
            if (cursor.status == Status.ALLVISITED) {
                cursor = cursor.parent;
                continue;
            }
            if (cursor.status == Status.NONE && cursor.locations != null) {
                if (cursor.locationCount > 0) {
                    if (cursor.singularity) {
                        double dist = this.pointDist(cursor.locations[0], location);
                        if (dist <= radius) {
                            for (int i = 0; i < cursor.locationCount; ++i) {
                                resultHeap.add(new Entry(dist, cursor.data[i]));
                            }
                        }
                    } else {
                        for (int i = 0; i < cursor.locationCount; ++i) {
                            double dist = this.pointDist(cursor.locations[i], location);
                            if (!(dist <= radius)) continue;
                            resultHeap.add(new Entry(dist, cursor.data[i]));
                        }
                    }
                }
                if (cursor.parent == null) break;
                cursor = cursor.parent;
                continue;
            }
            KdTree<T> nextCursor = null;
            if (cursor.status == Status.NONE) {
                if (location[cursor.splitDimension] > cursor.splitValue) {
                    nextCursor = cursor.right;
                    cursor.status = Status.RIGHTVISITED;
                } else {
                    nextCursor = cursor.left;
                    cursor.status = Status.LEFTVISITED;
                }
            } else if (cursor.status == Status.LEFTVISITED) {
                nextCursor = cursor.right;
                cursor.status = Status.ALLVISITED;
            } else if (cursor.status == Status.RIGHTVISITED) {
                nextCursor = cursor.left;
                cursor.status = Status.ALLVISITED;
            }
            if (cursor.status == Status.ALLVISITED && (nextCursor.locationCount == 0 || !nextCursor.singularity && this.pointRegionDist(location, nextCursor.minLimit, nextCursor.maxLimit) > range)) continue;
            cursor = nextCursor;
            cursor.status = Status.NONE;
        } while (cursor.parent != null || cursor.status != Status.ALLVISITED);
        ArrayList<Entry<T>> results = resultHeap;
        if (sequentialSorting) {
            results.sort(Comparator.comparing(e -> e.distance));
        }
        return results;
    }

    public Entry<T> singleNearestNeighbor(double[] location) {
        KdTree<T> cursor = this;
        cursor.status = Status.NONE;
        double range = Double.POSITIVE_INFINITY;
        Object result = null;
        double resDist = Double.POSITIVE_INFINITY;
        do {
            if (cursor.status == Status.ALLVISITED) {
                cursor = cursor.parent;
                continue;
            }
            if (cursor.status == Status.NONE && cursor.locations != null) {
                if (cursor.locationCount > 0) {
                    if (cursor.singularity) {
                        double dist = this.pointDist(cursor.locations[0], location);
                        if (dist <= range) {
                            for (int i = 0; i < cursor.locationCount; ++i) {
                                if (!(dist < resDist)) continue;
                                resDist = dist;
                                result = cursor.data[i];
                            }
                        }
                    } else {
                        for (int i = 0; i < cursor.locationCount; ++i) {
                            double dist = this.pointDist(cursor.locations[i], location);
                            if (!(dist < resDist)) continue;
                            resDist = dist;
                            result = cursor.data[i];
                        }
                    }
                    range = resDist;
                }
                if (cursor.parent == null) break;
                cursor = cursor.parent;
                continue;
            }
            KdTree<T> nextCursor = null;
            if (cursor.status == Status.NONE) {
                if (location[cursor.splitDimension] > cursor.splitValue) {
                    nextCursor = cursor.right;
                    cursor.status = Status.RIGHTVISITED;
                } else {
                    nextCursor = cursor.left;
                    cursor.status = Status.LEFTVISITED;
                }
            } else if (cursor.status == Status.LEFTVISITED) {
                nextCursor = cursor.right;
                cursor.status = Status.ALLVISITED;
            } else if (cursor.status == Status.RIGHTVISITED) {
                nextCursor = cursor.left;
                cursor.status = Status.ALLVISITED;
            }
            if (cursor.status == Status.ALLVISITED && (nextCursor.locationCount == 0 || !nextCursor.singularity && this.pointRegionDist(location, nextCursor.minLimit, nextCursor.maxLimit) > range)) continue;
            cursor = nextCursor;
            cursor.status = Status.NONE;
        } while (cursor.parent != null || cursor.status != Status.ALLVISITED);
        return new Entry(resDist, result);
    }

    protected abstract double pointDist(double[] var1, double[] var2);

    protected abstract double pointRegionDist(double[] var1, double[] var2, double[] var3);

    protected double getAxisWeightHint(int i) {
        return 1.0;
    }

    private static class ResultHeap {
        private final Object[] data;
        private final double[] distance;
        private final int size;
        private int values;
        public Object removedData;
        public double removedDist;

        public ResultHeap(int size) {
            this.data = new Object[size];
            this.distance = new double[size];
            this.size = size;
            this.values = 0;
        }

        public void addValue(double dist, Object value) {
            if (this.values < this.size) {
                this.data[this.values] = value;
                this.distance[this.values] = dist;
                this.upHeapify(this.values);
                ++this.values;
            } else if (dist < this.distance[0]) {
                this.data[0] = value;
                this.distance[0] = dist;
                this.downHeapify(0);
            }
        }

        public void removeLargest() {
            if (this.values == 0) {
                throw new IllegalStateException();
            }
            this.removedData = this.data[0];
            this.removedDist = this.distance[0];
            --this.values;
            this.data[0] = this.data[this.values];
            this.distance[0] = this.distance[this.values];
            this.downHeapify(0);
        }

        private void upHeapify(int c) {
            int p = (c - 1) / 2;
            while (c != 0 && this.distance[c] > this.distance[p]) {
                Object pData = this.data[p];
                double pDist = this.distance[p];
                this.data[p] = this.data[c];
                this.distance[p] = this.distance[c];
                this.data[c] = pData;
                this.distance[c] = pDist;
                c = p;
                p = (c - 1) / 2;
            }
        }

        private void downHeapify(int p) {
            int c = p * 2 + 1;
            while (c < this.values) {
                if (c + 1 < this.values && this.distance[c] < this.distance[c + 1]) {
                    ++c;
                }
                if (!(this.distance[p] < this.distance[c])) break;
                Object pData = this.data[p];
                double pDist = this.distance[p];
                this.data[p] = this.data[c];
                this.distance[p] = this.distance[c];
                this.data[c] = pData;
                this.distance[c] = pDist;
                p = c;
                c = p * 2 + 1;
            }
        }

        public double getMaxDist() {
            if (this.values < this.size) {
                return Double.POSITIVE_INFINITY;
            }
            return this.distance[0];
        }
    }

    public static class Manhattan<T>
    extends KdTree<T> {
        public Manhattan(int dimensions, Integer sizeLimit) {
            super(dimensions, sizeLimit);
        }

        @Override
        protected double pointDist(double[] p1, double[] p2) {
            double d = 0.0;
            for (int i = 0; i < p1.length; ++i) {
                double diff = p1[i] - p2[i];
                if (Double.isNaN(diff)) continue;
                d += diff < 0.0 ? -diff : diff;
            }
            return d;
        }

        @Override
        protected double pointRegionDist(double[] point, double[] min, double[] max) {
            double d = 0.0;
            for (int i = 0; i < point.length; ++i) {
                double diff = 0.0;
                if (point[i] > max[i]) {
                    diff = point[i] - max[i];
                } else if (point[i] < min[i]) {
                    diff = min[i] - point[i];
                }
                if (Double.isNaN(diff)) continue;
                d += diff;
            }
            return d;
        }
    }

    public static class WeightedManhattan<T>
    extends KdTree<T> {
        private double[] weights;

        public WeightedManhattan(int dimensions, Integer sizeLimit) {
            super(dimensions, sizeLimit);
            this.weights = new double[dimensions];
            Arrays.fill(this.weights, 1.0);
        }

        public void setWeights(double[] weights) {
            this.weights = weights;
        }

        @Override
        protected double getAxisWeightHint(int i) {
            return this.weights[i];
        }

        @Override
        protected double pointDist(double[] p1, double[] p2) {
            double d = 0.0;
            for (int i = 0; i < p1.length; ++i) {
                double diff = p1[i] - p2[i];
                if (Double.isNaN(diff)) continue;
                d += (diff < 0.0 ? -diff : diff) * this.weights[i];
            }
            return d;
        }

        @Override
        protected double pointRegionDist(double[] point, double[] min, double[] max) {
            double d = 0.0;
            for (int i = 0; i < point.length; ++i) {
                double diff = 0.0;
                if (point[i] > max[i]) {
                    diff = point[i] - max[i];
                } else if (point[i] < min[i]) {
                    diff = min[i] - point[i];
                }
                if (Double.isNaN(diff)) continue;
                d += diff * this.weights[i];
            }
            return d;
        }
    }

    public static class SqrEuclid<T>
    extends KdTree<T> {
        public SqrEuclid(int dimensions, Integer sizeLimit) {
            super(dimensions, sizeLimit);
        }

        @Override
        protected double pointDist(double[] p1, double[] p2) {
            double d = 0.0;
            for (int i = 0; i < p1.length; ++i) {
                double diff = p1[i] - p2[i];
                if (Double.isNaN(diff)) continue;
                d += diff * diff;
            }
            return d;
        }

        @Override
        protected double pointRegionDist(double[] point, double[] min, double[] max) {
            double d = 0.0;
            for (int i = 0; i < point.length; ++i) {
                double diff = 0.0;
                if (point[i] > max[i]) {
                    diff = point[i] - max[i];
                } else if (point[i] < min[i]) {
                    diff = point[i] - min[i];
                }
                if (Double.isNaN(diff)) continue;
                d += diff * diff;
            }
            return d;
        }
    }

    public static class WeightedSqrEuclid<T>
    extends KdTree<T> {
        private double[] weights;

        public WeightedSqrEuclid(int dimensions, Integer sizeLimit) {
            super(dimensions, sizeLimit);
            this.weights = new double[dimensions];
            Arrays.fill(this.weights, 1.0);
        }

        public void setWeights(double[] weights) {
            this.weights = weights;
        }

        @Override
        protected double getAxisWeightHint(int i) {
            return this.weights[i];
        }

        @Override
        protected double pointDist(double[] p1, double[] p2) {
            double d = 0.0;
            for (int i = 0; i < p1.length; ++i) {
                double diff = (p1[i] - p2[i]) * this.weights[i];
                if (Double.isNaN(diff)) continue;
                d += diff * diff;
            }
            return d;
        }

        @Override
        protected double pointRegionDist(double[] point, double[] min, double[] max) {
            double d = 0.0;
            for (int i = 0; i < point.length; ++i) {
                double diff = 0.0;
                if (point[i] > max[i]) {
                    diff = (point[i] - max[i]) * this.weights[i];
                } else if (point[i] < min[i]) {
                    diff = (point[i] - min[i]) * this.weights[i];
                }
                if (Double.isNaN(diff)) continue;
                d += diff * diff;
            }
            return d;
        }
    }

    private class ChildNode
    extends KdTree<T> {
        private ChildNode(KdTree<T> parent, boolean right) {
            super(parent, right);
        }

        @Override
        protected double pointDist(double[] p1, double[] p2) {
            throw new IllegalStateException();
        }

        @Override
        protected double pointRegionDist(double[] point, double[] min, double[] max) {
            throw new IllegalStateException();
        }
    }

    public static class Entry<T> {
        public final double distance;
        public final T value;

        private Entry(double distance, T value) {
            this.distance = distance;
            this.value = value;
        }
    }

    private static enum Status {
        NONE,
        LEFTVISITED,
        RIGHTVISITED,
        ALLVISITED;

    }
}

