/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom;

import cz.siret.prank.geom.Atoms;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.CdkUtils;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.math.BigDecimal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.openscience.cdk.geometry.surface.NumericalSurface;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surface
implements Parametrized,
GroovyObject {
    public static final double CONSOLIDATE_DIST;
    public final double VAN_DER_WAALS_COMPENSATION;
    private Atoms points;
    private double surfaceArea;
    private double solventRadius;
    private int tesslevel;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Surface(double surfaceArea, Atoms surfacePoints, double solventRadius, int tesslevel) {
        int n;
        Atoms atoms;
        MetaClass metaClass;
        double d = this.getParams().getSurface_additional_cutoff();
        this.VAN_DER_WAALS_COMPENSATION = d;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
        double d2 = surfaceArea;
        this.surfaceArea = d2;
        this.points = atoms = surfacePoints;
        double d3 = solventRadius;
        this.solventRadius = d3;
        this.tesslevel = n = tesslevel;
    }

    public Atoms computeExposedAtoms(Atoms proteinAtoms) {
        return proteinAtoms.cutoutShell(this.points, this.solventRadius + this.VAN_DER_WAALS_COMPENSATION);
    }

    public static Surface computeAccessibleSurface(Atoms proteinAtoms, double solventRadius, int tesslevel) {
        Object v2;
        Atoms atoms;
        Object v1;
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(StringGroovyMethods.plus((CharSequence)"proteinAtoms.count:", (Object)proteinAtoms.getCount()));
            v0 = null;
        } else {
            v0 = null;
        }
        IAtomContainer container = CdkUtils.toAtomContainer(proteinAtoms);
        NumericalSurface numericalSurface = new NumericalSurface(container, solventRadius, tesslevel);
        numericalSurface.calculateSurface();
        Atoms surfacePoints = CdkUtils.toAtomPoints(numericalSurface.getAllSurfacePoints());
        if (log.isDebugEnabled()) {
            log.debug("numerical surface: {} points", (Object)surfacePoints.getCount());
            v1 = null;
        } else {
            v1 = null;
        }
        surfacePoints = atoms = Atoms.consolidate(surfacePoints, CONSOLIDATE_DIST);
        if (log.isDebugEnabled()) {
            log.debug("surface after consolidation: {} points", (Object)surfacePoints.getCount());
            v2 = null;
        } else {
            v2 = null;
        }
        Surface res = new Surface(numericalSurface.getTotalSurfaceArea(), surfacePoints, solventRadius, tesslevel);
        return res;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Surface.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        Surface.__$swapInit();
        BigDecimal bigDecimal = new BigDecimal("0.05");
        CONSOLIDATE_DIST = DefaultTypeTransformation.doubleUnbox((Object)bigDecimal);
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.geom.Surface");
        Parametrized.Trait.Helper.$static$init$(Surface.class);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.05");
    }

    @Generated
    public Atoms getPoints() {
        return this.points;
    }

    @Generated
    public void setPoints(Atoms atoms) {
        this.points = atoms;
    }

    @Generated
    public double getSurfaceArea() {
        return this.surfaceArea;
    }

    @Generated
    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    @Generated
    public double getSolventRadius() {
        return this.solventRadius;
    }

    @Generated
    public void setSolventRadius(double d) {
        this.solventRadius = d;
    }

    @Generated
    public int getTesslevel() {
        return this.tesslevel;
    }

    @Generated
    public void setTesslevel(int n) {
        this.tesslevel = n;
    }
}

