/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom;

import com.google.common.collect.ComparisonChain;
import cz.siret.prank.domain.Residue;
import cz.siret.prank.domain.ResidueChain;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Box;
import cz.siret.prank.geom.clustering.AtomClusterer;
import cz.siret.prank.geom.clustering.AtomGroupClusterer;
import cz.siret.prank.geom.clustering.SLinkClusterer;
import cz.siret.prank.utils.PerfUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Struct
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Struct() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static double dist(Atom a, Atom b) {
        return PerfUtils.dist(a.getCoords(), b.getCoords());
    }

    public static double sqrDist(Atom a, Atom b) {
        return PerfUtils.sqrDist(a.getCoords(), b.getCoords());
    }

    public static double dist(Atom a, List<Atom> list) {
        if (list == null || list.isEmpty()) {
            return Double.MAX_VALUE;
        }
        double sqrDist = Struct.sqrDist(a, list);
        return Math.sqrt(sqrDist);
    }

    public static double sqrDist(Atom a, List<Atom> list) {
        return PerfUtils.sqrDistL(a, list);
    }

    public static double dist(List<Atom> list1, List<Atom> list2) {
        Reference list22 = new Reference(list2);
        if (list1 == null || list1.isEmpty()) {
            return Double.MAX_VALUE;
        }
        public final class _dist_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference list2;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _dist_closure1(Object _outerInstance, Object _thisObject, Reference list2) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.list2 = reference = list2;
            }

            public Object doCall(Atom a) {
                return Struct.dist(a, (List<Atom>)((List)ScriptBytecodeAdapter.castToType((Object)this.list2.get(), List.class)));
            }

            public Object call(Atom a) {
                return this.doCall(a);
            }

            public List getList2() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.list2.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _dist_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.doubleUnbox((Object)DefaultGroovyMethods.min((Iterable)DefaultGroovyMethods.collect(list1, (Closure)new _dist_closure1(Struct.class, Struct.class, list22))));
    }

    public static boolean areWithinDistance(Atom a, List<Atom> list, double dis) {
        double d;
        dis = d = dis * dis;
        Atom b = null;
        Iterator<Atom> iterator = list.iterator();
        while (iterator.hasNext()) {
            b = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            if (!(Struct.sqrDist(a, b) <= dis)) continue;
            return true;
        }
        return false;
    }

    public static boolean areDistantAtLeast(Atom a, List<Atom> list, double dis) {
        double d;
        dis = d = dis * dis;
        Atom b = null;
        Iterator<Atom> iterator = list.iterator();
        while (iterator.hasNext()) {
            b = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            if (!(Struct.sqrDist(a, b) < dis)) continue;
            return false;
        }
        return true;
    }

    public static boolean areWithinDistance(List<Atom> list1, List<Atom> list2, double dis) {
        double d;
        dis = d = dis * dis;
        Atom a = null;
        Iterator<Atom> iterator = list1.iterator();
        while (iterator.hasNext()) {
            a = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Atom.class);
            Atom b = null;
            Iterator<Atom> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                b = (Atom)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Atom.class);
                if (!(Struct.sqrDist(a, b) <= dis)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Atom> cutoffAtoms(List<Atom> chooseFrom, List<Atom> distanceTo, double cutoffDist) {
        Reference distanceTo2 = new Reference(distanceTo);
        Reference cutoffDist2 = new Reference((Object)cutoffDist);
        public final class _cutoffAtoms_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference distanceTo;
            private /* synthetic */ Reference cutoffDist;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cutoffAtoms_closure2(Object _outerInstance, Object _thisObject, Reference distanceTo, Reference cutoffDist) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.distanceTo = reference2 = distanceTo;
                this.cutoffDist = reference = cutoffDist;
            }

            public Object doCall(Atom a) {
                return Struct.areWithinDistance(a, (List<Atom>)((List)ScriptBytecodeAdapter.castToType((Object)this.distanceTo.get(), List.class)), DefaultTypeTransformation.doubleUnbox((Object)this.cutoffDist.get()));
            }

            public Object call(Atom a) {
                return this.doCall(a);
            }

            public List getDistanceTo() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.distanceTo.get(), List.class);
            }

            public double getCutoffDist() {
                return DefaultTypeTransformation.doubleUnbox((Object)this.cutoffDist.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cutoffAtoms_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(chooseFrom, (Closure)new _cutoffAtoms_closure2(Struct.class, Struct.class, distanceTo2, cutoffDist2)));
    }

    public static boolean isInBox(Atom a, Box box) {
        if (!(a.getX() <= box.getMax().getX()) || a.getX() < box.getMin().getX()) {
            return false;
        }
        if (!(a.getY() <= box.getMax().getY()) || a.getY() < box.getMin().getY()) {
            return false;
        }
        return !(!(a.getZ() <= box.getMax().getZ()) || a.getZ() < box.getMin().getZ());
    }

    public static List<Atom> cutoffAtomsInBox(List<Atom> chooseFrom, Box box) {
        Reference box2 = new Reference((Object)box);
        public final class _cutoffAtomsInBox_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference box;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cutoffAtomsInBox_closure3(Object _outerInstance, Object _thisObject, Reference box) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.box = reference = box;
            }

            public Object doCall(Atom a) {
                return Struct.isInBox(a, (Box)ScriptBytecodeAdapter.castToType((Object)this.box.get(), Box.class));
            }

            public Object call(Atom a) {
                return this.doCall(a);
            }

            public Box getBox() {
                return (Box)ScriptBytecodeAdapter.castToType((Object)this.box.get(), Box.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cutoffAtomsInBox_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(chooseFrom, (Closure)new _cutoffAtomsInBox_closure3(Struct.class, Struct.class, box2)));
    }

    public static boolean isHydrogenAtom(Atom atom) {
        if (ScriptBytecodeAdapter.compareEqual((Object)Element.H, (Object)atom.getElement())) {
            return true;
        }
        if (atom.getName().startsWith("H")) {
            return true;
        }
        return atom.getName().length() > 1 && ScriptBytecodeAdapter.compareEqual((Object)StringGroovyMethods.getAt((String)atom.getName(), (int)1), (Object)Character.valueOf('H'));
    }

    public static boolean isHetAtom(Atom atom) {
        return Struct.isHetGroup(atom.getGroup());
    }

    public static boolean isHetGroup(Group group) {
        if (group == null) {
            return false;
        }
        return ScriptBytecodeAdapter.compareEqual((Object)GroupType.HETATM, (Object)group.getType());
    }

    public static List<Group> getGroups(Structure struc) {
        ArrayList<Group> res = new ArrayList<Group>();
        GroupIterator gi = new GroupIterator(struc);
        while (gi.hasNext()) {
            Group g = gi.next();
            res.add(g);
        }
        return res;
    }

    public static boolean isAminoAcidGroup(Group g) {
        return ScriptBytecodeAdapter.compareEqual((Object)g.getType(), (Object)GroupType.AMINOACID);
    }

    public static boolean isProteinChainGroup(Group g) {
        return Struct.isAminoAcidGroup(g) && g.getChainId() != null;
    }

    public static boolean isLigandGroup(Group g) {
        return Struct.isHetGroup(g) && !"HOH".equals(g.getPDBName());
    }

    public static List<Group> getLigandGroups(Structure struc) {
        public final class _getLigandGroups_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLigandGroups_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Struct.isLigandGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLigandGroups_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(Struct.getGroups(struc), (Closure)new _getLigandGroups_closure4(Struct.class, Struct.class)));
    }

    public static List<Group> getHetGroups(Structure struc) {
        public final class _getHetGroups_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getHetGroups_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Struct.isHetGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getHetGroups_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(Struct.getGroups(struc), (Closure)new _getHetGroups_closure5(Struct.class, Struct.class)));
    }

    public static List<Group> getProteinChainGroups(Structure struc) {
        public final class _getProteinChainGroups_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getProteinChainGroups_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Struct.isProteinChainGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProteinChainGroups_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.findAll(Struct.getGroups(struc), (Closure)new _getProteinChainGroups_closure6(Struct.class, Struct.class)));
    }

    public static List<Atoms> clusterAtoms(Atoms atoms, double clusterDist) {
        return new AtomClusterer(new SLinkClusterer()).clusterAtoms(atoms, clusterDist);
    }

    public static List<Atoms> clusterAtomGroups(List<Atoms> atomGroups, double clusterDist) {
        return new AtomGroupClusterer(new SLinkClusterer()).clusterGroups(atomGroups, clusterDist);
    }

    public static List<Group> sortedGroups(Iterable<Group> groups) {
        return new GroovyObject(Struct.class){
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public int compare(Group left, Group right) {
                Group group = left;
                String string = group != null ? group.getPDBName() : null;
                Group group2 = right;
                Group group3 = left;
                Group group4 = right;
                return ComparisonChain.start().compare((Comparable)((Object)string), (Comparable)((Object)(group2 != null ? group2.getPDBName() : null))).compare((Comparable)(group3 != null ? group3.getResidueNumber() : null), (Comparable)(group4 != null ? group4.getResidueNumber() : null)).result();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, Struct.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }.sortedCopy(groups);
    }

    public static boolean isAminoAcidChain(Chain chain) {
        List aaGroups = chain.getAtomGroups(GroupType.AMINOACID);
        return !aaGroups.isEmpty();
    }

    public static List<Residue> getResiduesFromChain(Chain chain) {
        public final class _getResiduesFromChain_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getResiduesFromChain_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Group)it).getType(), (Object)GroupType.AMINOACID) || ((Group)it).getPDBName().startsWith("UNK");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getResiduesFromChain_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List groups = DefaultGroovyMethods.findAll((List)chain.getAtomGroups(), (Closure)new _getResiduesFromChain_closure7(Struct.class, Struct.class));
        public final class _getResiduesFromChain_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getResiduesFromChain_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Residue.fromGroup((Group)ScriptBytecodeAdapter.castToType((Object)it, Group.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getResiduesFromChain_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List residues = DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect((Iterable)groups, (Closure)new _getResiduesFromChain_closure8(Struct.class, Struct.class)));
        int len = residues.size();
        int i = 0;
        while (i != len) {
            if (i > 0) {
                Object object;
                DefaultGroovyMethods.getAt((List)residues, (int)(i - 1));
                ((Residue)DefaultGroovyMethods.getAt((List)residues, (int)i)).setPreviousInChain((Residue)ScriptBytecodeAdapter.castToType((Object)object, Residue.class));
            }
            if (i < len - 1) {
                Object object;
                DefaultGroovyMethods.getAt((List)residues, (int)(i + 1));
                ((Residue)DefaultGroovyMethods.getAt((List)residues, (int)i)).setNextInChain((Residue)ScriptBytecodeAdapter.castToType((Object)object, Residue.class));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return residues;
    }

    public static ResidueChain toResidueChain(Chain chain) {
        return new ResidueChain(chain.getChainID(), Struct.getResiduesFromChain(chain));
    }

    public static List<ResidueChain> residueChainsFromStructure(Structure struc) {
        public final class _residueChainsFromStructure_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _residueChainsFromStructure_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Struct.isAminoAcidChain((Chain)ScriptBytecodeAdapter.castToType((Object)it, Chain.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _residueChainsFromStructure_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _residueChainsFromStructure_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _residueChainsFromStructure_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Struct.toResidueChain((Chain)ScriptBytecodeAdapter.castToType((Object)it, Chain.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _residueChainsFromStructure_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.asList((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll((List)struc.getChains(), (Closure)new _residueChainsFromStructure_closure9(Struct.class, Struct.class)), (Closure)new _residueChainsFromStructure_closure10(Struct.class, Struct.class)));
    }

    public static final Structure reduceStructureToModel(Structure s, int modelId) throws StructureException {
        StructureImpl newS = new StructureImpl();
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(s.getName());
        newS.setSSBonds(s.getSSBonds());
        newS.setDBRefs(s.getDBRefs());
        newS.setSites(s.getSites());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.setCompounds(s.getCompounds());
        newS.setConnections(s.getConnections());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        List model = s.getModel(modelId);
        Chain c = null;
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            c = (Chain)ScriptBytecodeAdapter.castToType(iterator.next(), Chain.class);
            newS.addChain(c);
        }
        return newS;
    }

    public static final Structure reduceStructureToModel0(Structure s) {
        if (s.nrModels() == 1) {
            return s;
        }
        return Struct.reduceStructureToModel(s, 0);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Struct.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Struct.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Struct.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Struct.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.geom.Struct");
    }
}

