/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.geom;

import com.google.common.collect.Lists;
import cz.siret.prank.geom.Box;
import cz.siret.prank.geom.Point;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.geom.kdtree.AtomKdTree;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.ATimer;
import cz.siret.prank.utils.CutoffAtomsCallLog;
import cz.siret.prank.utils.PerfUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomIterator;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Atoms
implements Iterable<Atom> {
    private static final Logger log = LoggerFactory.getLogger(Atoms.class);
    private static final int KD_TREE_THRESHOLD = 15;
    public final List<Atom> list;
    private Map<Integer, Atom> index;
    private AtomKdTree kdTree;
    private Atom centerOfMass;

    public Atoms() {
        this.list = new ArrayList<Atom>();
    }

    public Atoms(int initialCapacity) {
        this.list = new ArrayList<Atom>(initialCapacity);
    }

    public Atoms(List<? extends Atom> list) {
        if (list == null) {
            throw new AssertionError();
        }
        this.list = list;
    }

    public Atoms(Collection<? extends Atom> collection) {
        if (collection == null) {
            throw new AssertionError();
        }
        this.list = new ArrayList<Atom>(collection.size());
        this.list.addAll(collection);
    }

    public static Atoms copyPoints(Atom ... atoms) {
        Atoms res = new Atoms(atoms.length);
        for (Atom a : atoms) {
            res.add(new Point(a.getCoords()));
        }
        return res;
    }

    public Atoms toPoints() {
        return Atoms.copyPoints(this.list.toArray(new Atom[0]));
    }

    public List<Integer> getIndexes() {
        return this.list.stream().map(Atom::getPDBserial).collect(Collectors.toList());
    }

    public Atoms(Atom atom) {
        this(Lists.newArrayList((Object[])new Atom[]{atom}));
    }

    public Atoms(Atoms atoms) {
        this(atoms.list);
    }

    public Atoms withIndex() {
        this.index = new HashMap<Integer, Atom>(this.list.size());
        for (Atom a : this.list) {
            this.index.put(a.getPDBserial(), a);
        }
        return this;
    }

    public Atoms withKdTreeConditional() {
        if (this.getCount() > 15 && (this.kdTree == null || this.kdTree.size() != this.getCount())) {
            this.buildKdTree();
        }
        return this;
    }

    public Atoms withKdTree() {
        if (this.kdTree == null) {
            this.buildKdTree();
        }
        return this;
    }

    public Atoms buildKdTree() {
        this.kdTree = AtomKdTree.build(this);
        return this;
    }

    public AtomKdTree getKdTree() {
        return this.kdTree;
    }

    @Override
    public Iterator<Atom> iterator() {
        return this.list.iterator();
    }

    public boolean contains(Atom a) {
        this.withIndex();
        return this.index.containsKey(a.getPDBserial());
    }

    public Atom getByID(int id) {
        return this.index.get(id);
    }

    public int getCount() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public double dist(Atom a) {
        if (this.kdTree != null && this.getCount() > 15) {
            return this.kdTree.nearestDist(a);
        }
        return Struct.dist(a, this.list);
    }

    public double sqrDist(Atom a) {
        if (this.kdTree != null && this.getCount() > 15) {
            return this.kdTree.nearestSqrDist(a);
        }
        return Struct.sqrDist(a, this.list);
    }

    public double dist(Atoms toAtoms) {
        double sqrMin = Double.POSITIVE_INFINITY;
        for (Atom a : toAtoms) {
            double next = this.sqrDist(a);
            if (!(next < sqrMin)) continue;
            sqrMin = next;
        }
        return Math.sqrt(sqrMin);
    }

    public boolean areWithinDistance(Atom a, double dist) {
        if (this.kdTree != null && this.getCount() > 15) {
            return this.kdTree.nearestDist(a) <= dist;
        }
        return Struct.areWithinDistance(a, this.list, dist);
    }

    public boolean areWithinDistance(Atoms toAtoms, double dist) {
        return Atoms.areWithinDistance(this, toAtoms, dist);
    }

    private static boolean areWithinDistance(Atoms aa, Atoms ab, double dist) {
        Atoms smaller;
        Atoms bigger;
        if (ab.getCount() > aa.getCount()) {
            bigger = ab;
            smaller = aa;
        } else {
            bigger = aa;
            smaller = ab;
        }
        bigger.withKdTreeConditional();
        for (Atom a : smaller) {
            if (!bigger.areWithinDistance(a, dist)) continue;
            return true;
        }
        return false;
    }

    public boolean areDistantFromAtomAtLeast(Atom a, double dist) {
        return Struct.areDistantAtLeast(a, this.list, dist);
    }

    public Atom getCenterOfMass() {
        if (this.list.isEmpty()) {
            return null;
        }
        if (this.centerOfMass == null) {
            Atom[] aa = new Atom[this.list.size()];
            aa = this.list.toArray(aa);
            this.centerOfMass = Calc.centerOfMass((Atom[])aa);
        }
        return this.centerOfMass;
    }

    public List<Group> getDistinctGroupsSorted() {
        return Struct.sortedGroups(this.getDistinctGroups());
    }

    public List<Group> getDistinctGroups() {
        HashSet<Group> res = new HashSet<Group>();
        for (Atom a : this.list) {
            if (a.getGroup() == null) continue;
            res.add(a.getGroup());
        }
        return new ArrayList<Group>(res);
    }

    public void add(Atom a) {
        this.list.add(a);
        if (this.kdTree != null) {
            this.kdTree.add(a);
        }
    }

    public Atoms addAll(Atoms atoms) {
        this.list.addAll(atoms.list);
        if (this.kdTree != null) {
            this.kdTree.addAll(atoms);
        }
        return this;
    }

    public Atoms addAll(Collection<Atoms> col) {
        for (Atoms a : col) {
            this.addAll(a);
        }
        return this;
    }

    public static Atoms join(Collection<Atoms> col) {
        return new Atoms().addAll(col);
    }

    public Atoms joinWith(Atoms atoms) {
        ArrayList<Atom> newlist = new ArrayList<Atom>(this.list.size() + atoms.getCount());
        newlist.addAll(this.list);
        newlist.addAll(atoms.list);
        return new Atoms((List<? extends Atom>)newlist);
    }

    public Atoms plus(Atoms atoms) {
        return this.joinWith(atoms);
    }

    public static Atoms union(Atoms ... aa) {
        return Atoms.union(Arrays.asList(aa));
    }

    public static Atoms union(Collection<Atoms> aa) {
        HashSet<Atom> res = new HashSet<Atom>(100);
        for (Atoms a : aa) {
            if (a == null) continue;
            res.addAll(a.list);
        }
        return new Atoms(res);
    }

    public static Atoms intersection(Atoms aa, Atoms bb) {
        HashSet<Atom> bset = new HashSet<Atom>(bb.list);
        ArrayList<Atom> res = new ArrayList<Atom>(aa.getCount());
        for (Atom a : aa) {
            if (!bset.contains(a)) continue;
            res.add(a);
        }
        return new Atoms((List<? extends Atom>)res);
    }

    public Atoms cutoutShell(Atoms aroundAtoms, double dist) {
        if (aroundAtoms == null || aroundAtoms.isEmpty()) {
            return new Atoms(0);
        }
        if (aroundAtoms.getCount() == 1) {
            Atom center = aroundAtoms.list.get(0);
            return this.cutoutSphere(center, dist);
        }
        Box box = Box.aroundAtoms(aroundAtoms);
        Atom center = box.getCenter();
        double additionalDist = Struct.dist(center, box.getMax());
        Atoms ofAtoms = this.cutoutSphere(center, dist + additionalDist);
        return Atoms.cutoutShell(ofAtoms, aroundAtoms, dist);
    }

    public static Atoms cutoutShell(Atoms ofAtoms, Atoms aroundAtoms, double dist) {
        if (aroundAtoms == null || aroundAtoms.isEmpty()) {
            return new Atoms(0);
        }
        aroundAtoms.withKdTreeConditional();
        Atoms res = new Atoms(128);
        double sqrDist = dist * dist;
        for (Atom a : ofAtoms) {
            if (!(aroundAtoms.sqrDist(a) <= sqrDist)) continue;
            res.add(a);
        }
        return res;
    }

    public Atoms cutSphere_(Atom distanceTo, double dist) {
        ATimer timer = ATimer.startTimer();
        Atoms res = this.cutoutSphere(distanceTo, dist);
        CutoffAtomsCallLog.INST.addCall(this.getCount(), res.getCount(), timer.getTime());
        return res;
    }

    public Atoms cutoutSphereSerial(Atom center, double radius) {
        ArrayList<Atom> res = new ArrayList<Atom>();
        double sqrDist = radius * radius;
        double[] toCoords = center.getCoords();
        for (Atom a : this.list) {
            if (!(PerfUtils.sqrDist(a.getCoords(), toCoords) <= sqrDist)) continue;
            res.add(a);
        }
        return new Atoms((List<? extends Atom>)res);
    }

    public Atoms cutoutSphereKD(Atom center, double radius) {
        this.withKdTree();
        return this.kdTree.findAtomsWithinRadius(center, radius, false);
    }

    public Atoms cutoutSphere(Atom center, double radius) {
        if (this.getCount() >= Params.INSTANCE.getUse_kdtree_cutout_sphere_thrashold()) {
            return this.cutoutSphereKD(center, radius);
        }
        return this.cutoutSphereSerial(center, radius);
    }

    public Atoms cutoutBox(Box box) {
        return new Atoms(Struct.cutoffAtomsInBox(this.list, box));
    }

    public Atoms withoutHydrogens() {
        return Atoms.withoutHydrogenAtoms(this);
    }

    public Atoms without(Atoms remove) {
        ArrayList<Atom> res = new ArrayList<Atom>(this.list.size());
        for (Atom a : this.list) {
            if (remove.contains(a)) continue;
            res.add(a);
        }
        return new Atoms((List<? extends Atom>)res);
    }

    public static Atoms consolidate(Atoms atoms, double dist) {
        Atoms res = new Atoms().buildKdTree();
        dist *= dist;
        for (Atom a : atoms) {
            Atom nearest = res.kdTree.findNearest(a);
            if (nearest != null && !(Struct.sqrDist(a, nearest) > dist)) continue;
            res.add(a);
        }
        return res;
    }

    public static Atoms allFromStructure(Structure struc) {
        ArrayList<Atom> list = new ArrayList<Atom>(3000);
        AtomIterator atomIterator = new AtomIterator(struc);
        while (atomIterator.hasNext()) {
            list.add(atomIterator.next());
        }
        return new Atoms((List<? extends Atom>)list);
    }

    public static Atoms withoutHydrogenAtoms(Atoms atoms) {
        Atoms res = new Atoms(atoms.getCount());
        for (Atom a : atoms) {
            if (Struct.isHydrogenAtom(a)) continue;
            res.add(a);
        }
        return res;
    }

    public static Atoms onlyProteinAtoms(Atoms structAtoms) {
        ArrayList<Atom> res = new ArrayList<Atom>(structAtoms.getCount());
        for (Atom a : structAtoms) {
            if (!Struct.isProteinChainGroup(a.getGroup())) continue;
            res.add(a);
        }
        return new Atoms((List<? extends Atom>)res);
    }

    public static Atoms onlyProteinAtoms(Structure struc) {
        return Atoms.onlyProteinAtoms(Atoms.allFromStructure(struc));
    }

    public static Atoms allFromGroup(Group group) {
        return new Atoms(group.getAtoms());
    }

    public static Atoms allFromGroups(List<? extends Group> groups) {
        Atoms res = new Atoms();
        for (Group group : groups) {
            res.list.addAll(group.getAtoms());
        }
        return res;
    }

    public static Atoms allFromChain(Chain chain) {
        return Atoms.allFromGroups(chain.getAtomGroups());
    }
}

