/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.sequence;

import cz.siret.prank.domain.Residue;
import cz.siret.prank.features.api.ResidueFeatureCalculationContext;
import cz.siret.prank.features.api.ResidueFeatureCalculator;
import cz.siret.prank.features.tables.PropertyTable;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripletsPropensityFeature
extends ResidueFeatureCalculator
implements Parametrized {
    private static final String PROPERTY = "propensity";
    private PropertyTable table;
    private static List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public TripletsPropensityFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return "triplets";
    }

    @Override
    public List<String> getHeader() {
        return HEADER;
    }

    public PropertyTable getTable() {
        if (this.table == null) {
            PropertyTable propertyTable;
            this.table = propertyTable = PropertyTable.parse(Futils.readResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getParams().getPept_propensities_set()}, new String[]{"/tables/peptides/", "/triplets.csv"}))));
        }
        return this.table;
    }

    @Override
    public double[] calculateForResidue(Residue residue, ResidueFeatureCalculationContext context) {
        double prop = this.calculatePropensityForResidue(residue);
        return new double[]{prop};
    }

    public double calculatePropensityForResidue(@Nullable Residue res) {
        String code = Residue.safeSorted3CodeFor(res);
        double prop = this.getTable().getValueOrDefault(code, PROPERTY, 0.0);
        return prop;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TripletsPropensityFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(ResidueFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        List list;
        HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"prop"});
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.sequence.TripletsPropensityFeature");
        Parametrized.Trait.Helper.$static$init$(TripletsPropensityFeature.class);
    }

    @Generated
    public static String getPROPERTY() {
        return PROPERTY;
    }

    @Generated
    public void setTable(PropertyTable propertyTable) {
        this.table = propertyTable;
    }

    @Generated
    public static List<String> getHEADER() {
        return HEADER;
    }

    @Generated
    public static void setHEADER(List<String> list) {
        HEADER = list;
    }
}

