/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.sequence;

import cz.siret.prank.domain.Residue;
import cz.siret.prank.features.api.ResidueFeatureCalculationContext;
import cz.siret.prank.features.api.ResidueFeatureCalculator;
import cz.siret.prank.features.tables.PropertyTable;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import cz.siret.prank.utils.Futils;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DupletsPropensityFeature
extends ResidueFeatureCalculator
implements Parametrized {
    private static final String PROPERTY = "propensity";
    private PropertyTable table;
    private static List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DupletsPropensityFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return "duplets";
    }

    @Override
    public List<String> getHeader() {
        return HEADER;
    }

    public PropertyTable getTable() {
        if (this.table == null) {
            PropertyTable propertyTable;
            this.table = propertyTable = PropertyTable.parse(Futils.readResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getParams().getPept_propensities_set()}, new String[]{"/tables/peptides/", "/duplets.csv"}))));
        }
        return this.table;
    }

    @Override
    public double[] calculateForResidue(Residue res, ResidueFeatureCalculationContext context) {
        Residue residue = res;
        String code1 = Residue.safeOrderedCode2(res, residue != null ? residue.getPreviousInChain() : null);
        Residue residue2 = res;
        String code2 = Residue.safeOrderedCode2(res, residue2 != null ? residue2.getNextInChain() : null);
        String property = PROPERTY;
        double val1 = this.getTable().getValueOrDefault(code1, property, 0.0);
        double val2 = this.getTable().getValueOrDefault(code2, property, 0.0);
        double product = val1 * val2;
        if (val1 == 0.0) {
            double d;
            product = d = val2 * val2;
        } else if (val2 == 0.0) {
            double d;
            product = d = val1 * val1;
        }
        double sum = val1 + val2;
        double max = Math.max(val1, val2);
        return new double[]{product};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DupletsPropensityFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(ResidueFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        List list;
        HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"product"});
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.sequence.DupletsPropensityFeature");
        Parametrized.Trait.Helper.$static$init$(DupletsPropensityFeature.class);
    }

    @Generated
    public static String getPROPERTY() {
        return PROPERTY;
    }

    @Generated
    public void setTable(PropertyTable propertyTable) {
        this.table = propertyTable;
    }

    @Generated
    public static List<String> getHEADER() {
        return HEADER;
    }

    @Generated
    public static void setHEADER(List<String> list) {
        HEADER = list;
    }
}

