/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.residue;

import cz.siret.prank.domain.Residue;
import cz.siret.prank.features.api.ResidueFeatureCalculationContext;
import cz.siret.prank.features.api.ResidueFeatureCalculator;
import cz.siret.prank.geom.Atoms;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class ContactResiduesRF
extends ResidueFeatureCalculator {
    private static final double CONTACT_ATOM_DIST = 3.3;
    private final List<String> HEADER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ContactResiduesRF() {
        MetaClass metaClass;
        List list;
        this.HEADER = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"n", "n_atoms", "n_head", "n_side"});
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String getName() {
        return "contactres";
    }

    @Override
    public List<String> getHeader() {
        return this.HEADER;
    }

    @Override
    public double[] calculateForResidue(Residue residue, ResidueFeatureCalculationContext context) {
        Atoms contactAtoms = context.getProtein().getProteinAtoms().cutoutShell(residue.getAtoms(), CONTACT_ATOM_DIST).without(residue.getAtoms());
        Atoms headCa = contactAtoms.cutoutShell(residue.getHeadAtoms(), CONTACT_ATOM_DIST);
        Atoms sideCa = contactAtoms.cutoutShell(residue.getSideChainAtoms(), CONTACT_ATOM_DIST);
        double n = context.getProtein().getResidues().getDistinctForAtoms(contactAtoms).size();
        double n_atoms = contactAtoms.getCount();
        double n_head = context.getProtein().getResidues().getDistinctForAtoms(headCa).size();
        double n_side = context.getProtein().getResidues().getDistinctForAtoms(sideCa).size();
        return new double[]{n, n_atoms, n_head, n_side};
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContactResiduesRF.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static double getCONTACT_ATOM_DIST() {
        return CONTACT_ATOM_DIST;
    }

    @Generated
    public final List<String> getHEADER() {
        return this.HEADER;
    }
}

