/*
 * Decompiled with CFR 0.152.
 */
package cz.siret.prank.features.implementation.histogram;

import cz.siret.prank.features.api.SasFeatureCalculationContext;
import cz.siret.prank.features.api.SasFeatureCalculator;
import cz.siret.prank.features.implementation.histogram.DistancePairHist;
import cz.siret.prank.geom.Atoms;
import cz.siret.prank.geom.Struct;
import cz.siret.prank.program.params.Parametrized;
import cz.siret.prank.program.params.Params;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import java.util.Random;
import org.biojava.nbio.structure.Atom;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairHistogramFeature
extends SasFeatureCalculator
implements Parametrized {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PairHistogramFeature() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Parametrized.Trait.Helper.$init$(this);
    }

    @Override
    public String getName() {
        return "pair_hist";
    }

    @Override
    public List<String> getHeader() {
        int n = this.getParams().getPair_hist_bins();
        public final class _getHeader_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getHeader_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)((PairHistogramFeature)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PairHistogramFeature.class)).getName(), (CharSequence)"."), (Object)it);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getHeader_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.toList((Iterable)DefaultGroovyMethods.collect((Iterable)new IntRange(true, 1, n), (Closure)new _getHeader_closure1(this, this)));
    }

    private Atoms getAtoms(Atom sasPoint, SasFeatureCalculationContext context) {
        if (this.getParams().getPair_hist_deep()) {
            return context.getExtractor().getDeepLayer().cutoutSphere(sasPoint, this.getParams().getPair_hist_radius());
        }
        return context.getProtein().getExposedAtoms().cutoutSphere(sasPoint, this.getParams().getPair_hist_radius());
    }

    @Override
    public double[] calculateForSasPoint(Atom sasPoint, SasFeatureCalculationContext context) {
        List<Atom> atoms = this.getAtoms((Atom)sasPoint, (SasFeatureCalculationContext)context).list;
        DistancePairHist hist = new DistancePairHist(this.getParams().getPair_hist_bins(), 0.0, this.getParams().getPair_hist_radius() * (double)2, this.getParams().getPair_hist_smooth());
        int n = atoms.size();
        if (this.getParams().getPair_hist_subsample_limit() == 0 || ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.getParams().getPair_hist_subsample_limit(), (Object)NumberNumberDiv.div((Number)(n * (n - 1)), (Number)2))) {
            int i = 0;
            while (i != n) {
                int j = i;
                while (j != n) {
                    hist.add(Struct.dist((Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(atoms, (int)i), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(atoms, (int)j), Atom.class)));
                    int cfr_ignored_0 = j + 1;
                }
                int cfr_ignored_1 = i + 1;
            }
        } else {
            Random rand = new Random(this.getParams().getSeed());
            int limit = this.getParams().getPair_hist_subsample_limit();
            int c = 0;
            while (c < limit) {
                int i = rand.nextInt(n);
                int j = rand.nextInt(n);
                hist.add(Struct.dist((Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(atoms, (int)i), Atom.class), (Atom)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(atoms, (int)j), Atom.class)));
                int n2 = c;
                int cfr_ignored_2 = n2 + 1;
            }
        }
        double[] bins = hist.getBins();
        if (this.getParams().getPair_hist_normalize()) {
            double[] dArray = hist.getNormalizedBins();
            bins = dArray;
        }
        return bins;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PairHistogramFeature.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Traits.TraitBridge(traitClass=Parametrized.class, desc="()Lcz/siret/prank/program/params/Params;")
    public Params getParams() {
        return Parametrized.Trait.Helper.getParams(this);
    }

    public /* synthetic */ Params cz_siret_prank_program_params_Parametrizedtrait$super$getParams() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Params)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParams", (Object)new Object[0]), Params.class);
        }
        return (Params)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(SasFeatureCalculator.class, (GroovyObject)this, (String)"getParams"), Params.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"cz.siret.prank.features.implementation.histogram.PairHistogramFeature");
        Parametrized.Trait.Helper.$static$init$(PairHistogramFeature.class);
    }
}

